/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.compiler.message;

import com.cognos.xts.compiler.message.XTSMessage;
import com.cognos.xts.util.xmlutil;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class XTSMessageSAXHandler
extends DefaultHandler
implements LexicalHandler {
    private HashMap m_map = null;
    private static final String CCL_STRING = "string";
    private static final String CCL_STRING_ID = "id";
    private static final String CCL_PARAM = "param";
    private static final String CCL_PARAM_NAME = "name";
    private static final String LEXICALHANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private static final int BUFFER_SIZE = 4096;
    private NamespaceSupport m_ns = new NamespaceSupport();
    private String m_currentEntity = null;
    private int m_curLevel = 0;
    private boolean m_inString = false;
    private boolean m_inParam = false;
    private XTSMessage m_curMsg = null;
    private static final char ENTITYREF_START = '&';
    private static final char ENTITYREF_END = ';';
    private static final char[] CDATA_START = new char[]{'<', '!', '[', 'C', 'D', 'A', 'T', 'A', '['};
    private static final char[] CDATA_END = new char[]{']', ']', '>'};

    public XTSMessageSAXHandler() {
        this.m_map = new HashMap();
    }

    public HashMap getMessagesMap() {
        return this.m_map;
    }

    @Override
    public void startDocument() throws SAXException {
        this.m_ns = new NamespaceSupport();
        this.m_currentEntity = null;
        this.m_curLevel = 0;
        this.m_inString = false;
        this.m_inParam = false;
        this.m_curMsg = null;
        this.m_ns.pushContext();
    }

    @Override
    public void endDocument() throws SAXException {
        this.m_ns.popContext();
        this.m_ns = null;
        this.m_currentEntity = null;
        this.m_curLevel = 0;
        this.m_inString = false;
        this.m_inParam = false;
        this.m_curMsg = null;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.m_ns.declarePrefix(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.m_currentEntity = null;
        ++this.m_curLevel;
        if (!this.m_inString) {
            if (qName.equals(CCL_STRING)) {
                this.m_inString = true;
                String id = atts.getValue(CCL_STRING_ID);
                this.m_curMsg = new XTSMessage(id);
            }
        } else if (!this.m_inParam && qName.equals(CCL_PARAM)) {
            this.m_inParam = true;
            String name = atts.getValue(CCL_PARAM_NAME);
            this.m_curMsg.addParam(name);
        }
        this.m_ns.pushContext();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.m_inString) {
            if (this.m_inParam) {
                if (qName.equals(CCL_PARAM)) {
                    this.m_inParam = false;
                }
            } else if (qName.equals(CCL_STRING)) {
                this.m_map.put(this.m_curMsg.getId(), this.m_curMsg);
                this.m_curMsg = null;
                this.m_inString = false;
            }
        }
        this.m_ns.popContext();
        --this.m_curLevel;
        this.m_ns.popContext();
        this.m_ns.pushContext();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.m_inString && !this.m_inParam) {
            if (this.m_currentEntity != null) {
                this.m_curMsg.addText(xmlutil.outEntityReference(this.m_currentEntity, ch, start, length));
            } else {
                this.m_curMsg.addText(ch, start, length);
            }
        }
        this.m_currentEntity = null;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.m_inString && !this.m_inParam) {
            this.m_curMsg.addText(CDATA_START);
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.m_inString && !this.m_inParam) {
            this.m_curMsg.addText(CDATA_END);
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.m_currentEntity = '&' + name + ';';
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }
}

