/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.compiler.message;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.common.cache.XTSCacheException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXParserPool;
import com.cognos.xts.compiler.XTSCompilerException;
import com.cognos.xts.compiler.message.XTSMessageMap;
import com.cognos.xts.compiler.message.XTSMessageMapCache;
import com.cognos.xts.compiler.message.XTSStringSAXHandler;
import com.cognos.xts.configuration.XTSConfigManager;
import com.cognos.xts.configuration.XTSConfigurationException;
import com.cognos.xts.resource.XTSResourceManager;
import com.cognos.xts.util.LocaleUtils;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XTSMessageTransformer {
    private static final int BUFFER_SIZE = 4096;
    private static final Object m_mutex = new Object();
    private static final String LEXICALHANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";

    public static void initialize() throws XTSException {
        XTSMessageMapCache.getInstance().initialize();
    }

    public static void terminate() throws XTSException {
        XTSMessageMapCache.getInstance().terminate();
    }

    public static void reinitialize() throws XTSException {
        XTSMessageTransformer.terminate();
        XTSMessageTransformer.initialize();
    }

    public static Source applyMessage(XTSEnvironment env, Source src, List msgFiles) throws XTSCompilerException, XTSCacheException {
        InputSource source = SAXSource.sourceToInputSource(src);
        return XTSMessageTransformer._applyMessage(env, source, msgFiles, env.getLookupList());
    }

    public static Source applyMessage(XTSEnvironment env, InputSource src, List msgFiles) throws XTSCompilerException, XTSCacheException {
        return XTSMessageTransformer._applyMessage(env, src, msgFiles, env.getLookupList());
    }

    public static Source applyMessage(XTSEnvironment env, Source src, List msgFiles, List msgLocales) throws XTSCompilerException, XTSCacheException {
        InputSource source = SAXSource.sourceToInputSource(src);
        return XTSMessageTransformer.applyMessage(env, source, msgFiles, msgLocales);
    }

    public static Source applyMessage(XTSEnvironment env, InputSource src, List msgFiles, List msgLocales) throws XTSCompilerException, XTSCacheException {
        ArrayList lookupList = null;
        if (msgLocales != null && msgLocales.size() > 0) {
            StringBuffer tmpbuf = new StringBuffer();
            tmpbuf.append(LocaleUtils.toNormalizedString((Locale)msgLocales.get(0)));
            for (int i = 1; i < msgLocales.size(); ++i) {
                tmpbuf.append(",").append(LocaleUtils.toNormalizedString((Locale)msgLocales.get(i)));
            }
            Locale inputLocale = LocaleUtils.parseHttpLocaleList(tmpbuf.toString(), false);
            if (inputLocale != null) {
                lookupList = LocaleUtils.createLookupList(inputLocale, false);
            }
        }
        if (lookupList == null) {
            lookupList = env.getLookupList();
        } else {
            lookupList.addAll(env.getLookupList());
        }
        return XTSMessageTransformer._applyMessage(env, src, msgFiles, lookupList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Source _applyMessage(XTSEnvironment env, InputSource src, List msgFiles, List msgLocales) throws XTSCompilerException, XTSCacheException {
        Object[] args;
        String msgFile;
        int i;
        InputSource source = src;
        if (source == null) {
            throw new XTSCompilerException("message.invalidsource");
        }
        ArrayList<XTSMessageMap> msgMaps = new ArrayList<XTSMessageMap>();
        for (i = 0; i < msgFiles.size(); ++i) {
            msgFile = (String)msgFiles.get(i);
            Locale msgLocale = XTSMessageTransformer.calculateMessageFileName(env, msgFile, msgLocales);
            if (msgLocale == null) {
                Object[] args2 = new String[]{msgFile};
                throw new XTSCompilerException("message.messagefilemissing", args2);
            }
            HashMap<String, Object> atts = new HashMap<String, Object>();
            atts.put("path", msgFile);
            atts.put("locale", msgLocale);
            XTSMessageMap msgMap = (XTSMessageMap)XTSMessageMapCache.getInstance().getObject(env, atts);
            msgMaps.add(msgMap);
        }
        for (i = 0; i < msgFiles.size(); ++i) {
            msgFile = (String)msgFiles.get(i);
            ArrayList<Locale> defaultLocale = new ArrayList<Locale>();
            defaultLocale.add(Locale.ENGLISH);
            Locale msgLocale = XTSMessageTransformer.calculateMessageFileName(env, msgFile, defaultLocale);
            if (msgLocale == null) continue;
            HashMap<String, Object> atts = new HashMap<String, Object>();
            atts.put("path", msgFile);
            atts.put("locale", msgLocale);
            XTSMessageMap msgMap = (XTSMessageMap)XTSMessageMapCache.getInstance().getObject(env, atts);
            msgMaps.add(msgMap);
        }
        StringWriter writer = new StringWriter(4096);
        StreamResult result = new StreamResult(writer);
        XTSStringSAXHandler handler = new XTSStringSAXHandler(msgMaps, result);
        try {
            AXTSPoolObject parser = XTSSAXParserPool.getInstance().acquire();
            try {
                XMLReader reader = ((SAXParser)parser.get()).getXMLReader();
                reader.setContentHandler(handler);
                reader.setProperty(LEXICALHANDLER_PROPERTY, handler);
                reader.parse(source);
            }
            finally {
                XTSSAXParserPool.getInstance().put(parser);
            }
        }
        catch (SAXException e) {
            args = new String[]{msgFiles.toString()};
            throw new XTSCacheException("message.transformfailed", args, e);
        }
        catch (IOException e) {
            args = new String[]{msgFiles.toString()};
            throw new XTSCacheException("message.transformfailed", args, e);
        }
        catch (XTSException e) {
            args = new String[]{msgFiles.toString()};
            throw new XTSCacheException("message.transformfailed", args, e);
        }
        return new StreamSource(new StringReader(writer.toString()));
    }

    private static List createSearchListFromRequestLocale(Locale locale) {
        ArrayList<Locale> searchlist = new ArrayList<Locale>();
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        searchlist.add(new Locale(lang, country));
        searchlist.add(new Locale(lang, ""));
        try {
            Locale serverLocale = XTSConfigManager.getInstance().getServerLocale();
            if (serverLocale != null) {
                lang = serverLocale.getLanguage();
                country = serverLocale.getCountry();
                searchlist.add(new Locale(lang, country));
                searchlist.add(new Locale(lang, ""));
            }
        }
        catch (XTSConfigurationException xTSConfigurationException) {
            // empty catch block
        }
        searchlist.add(new Locale("en", ""));
        return searchlist;
    }

    private static Locale calculateMessageFileName(XTSEnvironment env, String msgFile, List lookupList) {
        String sMsgFileName = "";
        String sMsgFileExt = "";
        int dot = msgFile.lastIndexOf(46);
        if (dot != -1) {
            sMsgFileName = msgFile.substring(0, dot);
            sMsgFileExt = msgFile.substring(dot);
        } else {
            sMsgFileName = msgFile;
            sMsgFileExt = "";
        }
        if (lookupList == null) {
            lookupList = XTSMessageTransformer.createSearchListFromRequestLocale(env.getLocale());
        }
        for (int i = 0; i < lookupList.size(); ++i) {
            try {
                Locale locale = (Locale)lookupList.get(i);
                StringBuffer tmp = new StringBuffer().append(sMsgFileName).append("_").append(LocaleUtils.toNormalizedString(locale)).append(sMsgFileExt);
                if (!XTSResourceManager.getInstance().exists(tmp.toString())) continue;
                return locale;
            }
            catch (XTSException xTSException) {
                // empty catch block
            }
        }
        return null;
    }
}

