/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.compiler.message;

import com.cognos.xts.compiler.message.XTSMessage;
import com.cognos.xts.compiler.message.XTSMessageMap;
import com.cognos.xts.compiler.message.XTSString;
import com.cognos.xts.util.xmlutil;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class XTSStringSAXHandler
extends DefaultHandler
implements LexicalHandler {
    ArrayList m_msgMaps = null;
    boolean m_sax = false;
    Result m_result = null;
    SAXResult m_SAXResult = null;
    StreamResult m_StreamResult = null;
    private static final String XTS_NS_URI = "http://developer.cognos.com/schemas/xts/";
    private static final String XTS_STRING = "string";
    private static final String XTS_STRING_ID = "id";
    private static final String XTS_STRING_ENCODE = "encode";
    private static final String XTS_PARAM = "param";
    private static final String XTS_PARAM_NAME = "name";
    private static final String LEXICALHANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private static final int BUFFER_SIZE = 4096;
    private static final int PARAM_BUFFER_SIZE = 256;
    private NamespaceSupport m_ns = new NamespaceSupport();
    private String m_currentEntity = null;
    private int m_curLevel = 0;
    private boolean m_inString = false;
    private boolean m_inParam = false;
    private StringBuffer m_paramBuf = null;
    private int m_recordLevel = 0;
    private XTSString m_curString = null;
    private String m_curParamName = null;
    private static final char OPEN_BRACKET_START = '<';
    private static final char OPEN_BRACKET_END = '>';
    private static final char[] CLOSE_BRACKET_START = new char[]{'<', '/'};
    private static final char CLOSE_BRACKET_END = '>';
    private static final char[] PROCESSING_INSTRUCTION_START = new char[]{'<', '?'};
    private static final char[] PROCESSING_INSTRUCTION_END = new char[]{'?', '>'};
    private static final char[] XMLNS = new char[]{'x', 'm', 'l', 'n', 's'};
    private static final char EQUALS = '=';
    private static final char QUOTE = '\"';
    private static final char SPACE = ' ';
    private static final char COLON = ':';
    private static final char ENTITYREF_START = '&';
    private static final char ENTITYREF_END = ';';
    private static final char[] CDATA_START = new char[]{'<', '!', '[', 'C', 'D', 'A', 'T', 'A', '['};
    private static final char[] CDATA_END = new char[]{']', ']', '>'};

    public XTSStringSAXHandler(ArrayList msgMaps, Result result) {
        this.m_msgMaps = msgMaps;
        this.m_result = result;
        if (!(result instanceof StreamResult)) {
            if (result instanceof SAXResult) {
                throw new UnsupportedOperationException("SAXResult is currently not supported!");
            }
            throw new UnsupportedOperationException("DOMResult is currently not supported!");
        }
        this.m_StreamResult = (StreamResult)result;
    }

    @Override
    public void startDocument() throws SAXException {
        this.m_ns = new NamespaceSupport();
        this.m_currentEntity = null;
        this.m_curLevel = 0;
        this.m_inString = false;
        this.m_inParam = false;
        this.m_paramBuf = null;
        this.m_recordLevel = 0;
        this.m_curString = null;
        this.m_curParamName = null;
        this.m_ns.pushContext();
    }

    @Override
    public void endDocument() throws SAXException {
        this.m_ns.popContext();
        this.m_ns = null;
        this.m_currentEntity = null;
        this.m_curLevel = 0;
        this.m_inString = false;
        this.m_inParam = false;
        this.m_paramBuf = null;
        this.m_recordLevel = 0;
        this.m_curString = null;
        this.m_curParamName = null;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.m_ns.declarePrefix(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.m_currentEntity = null;
        ++this.m_curLevel;
        if (!this.m_inString) {
            if (localName.equals(XTS_STRING) && uri.equals(XTS_NS_URI)) {
                this.m_inString = true;
                String id = atts.getValue(XTS_STRING_ID);
                String encode = atts.getValue(XTS_STRING_ENCODE);
                this.m_curString = new XTSString(id, encode);
            } else {
                this.writeStartElement(qName, atts);
            }
        } else if (!this.m_inParam) {
            if (localName.equals(XTS_PARAM) && uri.equals(XTS_NS_URI)) {
                this.m_inParam = true;
                this.m_paramBuf = new StringBuffer(256);
                this.m_curParamName = atts.getValue(XTS_PARAM_NAME);
            }
        } else {
            this.writeStartElement(this.m_paramBuf, qName, atts);
        }
        this.m_ns.pushContext();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.m_inString) {
            if (this.m_inParam) {
                if (localName.equals(XTS_PARAM) && uri.equals(XTS_NS_URI)) {
                    this.m_curString.addParam(this.m_curParamName, this.m_paramBuf.toString());
                    this.m_paramBuf = null;
                    this.m_curParamName = null;
                    this.m_inParam = false;
                } else {
                    this.writeEndElement(this.m_paramBuf, qName);
                }
            } else if (localName.equals(XTS_STRING) && uri.equals(XTS_NS_URI)) {
                this.writeXTSString(this.m_curString);
                this.m_curString = null;
                this.m_inString = false;
            }
        } else {
            this.writeEndElement(qName);
        }
        this.m_ns.popContext();
        --this.m_curLevel;
        this.m_ns.popContext();
        this.m_ns.pushContext();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.m_inString) {
            if (this.m_inParam) {
                if (this.m_currentEntity != null) {
                    this.writeText(this.m_paramBuf, xmlutil.outEntityReference(this.m_currentEntity, ch, start, length));
                } else {
                    this.writeText(this.m_paramBuf, ch, start, length);
                }
            }
        } else if (this.m_currentEntity != null) {
            this.writeText(xmlutil.outEntityReference(this.m_currentEntity, ch, start, length));
        } else {
            this.writeText(ch, start, length);
        }
        this.m_currentEntity = null;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.m_inString) {
            if (this.m_inParam) {
                this.writePI(this.m_paramBuf, target, data);
            }
        } else {
            this.writePI(target, data);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.m_inString) {
            if (this.m_inParam) {
                this.writeText(this.m_paramBuf, CDATA_START);
            }
        } else {
            this.writeText(CDATA_START);
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.m_inString) {
            if (this.m_inParam) {
                this.writeText(this.m_paramBuf, CDATA_END);
            }
        } else {
            this.writeText(CDATA_START);
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.m_currentEntity = '&' + name + ';';
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    private void writeXTSString(XTSString str) throws SAXException {
        if (this.m_StreamResult == null) {
            if (this.m_SAXResult != null) {
                throw new UnsupportedOperationException("SAXResult is currently not supported!");
            }
            throw new UnsupportedOperationException("DOMResult is currently not supported!");
        }
        this.writeXTSString(this.m_StreamResult.getWriter(), str);
    }

    private void writeXTSString(Writer writer, XTSString str) throws SAXException {
        try {
            XTSMessage msg = null;
            for (int i = 0; i < this.m_msgMaps.size() && (msg = ((XTSMessageMap)this.m_msgMaps.get(i)).getXTSMessage(str.getId())) == null; ++i) {
            }
            if (msg != null) {
                writer.write(msg.convert(str));
            } else {
                writer.write(str.toXMLString());
            }
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage());
        }
    }

    private void writeStartElement(String qName, Attributes atts) throws SAXException {
        if (this.m_StreamResult == null) {
            if (this.m_SAXResult != null) {
                throw new UnsupportedOperationException("SAXResult is currently not supported!");
            }
            throw new UnsupportedOperationException("DOMResult is currently not supported!");
        }
        this.writeStartElement(this.m_StreamResult.getWriter(), qName, atts);
    }

    private void writeStartElement(Writer writer, String qName, Attributes atts) throws SAXException {
        try {
            writer.write(60);
            writer.write(qName);
            Enumeration<String> myEnum = this.m_ns.getDeclaredPrefixes();
            while (myEnum.hasMoreElements()) {
                String ns_prefix = myEnum.nextElement();
                String ns_uri = this.m_ns.getURI(ns_prefix);
                writer.write(32);
                writer.write(XMLNS);
                if (ns_prefix != null && ns_prefix.length() > 0) {
                    writer.write(58);
                    writer.write(ns_prefix);
                }
                writer.write(61);
                writer.write(34);
                writer.write(ns_uri);
                writer.write(34);
            }
            int attlen = atts.getLength();
            for (int i = 0; i < attlen; ++i) {
                writer.write(32);
                writer.write(atts.getQName(i));
                writer.write(61);
                writer.write(34);
                StringBuffer buf = new StringBuffer();
                xmlutil.xmlencode2(atts.getValue(i), buf);
                writer.write(buf.toString());
                writer.write(34);
            }
            writer.write(62);
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage());
        }
    }

    private void writeStartElement(StringBuffer buffer, String qName, Attributes atts) {
        buffer.append('<');
        buffer.append(qName);
        Enumeration<String> myEnum = this.m_ns.getDeclaredPrefixes();
        while (myEnum.hasMoreElements()) {
            String ns_prefix = myEnum.nextElement();
            String ns_uri = this.m_ns.getURI(ns_prefix);
            buffer.append(' ');
            buffer.append(XMLNS);
            if (ns_prefix != null && ns_prefix.length() > 0) {
                buffer.append(':');
                buffer.append(ns_prefix);
            }
            buffer.append('=');
            buffer.append('\"');
            buffer.append(ns_uri);
            buffer.append('\"');
        }
        int attlen = atts.getLength();
        for (int i = 0; i < attlen; ++i) {
            buffer.append(' ');
            buffer.append(atts.getQName(i));
            buffer.append('=');
            buffer.append('\"');
            StringBuffer buf = new StringBuffer();
            xmlutil.xmlencode2(atts.getValue(i), buf);
            buffer.append(buf.toString());
            buffer.append('\"');
        }
        buffer.append('>');
    }

    private void writeEndElement(String qName) throws SAXException {
        if (this.m_StreamResult == null) {
            if (this.m_SAXResult != null) {
                throw new UnsupportedOperationException("SAXResult is currently not supported!");
            }
            throw new UnsupportedOperationException("DOMResult is currently not supported!");
        }
        this.writeEndElement(this.m_StreamResult.getWriter(), qName);
    }

    private void writeEndElement(Writer writer, String qName) throws SAXException {
        try {
            writer.write(CLOSE_BRACKET_START);
            writer.write(qName);
            writer.write(62);
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage());
        }
    }

    private void writeEndElement(StringBuffer buffer, String qName) {
        buffer.append(CLOSE_BRACKET_START);
        buffer.append(qName);
        buffer.append('>');
    }

    private void writeText(String text) throws SAXException {
        if (this.m_StreamResult == null) {
            if (this.m_SAXResult != null) {
                throw new UnsupportedOperationException("SAXResult is currently not supported!");
            }
            throw new UnsupportedOperationException("DOMResult is currently not supported!");
        }
        this.writeText(this.m_StreamResult.getWriter(), text);
    }

    private void writeText(char[] text) throws SAXException {
        if (this.m_StreamResult == null) {
            if (this.m_SAXResult != null) {
                throw new UnsupportedOperationException("SAXResult is currently not supported!");
            }
            throw new UnsupportedOperationException("DOMResult is currently not supported!");
        }
        this.writeText(this.m_StreamResult.getWriter(), text);
    }

    private void writeText(char[] text, int offset, int count) throws SAXException {
        if (this.m_StreamResult == null) {
            if (this.m_SAXResult != null) {
                throw new UnsupportedOperationException("SAXResult is currently not supported!");
            }
            throw new UnsupportedOperationException("DOMResult is currently not supported!");
        }
        this.writeText(this.m_StreamResult.getWriter(), text, offset, count);
    }

    private void writeText(Writer writer, String text) throws SAXException {
        try {
            writer.write(text);
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage());
        }
    }

    private void writeText(Writer writer, char[] text) throws SAXException {
        try {
            writer.write(text);
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage());
        }
    }

    private void writeText(Writer writer, char[] text, int offset, int count) throws SAXException {
        try {
            writer.write(text, offset, count);
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage());
        }
    }

    private void writeText(StringBuffer buffer, String text) {
        buffer.append(text);
    }

    private void writeText(StringBuffer buffer, char[] text) {
        buffer.append(text);
    }

    private void writeText(StringBuffer buffer, char[] text, int offset, int count) {
        buffer.append(text, offset, count);
    }

    private void writePI(String target, String data) throws SAXException {
        if (this.m_StreamResult == null) {
            if (this.m_SAXResult != null) {
                throw new UnsupportedOperationException("SAXResult is currently not supported!");
            }
            throw new UnsupportedOperationException("DOMResult is currently not supported!");
        }
        this.writePI(this.m_StreamResult.getWriter(), target, data);
    }

    private void writePI(Writer writer, String target, String data) throws SAXException {
        try {
            writer.write(PROCESSING_INSTRUCTION_START);
            writer.write(target);
            writer.write(32);
            writer.write(data);
            writer.write(PROCESSING_INSTRUCTION_END);
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage());
        }
    }

    private void writePI(StringBuffer buffer, String target, String data) throws SAXException {
        buffer.append(PROCESSING_INSTRUCTION_START);
        buffer.append(target);
        buffer.append(' ');
        buffer.append(data);
        buffer.append(PROCESSING_INSTRUCTION_END);
    }
}

