/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.configinfo;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.common.cache.AXTSFastCacheObject;
import com.cognos.xts.common.cache.XTSCacheException;
import com.cognos.xts.configinfo.IXTSCacheConfigInfo;
import com.cognos.xts.configinfo.XTSConfigInfoException;
import com.cognos.xts.configuration.XTSConfigManager;
import com.cognos.xts.configuration.XTSConfigurationException;
import com.cognos.xts.properties.PropertiesManager;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class XTSConfigInfo
extends AXTSFastCacheObject
implements IXTSCacheConfigInfo {
    private static final String IDENTIFIER = "configInfo";
    private static final String PROPERTIES_PREFETCH = "properties.config.prefetch.";
    private static final String ELEM_CONFIGPROPS = "configProps";
    private Element m_oConfigEle = null;
    private Element m_oConfigPropsEle = null;

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    protected void initialize_Impl(XTSEnvironment env, Map atts) throws XTSCacheException {
        try {
            this.m_oConfigEle = XTSConfigManager.getInstance().getConfigInfo(env.getLocale());
            this.m_oConfigPropsEle = this.createConfigPropsElement();
        }
        catch (XTSConfigurationException e) {
            throw new XTSCacheException("configinfo.initfailed", e);
        }
        catch (DocumentException e) {
            throw new XTSCacheException("configinfo.initfailed", e);
        }
    }

    private Element createConfigPropsElement() throws DocumentException {
        StringBuffer configXML = new StringBuffer();
        configXML.append("<");
        configXML.append(ELEM_CONFIGPROPS);
        configXML.append(">");
        HashMap prefetchMap = PropertiesManager.getInstance().getPropertiesMap(PROPERTIES_PREFETCH);
        Map.Entry pair2 = null;
        for (Map.Entry pair2 : prefetchMap.entrySet()) {
            String key = (String)pair2.getKey();
            configXML.append("<param name=\"");
            configXML.append(key.substring(PROPERTIES_PREFETCH.length()));
            configXML.append("\">");
            String value = (String)pair2.getValue();
            if (value != null && (value = value.trim()).length() > 0) {
                StringTokenizer st = new StringTokenizer(value, ",");
                while (st.hasMoreTokens()) {
                    String prop = st.nextToken();
                    if (prop == null || (prop = prop.trim()).length() <= 0) continue;
                    this.appendParameters(configXML, prop);
                }
            }
            configXML.append("</param>");
        }
        configXML.append("</");
        configXML.append(ELEM_CONFIGPROPS);
        configXML.append(">");
        Element configPropsEle = DocumentHelper.parseText((String)configXML.toString()).getRootElement();
        configPropsEle.detach();
        return configPropsEle;
    }

    private void appendParameters(StringBuffer configXML, String prop) {
        configXML.append("<property name=\"");
        configXML.append(prop);
        configXML.append("\">");
        String propertyValue = PropertiesManager.getInstance().getProperty(prop);
        if (propertyValue == null) {
            propertyValue = "";
        }
        configXML.append(propertyValue);
        configXML.append("</property>");
    }

    @Override
    public Element getConfigInfo(XTSEnvironment env, Map paramMap) throws XTSConfigInfoException {
        return this.m_oConfigEle;
    }

    @Override
    public Element getConfigProperties(XTSEnvironment env, Map paramMap) throws XTSConfigInfoException {
        return this.m_oConfigPropsEle;
    }
}

