/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.configinfo;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.common.cache.AXTSCacheFactory;
import com.cognos.xts.common.cache.XTSCacheException;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.util.LocaleUtils;
import java.util.Map;

public class XTSConfigInfoFactory
extends AXTSCacheFactory {
    private static final String IDENTIFIER = "ConfigInfoFactory";
    private static final String CACHE_SIZE = "configinfocache.size";
    private static XTSConfigInfoFactory m_factory = new XTSConfigInfoFactory();
    private int m_iCacheSize = 25;

    public static XTSConfigInfoFactory getInstance() {
        return m_factory;
    }

    @Override
    protected int getCacheSize() throws XTSCacheException {
        return this.m_iCacheSize;
    }

    @Override
    protected String getClassName(XTSEnvironment env, Map atts) throws XTSCacheException {
        return "com.cognos.xts.configinfo.XTSConfigInfo";
    }

    @Override
    protected String generateHashKey(XTSEnvironment env, Map atts) throws XTSCacheException {
        return LocaleUtils.toJavaString(env.getLocale());
    }

    @Override
    protected void preInitialize_Impl() throws XTSCacheException {
        String sCacheSize = PropertiesManager.getInstance().getProperty(CACHE_SIZE);
        if (sCacheSize != null) {
            try {
                this.m_iCacheSize = Integer.parseInt(sCacheSize);
            }
            catch (NumberFormatException e) {
                throw new XTSCacheException("configinfofactory.cacheinitfailed", e);
            }
        }
    }

    @Override
    protected void postInitialize_Impl() throws XTSCacheException {
    }

    @Override
    protected void preTerminate_Impl() throws XTSCacheException {
    }

    @Override
    protected void postTerminate_Impl() throws XTSCacheException {
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public boolean isSupported(XTSEnvironment env, Map atts) throws XTSCacheException {
        return true;
    }
}

