/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.configuration;

import com.cognos.xts.XTSException;
import com.cognos.xts.common.manager.AXTSManager;
import com.cognos.xts.configuration.IXTSConfiguration;
import com.cognos.xts.configuration.XTSConfigurationException;
import com.cognos.xts.configuration.XTSDefaultConfiguration;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import java.util.Locale;
import java.util.Properties;
import org.dom4j.Element;

public class XTSConfigManager
extends AXTSManager {
    private static final String m_identifier = "XTSConfigManager";
    private static final XTSConfigManager m_instance = new XTSConfigManager();
    private IXTSConfiguration m_config = null;

    public static XTSConfigManager getInstance() {
        return m_instance;
    }

    private XTSConfigManager() {
    }

    @Override
    protected boolean dependenciesCheck() throws XTSException {
        return true;
    }

    @Override
    protected void initialize_Impl() throws XTSException {
        throw new UnsupportedOperationException("Please use initialize(IXTSConfiguration).");
    }

    @Override
    protected void terminate_Impl() throws XTSException {
        this.m_config = null;
    }

    @Override
    public String getIdentifier() {
        return m_identifier;
    }

    public void initialize(IXTSConfiguration config) throws XTSException {
        IXTSLogger logger;
        if (!this.dependenciesCheck()) {
            Object[] args = new String[]{this.getIdentifier()};
            throw new XTSException("manager.depinitfailed", args);
        }
        this.m_config = config == null ? new XTSDefaultConfiguration() : config;
        this.m_bInitialized = true;
        if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && (logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0)) != null) {
            logger.log(null, 0, this.getIdentifier(), null, null);
        }
    }

    public void reinitialize(IXTSConfiguration config) throws XTSException {
        this.terminate();
        this.initialize(config);
    }

    public IXTSConfiguration getConfiguration() {
        return this.m_config;
    }

    public Element getConfigInfo(Locale locale) throws XTSConfigurationException {
        return this.m_config.getConfigInfo(locale);
    }

    public String getPhysicalPath(String path) throws XTSConfigurationException {
        return this.m_config.getPhysicalPath(path);
    }

    public boolean validateContentLocale(Locale locale) throws XTSConfigurationException {
        if (locale == null) {
            return false;
        }
        return this.m_config.validateContentLocale(locale);
    }

    public boolean validateProductLocale(Locale locale) throws XTSConfigurationException {
        if (locale == null) {
            return false;
        }
        return this.m_config.validateProductLocale(locale);
    }

    public Locale mapContentLocale(Locale locale) throws XTSConfigurationException {
        if (locale == null) {
            return null;
        }
        return this.m_config.mapContentLocale(locale);
    }

    public Locale mapProductLocale(Locale locale) throws XTSConfigurationException {
        if (locale == null) {
            return null;
        }
        return this.m_config.mapProductLocale(locale);
    }

    public Locale getServerLocale() throws XTSConfigurationException {
        return this.m_config.getServerLocale();
    }

    public String getComponentVersion(String name) throws XTSConfigurationException {
        return this.m_config.getComponentVersion(name);
    }

    public String getProperty(String name) throws XTSConfigurationException {
        return this.m_config.getProperty(name);
    }

    public String getProductLocalesProperty(Locale locale) throws XTSConfigurationException {
        return this.m_config.getProductLocalesProperty(locale);
    }

    public String getContentLocalesProperty(Locale locale) throws XTSConfigurationException {
        return this.m_config.getContentLocalesProperty(locale);
    }

    public String getTimeZonesProperty(Locale locale) throws XTSConfigurationException {
        return this.m_config.getTimeZonesProperty(locale);
    }

    public String getCurrenciesProperty(Locale locale) throws XTSConfigurationException {
        return this.m_config.getCurrenciesProperty(locale);
    }

    public String getFontsProperty(Locale locale) throws XTSConfigurationException {
        return this.m_config.getFontsProperty(locale);
    }

    public Properties getProperties() throws XTSConfigurationException {
        return this.m_config.getProperties();
    }
}

