/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.ext;

import com.cognos.i18n.Calendar;
import com.cognos.i18n.DateTimeFormat;
import com.cognos.i18n.TimeZone;
import java.util.Date;
import java.util.Locale;

public class DateTimeFormatter {
    static final String UTC_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    static final String UTC_TZ = "GMT";

    static Locale createLocale(String sLocale) {
        String sLang = "";
        String sCountry = "";
        String sVariant = "";
        int iFirstSeparator = sLocale.indexOf("-");
        if (iFirstSeparator == -1) {
            sLang = sLocale;
        } else {
            sLang = sLocale.substring(0, iFirstSeparator);
            String sRest = sLocale.substring(iFirstSeparator + 1);
            int iSecondSeparator = sRest.indexOf("-");
            if (iSecondSeparator == -1) {
                sCountry = sRest;
            } else {
                sCountry = sRest.substring(0, iSecondSeparator);
                sVariant = sRest.substring(iSecondSeparator + 1);
            }
        }
        return new Locale(sLang, sCountry, sVariant);
    }

    static Date parseDateTime(String sDate, String pattern, String timeZone) throws Exception {
        DateTimeFormat informat = new DateTimeFormat(pattern);
        informat.setTimeZone(new TimeZone(timeZone));
        return informat.parse(sDate).getTime();
    }

    private static int toCCLDateTimeStyle(int style) {
        int cclStyle = 2;
        switch (style) {
            case 1: {
                cclStyle = 0;
                break;
            }
            case 2: {
                cclStyle = 1;
                break;
            }
            case 3: {
                cclStyle = 2;
                break;
            }
            case 4: {
                cclStyle = 3;
            }
        }
        return cclStyle;
    }

    public static String getCurrentDateTime(String timeZoneId) {
        DateTimeFormat outDateFormat = new DateTimeFormat(UTC_PATTERN);
        outDateFormat.setTimeZone(new TimeZone(timeZoneId));
        return outDateFormat.format(new Date());
    }

    public static String getDateInformation(String timeZoneId, String infoWanted) throws Exception {
        Calendar oCalendar = new Calendar(new TimeZone(timeZoneId), 0);
        String sInfo = "";
        if (infoWanted.equals("DAY_OF_WEEK")) {
            switch (oCalendar.get(7)) {
                case 1: {
                    sInfo = "sunday";
                    break;
                }
                case 2: {
                    sInfo = "monday";
                    break;
                }
                case 3: {
                    sInfo = "tuesday";
                    break;
                }
                case 4: {
                    sInfo = "wednesday";
                    break;
                }
                case 5: {
                    sInfo = "thursday";
                    break;
                }
                case 6: {
                    sInfo = "friday";
                    break;
                }
                default: {
                    sInfo = "saturday";
                    break;
                }
            }
        } else if (infoWanted.equals("DAY_OF_MONTH")) {
            sInfo = Integer.toString(oCalendar.get(5));
        } else if (infoWanted.equals("DAY_OF_WEEK_IN_MONTH")) {
            switch (oCalendar.get(8)) {
                case 1: {
                    sInfo = "FIRST";
                    break;
                }
                case 2: {
                    sInfo = "SECOND";
                    break;
                }
                case 3: {
                    sInfo = "THIRD";
                    break;
                }
                case 4: {
                    sInfo = "FOURTH";
                    break;
                }
                default: {
                    sInfo = "LAST";
                    break;
                }
            }
        } else if (infoWanted.equals("MONTH")) {
            sInfo = Integer.toString(oCalendar.get(2));
        }
        return sInfo;
    }

    public static String getDateTimeOffset(String oldDate, int offSet, String unit) throws Exception {
        if (oldDate.length() == 0) {
            return "";
        }
        Date oOldDate = DateTimeFormatter.parseDateTime(oldDate, UTC_PATTERN, UTC_TZ);
        Calendar oCalendar = new Calendar(new TimeZone(UTC_TZ), 0);
        oCalendar.setTime(oOldDate);
        if (unit.equals("year")) {
            oCalendar.add(1, offSet);
        } else if (unit.equals("month")) {
            oCalendar.add(2, offSet);
        } else if (unit.equals("day")) {
            oCalendar.add(5, offSet);
        } else if (unit.equals("hour")) {
            oCalendar.add(11, offSet);
        } else if (unit.equals("minute")) {
            oCalendar.add(12, offSet);
        } else if (unit.equals("second")) {
            oCalendar.add(13, offSet);
        } else {
            oCalendar.add(11, offSet);
        }
        DateTimeFormat outDateFormat = new DateTimeFormat(UTC_PATTERN);
        outDateFormat.setTimeZone(new TimeZone(UTC_TZ));
        return outDateFormat.format(oCalendar.getTime());
    }

    public static int dateTimeCmp(String date1, String date2) throws Exception {
        Date oDate1 = DateTimeFormatter.parseDateTime(date1, UTC_PATTERN, UTC_TZ);
        Date oDate2 = DateTimeFormatter.parseDateTime(date2, UTC_PATTERN, UTC_TZ);
        return oDate1.compareTo(oDate2);
    }

    public static int dateTimeOffsetCmp(String oldDate, String newDate, int offSet) throws Exception {
        Date oOldDate = DateTimeFormatter.parseDateTime(oldDate, UTC_PATTERN, UTC_TZ);
        Date oNewDate = DateTimeFormatter.parseDateTime(newDate, UTC_PATTERN, UTC_TZ);
        Calendar oCalendar = new Calendar(new TimeZone(UTC_TZ), 0);
        oCalendar.setTime(oOldDate);
        oCalendar.add(13, offSet);
        return oCalendar.getTime().compareTo(oNewDate);
    }

    public static String formatDateFromUTC(String utcDate, String dateTimePattern, String timeZoneId, String locale) throws Exception {
        DateTimeFormat outDateFormat;
        if (utcDate.length() == 0) {
            return "";
        }
        Locale oLocale = DateTimeFormatter.createLocale(locale);
        Date oDate = DateTimeFormatter.parseDateTime(utcDate, UTC_PATTERN, UTC_TZ);
        if (dateTimePattern.length() != 0) {
            outDateFormat = new DateTimeFormat(dateTimePattern, oLocale);
            TimeZone timeZone = new TimeZone(timeZoneId);
            outDateFormat.setTimeZone(new TimeZone(timeZoneId));
            try {
                return outDateFormat.format(oDate);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        outDateFormat = new DateTimeFormat(oLocale, 11, 2, 2);
        outDateFormat.setTimeZone(new TimeZone(timeZoneId));
        return outDateFormat.format(oDate);
    }

    public static String formatDateFromUTC(String utcDate, int dateStyle, int timeStyle, String timeZoneId, String locale) throws Exception {
        if (utcDate == null || utcDate.length() == 0) {
            return "";
        }
        Locale oLocale = DateTimeFormatter.createLocale(locale);
        Date oDate = DateTimeFormatter.parseDateTime(utcDate, UTC_PATTERN, UTC_TZ);
        int nDateStyle = DateTimeFormatter.toCCLDateTimeStyle(dateStyle);
        int nTimeStyle = DateTimeFormatter.toCCLDateTimeStyle(timeStyle);
        DateTimeFormat outDateFormat = new DateTimeFormat(oLocale, 11, nDateStyle, nTimeStyle);
        outDateFormat.setTimeZone(new TimeZone(timeZoneId));
        return outDateFormat.format(oDate);
    }

    public static String formatDateFromUTC(String utcDate, int dateStyle, String timeZoneId, String locale) throws Exception {
        if (utcDate == null || utcDate.length() == 0) {
            return "";
        }
        Locale oLocale = DateTimeFormatter.createLocale(locale);
        Date oDate = DateTimeFormatter.parseDateTime(utcDate, UTC_PATTERN, UTC_TZ);
        int nDateStyle = DateTimeFormatter.toCCLDateTimeStyle(dateStyle);
        DateTimeFormat outDateFormat = new DateTimeFormat(oLocale, 10, nDateStyle, 3);
        outDateFormat.setTimeZone(new TimeZone(timeZoneId));
        return outDateFormat.format(oDate);
    }

    public static String formatDateToUTC(String date, String timeZoneId) throws Exception {
        if (date.length() == 0) {
            return "";
        }
        Date oDate = DateTimeFormatter.parseDateTime(date, UTC_PATTERN, timeZoneId);
        DateTimeFormat outDateFormat = new DateTimeFormat(UTC_PATTERN);
        outDateFormat.setTimeZone(new TimeZone(UTC_TZ));
        return outDateFormat.format(oDate);
    }

    public static String getAMPMLocation(String locale) throws Exception {
        Locale oLocale = DateTimeFormatter.createLocale(locale);
        DateTimeFormat lDateFormat = new DateTimeFormat(oLocale, 12, 0, 0);
        return String.valueOf(lDateFormat.getAMPMLocation());
    }

    public static void main(String[] args) {
        String sZUTCDate1 = new String("2001-11-23T13:00:00Z");
        String sLocale = "ja-jp";
        String sTimeZoneID = "Europe/Paris";
        String sDateTimePattern = "EEEE MMMM dd yyyy '--->' hh:mm:ss zzzz";
        System.out.println("Original date: " + sZUTCDate1);
        try {
            System.out.println("New date: " + DateTimeFormatter.formatDateFromUTC(sZUTCDate1, sDateTimePattern, sTimeZoneID, sLocale));
            System.out.println("New date: " + DateTimeFormatter.formatDateFromUTC(sZUTCDate1, 2, 3, sTimeZoneID, sLocale));
        }
        catch (Exception e) {
            System.err.println("ex: " + e.getMessage());
        }
        String sDate = new String("2001-12-04T14:00:00");
        String sTZ = "America/New_York";
        System.out.println("Original date: " + sDate);
        try {
            System.out.println("New date: " + DateTimeFormatter.formatDateToUTC(sDate, sTZ));
        }
        catch (Exception e) {
            System.err.println("ex: " + e.getMessage());
        }
        System.out.println("curr time: " + DateTimeFormatter.getCurrentDateTime("America/New_York"));
        String date1 = new String("2001-11-23T13:00:00Z");
        String date2 = new String("2000-11-23T13:00:00Z");
        System.out.println("date1: " + date1 + " date2: " + date2);
        try {
            System.out.println("compared: " + DateTimeFormatter.dateTimeCmp(date2, date1));
        }
        catch (Exception e) {
            System.err.println("ex: " + e.getMessage());
        }
        String oldDate = new String("2002-02-25T15:36:00Z");
        String newDate = DateTimeFormatter.getCurrentDateTime(UTC_TZ);
        System.out.println("old date: " + oldDate + " new date: " + newDate + "  offset: 120 seconds");
        try {
            System.out.println("compared: " + DateTimeFormatter.dateTimeOffsetCmp(oldDate, newDate, 120));
        }
        catch (Exception e) {
            System.err.println("ex: " + e.getMessage());
        }
        System.out.println("old date: " + newDate + "  offset: -12 hours");
        try {
            System.out.println("return new date: " + DateTimeFormatter.getDateTimeOffset(newDate, -12, "hour"));
        }
        catch (Exception e) {
            System.err.println("ex: " + e.getMessage());
        }
    }
}

