/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.ext;

import com.cognos.i18n.NumericFormat;
import java.util.Locale;

public class NumberFormatter {
    private static Locale createLocale(String sLocale) {
        String sLang = "";
        String sCountry = "";
        String sVariant = "";
        int iFirstSeparator = sLocale.indexOf("-");
        if (iFirstSeparator == -1) {
            sLang = sLocale;
        } else {
            sLang = sLocale.substring(0, iFirstSeparator);
            String sRest = sLocale.substring(iFirstSeparator + 1);
            int iSecondSeparator = sRest.indexOf("-");
            if (iSecondSeparator == -1) {
                sCountry = sRest;
            } else {
                sCountry = sRest.substring(0, iSecondSeparator);
                sVariant = sRest.substring(iSecondSeparator + 1);
            }
        }
        return new Locale(sLang, sCountry, sVariant);
    }

    public static String format(String number, String pattern, String locale, int style) throws Exception {
        Locale oLocale = NumberFormatter.createLocale(locale);
        NumericFormat oFormat = null;
        switch (style) {
            case 1: {
                oFormat = new NumericFormat(9, oLocale);
                break;
            }
            case 2: {
                oFormat = new NumericFormat(10, oLocale);
                break;
            }
            case 3: {
                oFormat = new NumericFormat(13, oLocale);
                break;
            }
            case 4: {
                oFormat = new NumericFormat(12, oLocale);
                break;
            }
            case 5: {
                oFormat = new NumericFormat(11, oLocale);
                break;
            }
            default: {
                oFormat = new NumericFormat(9, oLocale);
            }
        }
        if (pattern != null) {
            oFormat.applyPattern(pattern);
        }
        try {
            long lvalue = Long.parseLong(number);
            return oFormat.format(lvalue);
        }
        catch (NumberFormatException e) {
            double dvalue = Double.parseDouble(number);
            return oFormat.format(dvalue);
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println("Japanese: ");
            System.out.println("Number: " + NumberFormatter.format("1234", null, "ja-jp", 1));
            System.out.println("Integer: " + NumberFormatter.format("1234", null, "ja-jp", 2));
            System.out.println("Scientific: " + NumberFormatter.format("1234", null, "ja-jp", 3));
            System.out.println("Percentage: " + NumberFormatter.format("1234", null, "ja-jp", 4));
            System.out.println("Currency: " + NumberFormatter.format("1234", null, "ja-jp", 5));
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("Japanese: ");
            System.out.println("Number: " + NumberFormatter.format("1234.5678", null, "ja-jp", 1));
            System.out.println("Integer: " + NumberFormatter.format("1234.5678", null, "ja-jp", 2));
            System.out.println("Scientific: " + NumberFormatter.format("1234.5678", null, "ja-jp", 3));
            System.out.println("Percentage: " + NumberFormatter.format("1234.5678", null, "ja-jp", 4));
            System.out.println("Currency: " + NumberFormatter.format("1234.5678", null, "ja-jp", 5));
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("Japanese: ");
            System.out.println("Number: " + NumberFormatter.format("1234", "#,###0,0000.0000'*'00#;(#)", "ja-jp", 1));
            System.out.println("Integer: " + NumberFormatter.format("1234", "#,###0,0000.0000'*'00#;(#)", "ja-jp", 2));
            System.out.println("Scientific: " + NumberFormatter.format("1234", "###0000.0000E00;(#)", "ja-jp", 3));
            System.out.println("Percentage: " + NumberFormatter.format("1234", "####.###;(#)", "ja-jp", 4));
            System.out.println("Currency: " + NumberFormatter.format("1234", "####.###;(#)", "ja-jp", 5));
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("Japanese: ");
            System.out.println("Number: " + NumberFormatter.format("1234.5678", "#,###0,0000.0000'*'00#;(#)", "ja-jp", 1));
            System.out.println("Integer: " + NumberFormatter.format("1234.5678", "#,###0,0000.0000'*'00#;(#)", "ja-jp", 2));
            System.out.println("Scientific: " + NumberFormatter.format("1234.5678", "###0000.0000E00;(#)", "ja-jp", 3));
            System.out.println("Percentage: " + NumberFormatter.format("1234.5678", "####.###;(#)", "ja-jp", 4));
            System.out.println("Currency: " + NumberFormatter.format("1234.5678", "####.###;(#)", "ja-jp", 5));
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("English: ");
            System.out.println("Number: " + NumberFormatter.format("1234", null, "en-us", 1));
            System.out.println("Integer: " + NumberFormatter.format("1234", null, "en-us", 2));
            System.out.println("Scientific: " + NumberFormatter.format("1234", null, "en-us", 3));
            System.out.println("Percentage: " + NumberFormatter.format("1234", null, "en-us", 4));
            System.out.println("Currency: " + NumberFormatter.format("1234", null, "en-us", 5));
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("English: ");
            System.out.println("Number: " + NumberFormatter.format("1234.5678", null, "en-us", 1));
            System.out.println("Integer: " + NumberFormatter.format("1234.5678", null, "en-us", 2));
            System.out.println("Scientific: " + NumberFormatter.format("1234.5678", null, "en-us", 3));
            System.out.println("Percentage: " + NumberFormatter.format("1234.5678", null, "en-us", 4));
            System.out.println("Currency: " + NumberFormatter.format("1234.5678", null, "en-us", 5));
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("English: ");
            System.out.println("Number: " + NumberFormatter.format("1234", "#,###0,0000.0000'*'00#;(#)", "en-us", 1));
            System.out.println("Integer: " + NumberFormatter.format("1234", "#,###0,0000.0000'*'00#;(#)", "en-us", 2));
            System.out.println("Scientific: " + NumberFormatter.format("1234", "###0000.0000E00;(#)", "en-us", 3));
            System.out.println("Percentage: " + NumberFormatter.format("1234", "####.###;(#)", "en-us", 4));
            System.out.println("Currency: " + NumberFormatter.format("1234", "####.###;(#)", "en-us", 5));
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        try {
            System.out.println("English: ");
            System.out.println("Number: " + NumberFormatter.format("1234.5678", "#,###0,0000.0000'*'00#;(#)", "en-us", 1));
            System.out.println("Integer: " + NumberFormatter.format("1234.5678", "#,###0,0000.0000'*'00#;(#)", "en-us", 2));
            System.out.println("Scientific: " + NumberFormatter.format("1234.5678", "###0000.0000E00;(#)", "en-us", 3));
            System.out.println("Percentage: " + NumberFormatter.format("1234.5678", "####.###;(#)", "en-us", 4));
            System.out.println("Currency: " + NumberFormatter.format("1234.5678", "####.###;(#)", "en-us", 5));
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
    }
}

