/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.ext;

import com.cognos.caf.logging.CAFLog;
import com.cognos.validator.api.Document;
import com.cognos.validator.api.IParameterUpdater;
import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.api.ValidatorFactory;
import com.cognos.validator.api.VerifyException;
import com.cognos.validator.api.VerifySession;
import com.cognos.xts.ext.ValidatorInputParameters;
import java.io.Reader;
import java.io.StringReader;

public class Validator {
    private static ValidatorFactory m_factory = null;
    private static Document m_doc = null;
    private static String m_genericName = "generic1";
    private static String xmldoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><validator xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://developer.cognos.com/schemas/validator/1/ ../producer/schemas/validator.xsd\" xmlns=\"http://developer.cognos.com/schemas/validator/1/\" namespace=\"urn:cognos:xtsext:validator\" version=\"1.0\">   <parameter skipJavaScript=\"true\">       <name>" + m_genericName + "</name>" + "       <sign/>" + "   </parameter>" + "</validator>";

    public static String prepare(String identifier, String value) {
        if (m_factory == null) {
            return value;
        }
        try {
            VerifySession verifySession = m_factory.createVerifySession(m_doc);
            ValidatorInputParameters parameters = new ValidatorInputParameters(1);
            parameters.addParameter(m_genericName, value);
            verifySession.prepare((IParameterUpdater)parameters);
            return parameters.getParameterValue(m_genericName);
        }
        catch (ValidatorException e) {
            StringBuffer msg = new StringBuffer();
            msg.append("Failed to prepare in validator provider for ");
            msg.append("\n [identifier]").append(identifier).append("\n ");
            msg.append(e.getMessage());
            Validator.logError(msg.toString());
            return "";
        }
    }

    public static String verify(String identifier, String value) {
        if (m_factory == null) {
            return value;
        }
        try {
            VerifySession verifySession = m_factory.createVerifySession(m_doc);
            ValidatorInputParameters parameters = new ValidatorInputParameters(1);
            parameters.addParameter(m_genericName, value);
            verifySession.verify((IParameterUpdater)parameters);
            return parameters.getParameterValue(m_genericName);
        }
        catch (VerifyException e) {
            StringBuffer msg = new StringBuffer();
            msg.append("Security Rejection. Your request was rejected because it failed XTS input validation. Rejection details are available in the log. Please contact your administrator.");
            msg.append("\n [identifier]").append(identifier);
            msg.append("\n [failure details]").append(e.getFailureDetails());
            msg.append("\n [validator details]" + e.getValidatorDetails());
            Validator.logError(msg.toString());
            return "";
        }
        catch (ValidatorException e) {
            StringBuffer msg = new StringBuffer();
            msg.append("Failed to verify in validator provider for ");
            msg.append("\n [identifier]").append(identifier).append("\n ");
            msg.append(e.getMessage());
            Validator.logError(msg.toString());
            return "";
        }
    }

    private static void logError(String error) {
        try {
            CAFLog.error((String)error);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            m_factory = ValidatorFactory.newInstance();
            m_doc = m_factory.createDocument();
            m_doc.loadFromXML((Reader)new StringReader(xmldoc));
        }
        catch (Exception e) {
            m_factory = null;
        }
    }
}

