/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.ext;

import com.cognos.xts.ext.NumberFormatter;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;

public class XTSDuration
implements Comparable<XTSDuration> {
    private static final long serialVersionUID = -6475091654291323029L;
    private Duration duration = null;
    private static DecimalFormat secondsFormat = new DecimalFormat("00.000");
    private static DecimalFormat hoursMinutesFormat = new DecimalFormat("00");
    private String locale = null;
    private long milliseconds = 0L;

    public XTSDuration(long milliseconds) throws DatatypeConfigurationException {
        this.milliseconds = milliseconds;
        DatatypeFactory df = DatatypeFactory.newInstance();
        this.duration = df.newDurationDayTime(milliseconds);
    }

    public XTSDuration(String isoDuration) throws DatatypeConfigurationException {
        this(isoDuration, Calendar.getInstance(), Locale.getDefault().toString());
    }

    public XTSDuration(String isoDuration, Calendar startInstant, String locale) throws DatatypeConfigurationException {
        this.duration = XTSDuration.createDayTimeDuration(isoDuration, startInstant);
        this.setLocale(locale);
        this.milliseconds = this.duration.getTimeInMillis(startInstant);
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    private static Duration createDayTimeDuration(String isoDuration, Calendar startInstant) throws DatatypeConfigurationException {
        DatatypeFactory df = DatatypeFactory.newInstance();
        long lDuration = df.newDuration(isoDuration).getTimeInMillis(startInstant);
        return df.newDurationDayTime(lDuration);
    }

    private static Duration createDayTimeDuration(String isoDuration) throws DatatypeConfigurationException {
        return XTSDuration.createDayTimeDuration(isoDuration, Calendar.getInstance());
    }

    protected Duration getDuration() {
        return this.duration;
    }

    private static String formatNumber(String number, String format, String locale) throws Exception {
        return NumberFormatter.format(number, format, locale, 2);
    }

    public static long getMilliseconds(String isoDuration, Calendar startInstant) throws DatatypeConfigurationException {
        if (isoDuration == null || isoDuration.length() == 0) {
            return 0L;
        }
        return XTSDuration.createDayTimeDuration(isoDuration).getTimeInMillis(startInstant);
    }

    public static long getMilliseconds(String isoDuration) throws DatatypeConfigurationException {
        return XTSDuration.getMilliseconds(isoDuration, Calendar.getInstance());
    }

    public long getMilliseconds() {
        return this.milliseconds;
    }

    public String toString() {
        Number seconds;
        StringBuffer sbDuration = new StringBuffer();
        if (this.duration.getDays() > 0) {
            try {
                sbDuration.append(XTSDuration.formatNumber(String.valueOf(this.duration.getDays()), null, this.locale.toString())).append(" ");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if ((seconds = this.duration.getField(DatatypeConstants.SECONDS)) == null) {
            seconds = 0;
        }
        StringBuffer sb = sbDuration.append(hoursMinutesFormat.format(this.duration.getHours())).append(':').append(hoursMinutesFormat.format(this.duration.getMinutes())).append(':').append(secondsFormat.format(seconds));
        return sb.toString();
    }

    @Override
    public int compareTo(XTSDuration thatDuration) {
        if (this.getMilliseconds() > thatDuration.getMilliseconds()) {
            return 1;
        }
        if (this.getMilliseconds() < thatDuration.getMilliseconds()) {
            return -1;
        }
        return 0;
    }
}

