/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.ext;

import com.cognos.xts.XTSException;
import com.cognos.xts.configuration.XTSConfigManager;
import com.cognos.xts.configuration.XTSConfigurationException;
import com.cognos.xts.ext.CCLCAMUtils;
import com.cognos.xts.ext.DateTimeFormatter;
import com.cognos.xts.ext.NumberFormatter;
import com.cognos.xts.ext.PPFilterToParameter;
import com.cognos.xts.ext.Protect;
import com.cognos.xts.ext.RandomGUID;
import com.cognos.xts.ext.URLEncoderDecoder;
import com.cognos.xts.ext.Validator;
import com.cognos.xts.ext.XTSCMCacheService;
import com.cognos.xts.ext.XTSDuration;
import com.cognos.xts.ext.base64;
import com.cognos.xts.resource.XTSResourceManager;
import com.cognos.xts.util.LocaleUtils;
import com.ibm.cognos.i18n.util.Bidi;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class XTSExt {
    private static final int BUFFER_SIZE = 256;
    private static final Checksum checker = new CRC32();
    public static int LONG_FORMAT = 2;
    static final String CC_SESSION_PASSPORT_NAME = "pp";
    static final String PORTAL_PROTECTSESSIONCOOKIES = "portal.protectSessionCookies";
    static final String CC_SESSION_HASH_NAME = "ssshsh";
    static final String CC_SESSION_HASHKEY_SEPARATOR = "|";
    private static final String invalidJavaSciptFieldName = "INVALIDFIELDNAME";

    public static String urlencode(String value) throws UnsupportedEncodingException {
        return URLEncoderDecoder.encode(value, "UTF-8", false);
    }

    public static String urlencode(String value, String enc) throws UnsupportedEncodingException {
        return URLEncoderDecoder.encode(value, enc, false);
    }

    public static String urlencode(String value, String enc, String form) throws UnsupportedEncodingException {
        return URLEncoderDecoder.encode(value, enc, Boolean.valueOf(form));
    }

    public static String cmencode(String value) {
        return value;
    }

    public static String urldecode(String value) throws UnsupportedEncodingException {
        return URLEncoderDecoder.decode(value, "UTF-8");
    }

    public static String urldecode(String value, String enc) throws UnsupportedEncodingException {
        return URLEncoderDecoder.decode(value, enc);
    }

    public static String cmdecode(String value) {
        return value;
    }

    public static String htmlencode(String value) {
        int rsize = value.length() * 4;
        StringBuffer sbuf = new StringBuffer(rsize);
        block6: for (int i = 0; i < value.length(); ++i) {
            char x = value.charAt(i);
            switch (x) {
                case '<': {
                    sbuf.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sbuf.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sbuf.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sbuf.append("&quot;");
                    continue block6;
                }
                default: {
                    sbuf.append(x);
                }
            }
        }
        return sbuf.toString();
    }

    public static String htmldecode(String value) {
        StringBuffer sbuf = new StringBuffer(value.length());
        int i = 0;
        while (i < value.length()) {
            char x = value.charAt(i);
            if (x != '&') {
                sbuf.append(x);
                ++i;
                continue;
            }
            if (value.startsWith("&lt;", i)) {
                sbuf.append('<');
                i += 4;
                continue;
            }
            if (value.startsWith("&gt;", i)) {
                sbuf.append('>');
                i += 4;
                continue;
            }
            if (value.startsWith("&amp;", i)) {
                sbuf.append('&');
                i += 5;
                continue;
            }
            if (value.startsWith("&quot;", i)) {
                sbuf.append('\"');
                i += 6;
                continue;
            }
            sbuf.append('&');
            ++i;
        }
        return sbuf.toString();
    }

    public static String javascriptencode(String value) {
        String prev;
        do {
            prev = value;
        } while (!(value = value.replaceAll("<\\/[sS][cC][rR][iI][pP][tT]", "")).equals(prev));
        int rsize = value.length() * 2;
        StringBuffer sbuf = new StringBuffer(rsize);
        block14: for (int i = 0; i < value.length(); ++i) {
            char x = value.charAt(i);
            switch (x) {
                case '\b': {
                    sbuf.append("\\b");
                    continue block14;
                }
                case '\t': {
                    sbuf.append("\\t");
                    continue block14;
                }
                case '\n': {
                    sbuf.append("\\n");
                    continue block14;
                }
                case '\u000b': {
                    sbuf.append("\\v");
                    continue block14;
                }
                case '\f': {
                    sbuf.append("\\f");
                    continue block14;
                }
                case '\r': {
                    sbuf.append("\\r");
                    continue block14;
                }
                case '\"': {
                    sbuf.append("\\\"");
                    continue block14;
                }
                case '\'': {
                    sbuf.append("\\'");
                    continue block14;
                }
                case '\\': {
                    sbuf.append("\\\\");
                    continue block14;
                }
                case '<': {
                    sbuf.append("\\<");
                    continue block14;
                }
                case '>': {
                    sbuf.append("\\>");
                    continue block14;
                }
                default: {
                    sbuf.append(x);
                }
            }
        }
        return sbuf.toString();
    }

    public static String base64encode(String value, boolean compress) {
        try {
            byte[] b = value.getBytes("UTF-8");
            if (compress) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(value.length());
                GZIPOutputStream gzos = new GZIPOutputStream(bos);
                gzos.write(b);
                gzos.close();
                b = bos.toByteArray();
            }
            return base64.encode(0, b);
        }
        catch (Exception e) {
            return value;
        }
    }

    public static String base64decode(String value, boolean decompress) {
        try {
            byte[] b = base64.decode(0, value);
            if (decompress) {
                ByteArrayInputStream bis = new ByteArrayInputStream(b);
                GZIPInputStream gzis = new GZIPInputStream(bis);
                ByteArrayOutputStream bos = new ByteArrayOutputStream(b.length);
                int nByteRead = 0;
                byte[] buf = new byte[256];
                while ((nByteRead = gzis.read(buf, 0, 256)) != -1) {
                    bos.write(buf, 0, nByteRead);
                }
                bos.close();
                gzis.close();
                return bos.toString("UTF-8");
            }
            return new String(b, "UTF-8");
        }
        catch (Exception e) {
            return value;
        }
    }

    public static String web64encode(String value, boolean compress) {
        try {
            byte[] b = value.getBytes("UTF-8");
            if (compress) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(value.length());
                GZIPOutputStream gzos = new GZIPOutputStream(bos);
                gzos.write(b);
                gzos.close();
                b = bos.toByteArray();
            }
            return base64.encode(1, b);
        }
        catch (Exception e) {
            return value;
        }
    }

    public static String web64decode(String value, boolean decompress) {
        try {
            byte[] b = base64.decode(1, value);
            if (decompress) {
                ByteArrayInputStream bis = new ByteArrayInputStream(b);
                GZIPInputStream gzis = new GZIPInputStream(bis);
                ByteArrayOutputStream bos = new ByteArrayOutputStream(b.length);
                int nByteRead = 0;
                byte[] buf = new byte[256];
                while ((nByteRead = gzis.read(buf, 0, 256)) != -1) {
                    bos.write(buf, 0, nByteRead);
                }
                bos.close();
                gzis.close();
                return bos.toString("UTF-8");
            }
            return new String(b, "UTF-8");
        }
        catch (Exception e) {
            return value;
        }
    }

    public static String generateGUID() {
        return new RandomGUID(true).toString();
    }

    public static String formatDateFromUTC(String utcDate, String dateTimePattern, String timeZoneId, String locale) throws Exception {
        return DateTimeFormatter.formatDateFromUTC(utcDate, dateTimePattern, timeZoneId, locale);
    }

    public static String formatDateFromUTC(String utcDate, int dateStyle, int timeStyle, String timeZoneId, String locale) throws Exception {
        return DateTimeFormatter.formatDateFromUTC(utcDate, dateStyle, timeStyle, timeZoneId, locale);
    }

    public static String formatDateOnlyFromUTC(String utcDate, int dateStyle, String timeZoneId, String locale) throws Exception {
        return DateTimeFormatter.formatDateFromUTC(utcDate, dateStyle, timeZoneId, locale);
    }

    public static String formatDateToUTC(String date, String timeZoneId) throws Exception {
        return DateTimeFormatter.formatDateToUTC(date, timeZoneId);
    }

    public static String getAMPMLocation(String locale) throws Exception {
        return DateTimeFormatter.getAMPMLocation(locale);
    }

    public static String getCurrentDateTime(String timeZoneId) {
        return DateTimeFormatter.getCurrentDateTime(timeZoneId);
    }

    public static String getDateInformation(String timeZoneId, String infoWanted) throws Exception {
        return DateTimeFormatter.getDateInformation(timeZoneId, infoWanted);
    }

    public static String getDateTimeOffset(String oldDate, int offSet, String unit) throws Exception {
        return DateTimeFormatter.getDateTimeOffset(oldDate, offSet, unit);
    }

    public static int dateTimeCmp(String date1, String date2) throws Exception {
        return DateTimeFormatter.dateTimeCmp(date1, date2);
    }

    public static int dateTimeOffsetCmp(String oldDate, String newDate, int offSet) throws Exception {
        return DateTimeFormatter.dateTimeOffsetCmp(oldDate, newDate, offSet);
    }

    public static String formatNumber(String number, String locale, int style) throws Exception {
        return NumberFormatter.format(number, null, locale, style);
    }

    public static String formatNumber(String number, String pattern, String locale, int style) throws Exception {
        return NumberFormatter.format(number, pattern, locale, style);
    }

    public static String validateJavascriptName(String value) {
        int iLength = value.length();
        for (int index = 0; index < iLength; ++index) {
            char aChar = value.charAt(index);
            if (Character.isLetterOrDigit(aChar) || aChar == '_') continue;
            return invalidJavaSciptFieldName;
        }
        return value;
    }

    public static String xmlencode(String value) {
        int rsize = value.length() * 4;
        StringBuffer sbuf = new StringBuffer(rsize);
        block7: for (int i = 0; i < value.length(); ++i) {
            char x = value.charAt(i);
            switch (x) {
                case '\'': {
                    sbuf.append("&apos;");
                    continue block7;
                }
                case '<': {
                    sbuf.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sbuf.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sbuf.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    sbuf.append("&quot;");
                    continue block7;
                }
                default: {
                    sbuf.append(x);
                }
            }
        }
        return sbuf.toString();
    }

    public static String xmldecode(String value) {
        StringBuffer sbuf = new StringBuffer(value.length());
        int i = 0;
        while (i < value.length()) {
            char x = value.charAt(i);
            if (x != '&') {
                sbuf.append(x);
                ++i;
                continue;
            }
            if (value.startsWith("&apos;", i)) {
                sbuf.append('\'');
                i += 6;
                continue;
            }
            if (value.startsWith("&lt;", i)) {
                sbuf.append('<');
                i += 4;
                continue;
            }
            if (value.startsWith("&gt;", i)) {
                sbuf.append('>');
                i += 4;
                continue;
            }
            if (value.startsWith("&amp;", i)) {
                sbuf.append('&');
                i += 5;
                continue;
            }
            if (value.startsWith("&quot;", i)) {
                sbuf.append('\"');
                i += 6;
                continue;
            }
            sbuf.append('&');
            ++i;
        }
        return sbuf.toString();
    }

    public static String substringAfterLast(String value, String str) {
        return value.substring(value.lastIndexOf(str) + 1);
    }

    public static String substringBeforeLast(String value, String str) {
        int index = value.lastIndexOf(str);
        if (index < 0) {
            index = 0;
        }
        return value.substring(0, index);
    }

    public static String replace(String src, String searchstr, String replacestr) {
        return XTSExt.replace(src, searchstr, replacestr, false);
    }

    public static String replace(String src, String searchstr, String replacestr, boolean ignoreCase) {
        int start = 0;
        int len = searchstr.length();
        int end = src.length() - len;
        StringBuffer result = new StringBuffer(src.length());
        while (start <= end) {
            if (src.regionMatches(ignoreCase, start, searchstr, 0, len)) {
                result.append(replacestr);
                start += len;
                continue;
            }
            result.append(src.charAt(start));
            ++start;
        }
        result.append(src.substring(start));
        return result.toString();
    }

    public static String convertPPFilter(String filter) {
        return PPFilterToParameter.GetParametersFromFilter(filter);
    }

    public static String random() {
        return Integer.toString((int)(Math.random() * 10000.0));
    }

    public static String checksum(String str) throws UnsupportedEncodingException {
        byte[] bytes = str.getBytes("UTF-8");
        checker.reset();
        checker.update(bytes, 0, bytes.length);
        return Long.toString(checker.getValue());
    }

    public static String decodeCCSession(String cc_session, String pd, String vd) throws UnsupportedEncodingException {
        StringBuffer result = new StringBuffer(cc_session.length() + 600);
        int ipd = 0;
        while (cc_session.length() > 0) {
            String snvp;
            ipd = cc_session.indexOf(pd);
            if (ipd == 0) {
                cc_session = cc_session.substring(1);
                continue;
            }
            if (ipd != -1) {
                snvp = cc_session.substring(0, ipd);
                cc_session = cc_session.substring(ipd + 1);
            } else {
                snvp = cc_session;
                cc_session = "";
            }
            int ivd = snvp.indexOf(vd);
            if (ivd == -1) {
                result.append("<param name=\"");
                result.append(snvp);
                result.append("\"/>");
                continue;
            }
            result.append("<param name=\"");
            result.append(snvp.substring(0, ivd));
            result.append("\">");
            if (snvp.startsWith("e_")) {
                result.append(XTSExt.xmlencode(URLEncoderDecoder.decode(XTSExt.replace(XTSExt.replace(snvp.substring(ivd + 1), "*", "%"), "%%", "*"), "UTF-8")));
            } else {
                result.append(snvp.substring(ivd + 1));
            }
            result.append("</param>");
        }
        return result.toString();
    }

    public static String protectCCSessionCookie(String cc_session, String CAMPassportId, String pd, String vd, String options) {
        try {
            String signed;
            int hash_separator;
            boolean protectSessionCookies = "true".equals(XTSConfigManager.getInstance().getProperty(PORTAL_PROTECTSESSIONCOOKIES));
            if (protectSessionCookies && (hash_separator = (signed = XTSExt.validator("prepare", "cc_session", cc_session)).indexOf(CC_SESSION_HASHKEY_SEPARATOR)) != -1) {
                String hash = signed.substring(0, hash_separator);
                String hash_ccSessionEncoded = XTSExt.encodeCCSessionValue(hash);
                signed = CC_SESSION_HASH_NAME + vd + hash_ccSessionEncoded + CC_SESSION_HASHKEY_SEPARATOR + cc_session;
                return signed;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cc_session;
    }

    public static boolean isCCSessionValid(String cc_session, String CAMPassportId, String pd, String vd) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        boolean valid = true;
        if (cc_session != null && CAMPassportId != null) {
            String passport_pp = pd + CC_SESSION_PASSPORT_NAME + vd + XTSExt.substringAfterLast(CAMPassportId, ":");
            boolean bl = valid = cc_session.indexOf(passport_pp) != -1;
            if (valid) {
                try {
                    boolean protectSessionCookies = "true".equals(XTSConfigManager.getInstance().getProperty(PORTAL_PROTECTSESSIONCOOKIES));
                    if (protectSessionCookies) {
                        if (cc_session.startsWith(CC_SESSION_HASH_NAME + vd)) {
                            int hash_separator = (cc_session = cc_session.substring(CC_SESSION_HASH_NAME.length() + vd.length())).indexOf(CC_SESSION_HASHKEY_SEPARATOR);
                            if (hash_separator != -1) {
                                String hash = cc_session.substring(0, hash_separator);
                                cc_session = cc_session.substring(hash_separator + CC_SESSION_HASHKEY_SEPARATOR.length());
                                String hash_ccSessionDecoded = URLEncoderDecoder.decode(XTSExt.replace(XTSExt.replace(hash, "*", "%"), "%%", "*"), "UTF-8");
                                String unsignedv = XTSExt.validator("verify", "cc_session", hash_ccSessionDecoded + CC_SESSION_HASHKEY_SEPARATOR + cc_session);
                                valid = unsignedv != null && !"".equals(unsignedv);
                            } else {
                                valid = false;
                            }
                        } else {
                            valid = false;
                        }
                    }
                }
                catch (Exception e) {
                    valid = false;
                }
            }
        }
        return valid;
    }

    public static String decodeCRNCookie(String CRN) throws UnsupportedEncodingException {
        if (CRN != null && CRN.length() > 0) {
            CRN = URLEncoderDecoder.decode(CRN, "UTF-8");
            StringBuffer result = new StringBuffer(CRN.length() + 512);
            StringTokenizer st = new StringTokenizer(CRN, "&");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int eql = token.indexOf("=");
                String name = null;
                String value = null;
                if (eql != -1) {
                    name = token.substring(0, eql);
                    value = token.substring(eql + 1, token.length());
                } else {
                    name = token;
                }
                if (name == null || name.length() <= 0) continue;
                result.append("<param name=\"");
                result.append(name);
                result.append("\" type=\"CRN\">");
                if (value != null && value.length() > 0) {
                    result.append(URLEncoderDecoder.decode(value, "UTF-8"));
                }
                result.append("</param>");
            }
            return result.toString();
        }
        return "";
    }

    public static String encodeCCSessionValue(String value) throws UnsupportedEncodingException {
        return XTSExt.replace(URLEncoderDecoder.encode(value, "UTF-8", false), "*", "%%", false).replace('%', '*');
    }

    public static String protect(String value, String enc, String type, String context) {
        return Protect.protect(value, enc, type, context);
    }

    public static String cafaction(String actionValueList, String data) {
        return Protect.cafaction(actionValueList, data);
    }

    public static String camcookie_action(String command, String cookie) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, Exception {
        try {
            String a = CCLCAMUtils.executeCAMCookieCommand(command, cookie);
            return a;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        catch (Error e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static Boolean resourceExists(String resourceName) {
        try {
            return XTSResourceManager.getInstance().exists(resourceName) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (XTSException e) {
            return Boolean.FALSE;
        }
    }

    public static String validator(String action, String identifier, String data) {
        if ("prepare".equals(action)) {
            return Validator.prepare(identifier, data);
        }
        if ("verify".equals(action)) {
            return Validator.verify(identifier, data);
        }
        return "";
    }

    public static String formatDuration(String isoDuration, String locale, int style) throws Exception {
        if (style != LONG_FORMAT) {
            throw new RuntimeException(style + " is not a supported format style for the duration");
        }
        XTSDuration xtsDuration = new XTSDuration(isoDuration);
        xtsDuration.setLocale(locale);
        return xtsDuration.toString();
    }

    public static long durationToMilliseconds(String isoDuration) throws Exception {
        return XTSDuration.getMilliseconds(isoDuration);
    }

    public static String formatDuration(long units, boolean isSeconds, String locale, int style) throws Exception {
        if (style != LONG_FORMAT) {
            throw new RuntimeException(style + " is not a supported format style for the duration");
        }
        if (isSeconds) {
            units *= 1000L;
        }
        XTSDuration duration = new XTSDuration(units);
        duration.setLocale(locale);
        return duration.toString();
    }

    public static boolean isCacheEnabled() throws Exception {
        return XTSCMCacheService.getIsCacheServiceEnabled();
    }

    public static boolean isRTLLocale(String locale) {
        return Bidi.isLocaleRTL((String)locale);
    }

    public static boolean isRTLText(String text, String locale) {
        return Bidi.isRTLText((String)text, (String)locale);
    }

    public static String getBTD(String text, String btd, String locale) {
        return Bidi.getBTD((String)text, (String)btd, (String)locale);
    }

    public static String enforceBTD(String text, String btd, String locale) {
        return Bidi.enforceBTD((String)text, (String)btd, (String)locale);
    }

    public static String enforceBTD(String text, String btd, String locale, boolean isBidiEnabled) {
        if (isBidiEnabled) {
            return Bidi.enforceBTD((String)text, (String)btd, (String)locale);
        }
        return text;
    }

    public static String enforceSegmentBTD(String text, String btd, String locale) {
        return Bidi.enforceSegmentBTD((String)text, (String)btd, (String)locale);
    }

    public static String enforceSegmentBTD(String text, String btd, String locale, boolean isBidiEnabled) {
        if (isBidiEnabled) {
            return Bidi.enforceSegmentBTD((String)text, (String)btd, (String)locale);
        }
        return text;
    }

    public static String sttInjectUCCIntoStr(String text, String sttType) {
        return Bidi.sttInjectUCCIntoStr((String)text, (String)sttType);
    }

    public static String sttInjectUCCIntoStr(String text, String sttType, boolean isBidiEnabled) {
        if (isBidiEnabled) {
            return Bidi.sttInjectUCCIntoStr((String)text, (String)sttType);
        }
        return text;
    }

    public static String enforceSTT(String text, String sttType) {
        return Bidi.enforceSTT((String)text, (String)sttType);
    }

    public static String enforceSTT(String text, String sttType, boolean isBidiEnabled) {
        if (isBidiEnabled) {
            return Bidi.enforceSTT((String)text, (String)sttType);
        }
        return text;
    }

    public static String enforceSegmentSTT(String text, String sttType, String locale) {
        return Bidi.enforceSegmentSTT((String)text, (String)sttType, (String)locale);
    }

    public static String enforceSegmentSTT(String text, String sttType, String locale, boolean isBidiEnabled) {
        if (isBidiEnabled) {
            return Bidi.enforceSegmentSTT((String)text, (String)sttType, (String)locale);
        }
        return text;
    }

    public static String mapProductLocaleForDojo(String locale) {
        if ("no".equals(locale)) {
            return "nb";
        }
        return locale;
    }

    public static String mapProductLocale(String locale) {
        try {
            String mappedLocale = LocaleUtils.toNormalizedString(XTSConfigManager.getInstance().mapProductLocale(LocaleUtils.toLocale(locale)));
            if (mappedLocale != null) {
                return mappedLocale;
            }
        }
        catch (XTSConfigurationException xTSConfigurationException) {
            // empty catch block
        }
        return locale;
    }
}

