/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter;

import com.cognos.xts.XTSBlockOrganizer;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.common.thread.XTSThread;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.XTSSequenceInstruction;
import com.cognos.xts.logging.XTSDebugManager;
import com.cognos.xts.util.StopWatchTimer;
import com.cognos.xts.util.xmlutil;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Document;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class XTSBlockInterpreter2
extends DefaultHandler
implements LexicalHandler {
    private XTSThread m_currentSequenceThread = null;
    private XTSSequenceInstruction m_currentSequenceInstruction = null;
    private static final String ENCODING = "UTF-8";
    private static final String NAMESPACE_FEATURE = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private static final String LEXICALHANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private static final char ENTITYREF_START = '&';
    private static final char ENTITYREF_END = ';';
    private XTSEnvironment m_env = null;
    private Document m_document = null;
    private XMLReader m_reader = null;
    private HashMap m_prefixNSDeclMap = new HashMap();
    private String m_currentEntity = null;
    private String m_baseDebugDumpDir = null;
    private int m_currentInstDepth = 0;
    private int m_iSequenceCount = 0;
    private XTSBlockOrganizer m_parentBlkOrg = null;
    private boolean m_bProcessingSequence = false;
    private StopWatchTimer m_timer = null;
    private boolean m_bInterpreterStarted = false;
    private String m_blkid = null;
    private XTSException m_faultException = null;

    public XTSBlockInterpreter2(XTSEnvironment env, XTSBlockOrganizer parentBlkOrg, Document document, String baseDebugDumpDir, StopWatchTimer timer, String blkid) {
        this.m_env = env;
        this.m_document = document;
        this.m_parentBlkOrg = parentBlkOrg;
        this.m_baseDebugDumpDir = baseDebugDumpDir;
        this.m_timer = timer;
        this.m_blkid = blkid;
        this.m_faultException = null;
    }

    public void updateStatus(XTSInstructionException exception) {
        this.m_faultException = exception;
    }

    public void checkStatus() throws XTSException {
        if (this.m_faultException != null) {
            throw this.m_faultException;
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.m_currentEntity = null;
        if (!this.m_bInterpreterStarted) {
            this.m_bInterpreterStarted = true;
            if (this.m_timer != null) {
                this.m_timer.start();
            }
        }
        if (!this.m_bProcessingSequence) {
            if (!namespaceURI.equals("http://developer.cognos.com/schemas/xts/") || !localName.equals("sequence")) {
                return;
            }
            StopWatchTimer childTimer = null;
            if (this.m_timer != null) {
                childTimer = this.m_timer.createChild();
            }
            String sequenceBaseDebugDir = null;
            if ((this.m_env.getMode() & 2) > 0) {
                StringBuffer tmp = new StringBuffer();
                tmp.append(this.m_baseDebugDumpDir);
                tmp.append(File.separatorChar);
                tmp.append(XTSDebugManager.getInstance().generateDirName(this.m_iSequenceCount, localName, null));
                sequenceBaseDebugDir = tmp.toString();
            }
            this.m_currentSequenceInstruction = new XTSSequenceInstruction();
            this.m_currentSequenceInstruction.initialize(this.m_env, this.m_parentBlkOrg, this, this.m_document, sequenceBaseDebugDir, childTimer, this.m_iSequenceCount++, this.m_blkid);
            if (!this.m_prefixNSDeclMap.isEmpty()) {
                Iterator it = this.m_prefixNSDeclMap.entrySet().iterator();
                Map.Entry pair = null;
                while (it.hasNext()) {
                    pair = it.next();
                    this.m_currentSequenceInstruction.startPrefixMapping((String)pair.getKey(), (String)pair.getValue());
                }
                this.m_prefixNSDeclMap.clear();
            }
            this.m_currentSequenceInstruction.startElement(namespaceURI, localName, qName, atts);
            this.m_bProcessingSequence = true;
        } else {
            this.m_currentSequenceInstruction.startElement(namespaceURI, localName, qName, atts);
        }
        ++this.m_currentInstDepth;
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (!this.m_bProcessingSequence) {
            return;
        }
        --this.m_currentInstDepth;
        if (this.m_currentInstDepth == 0) {
            this.m_currentSequenceInstruction.endElement(namespaceURI, localName, qName);
            this.m_currentSequenceInstruction.run();
            this.m_currentSequenceInstruction = null;
            this.m_bProcessingSequence = false;
        } else {
            this.m_currentSequenceInstruction.endElement(namespaceURI, localName, qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.m_currentSequenceInstruction != null) {
            if (this.m_currentEntity != null) {
                this.m_currentEntity = xmlutil.outEntityReference(this.m_currentEntity, ch, start, length);
                this.m_currentSequenceInstruction.characters(this.m_currentEntity.toCharArray(), 0, this.m_currentEntity.length());
            } else {
                this.m_currentSequenceInstruction.characters(ch, start, length);
            }
        }
        this.m_currentEntity = null;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.m_currentSequenceInstruction != null) {
            this.m_currentSequenceInstruction.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.m_currentSequenceInstruction != null) {
            this.m_currentSequenceInstruction.startPrefixMapping(prefix, uri);
        } else {
            this.m_prefixNSDeclMap.put(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.m_currentSequenceInstruction != null) {
            this.m_currentSequenceInstruction.endPrefixMapping(prefix);
        } else {
            this.m_prefixNSDeclMap.remove(prefix);
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.m_currentEntity = '&' + name + ';';
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        this.m_currentSequenceInstruction.startCDATA();
    }

    @Override
    public void endCDATA() throws SAXException {
        this.m_currentSequenceInstruction.endCDATA();
    }

    @Override
    public void comment(char[] ch, int start, int end) throws SAXException {
    }
}

