/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import java.util.Map;

public abstract class AXTSInstruction {
    private int m_iRefCount = 0;
    private static Object m_oMutexObj = null;

    protected AXTSInstruction() {
        m_oMutexObj = new Object();
    }

    public abstract String getIdentifier();

    public abstract void initialize(XTSEnvironment var1, String var2, Map var3, Map var4) throws XTSInstructionException;

    public abstract void terminate() throws XTSInstructionException;

    public abstract boolean isInitialized();

    public boolean isCachable() {
        return true;
    }

    public boolean isFaultBlockSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addRef() {
        Object object = m_oMutexObj;
        synchronized (object) {
            ++this.m_iRefCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release() {
        Object object = m_oMutexObj;
        synchronized (object) {
            --this.m_iRefCount;
            m_oMutexObj.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void terminateInst() throws XTSInstructionException {
        Object object = m_oMutexObj;
        synchronized (object) {
            while (this.m_iRefCount > 0) {
                try {
                    m_oMutexObj.wait();
                }
                catch (InterruptedException e) {
                    throw new XTSInstructionException("interpreter.sequenceexecutioninterrupted", e);
                }
            }
            this.terminate();
        }
    }

    public static String generateHashKey() {
        return null;
    }
}

