/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.util.RWLockManager;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public abstract class AXTSInstructionFactory {
    private static final int DEFAULT_CACHE_SIZE = 10;
    private int m_iCacheSize = 10;
    private HashMap m_oInstructionCache = new HashMap();
    private LinkedList m_oOrderMap = new LinkedList();
    private RWLockManager m_oMutex = new RWLockManager(new Object());

    public void initialize() throws XTSException {
        IXTSLogger logger;
        try {
            this.m_oMutex.writeLock();
            try {
                this.m_iCacheSize = this.getCacheSize();
            }
            finally {
                this.m_oMutex.releaseWriteLock();
            }
        }
        catch (InterruptedException e) {
            throw new XTSException("instructionfactory.cacheinitfailed", e);
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && (logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0)) != null) {
            logger.log(null, 0, this.getClass().getName(), null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() throws XTSException {
        IXTSLogger logger;
        try {
            this.m_oMutex.writeLock();
            try {
                Map.Entry pair2 = null;
                AXTSInstruction inst = null;
                for (Map.Entry pair2 : this.m_oInstructionCache.entrySet()) {
                    inst = (AXTSInstruction)pair2.getValue();
                    inst.terminateInst();
                }
                this.m_oInstructionCache.clear();
            }
            finally {
                this.m_oMutex.releaseWriteLock();
            }
        }
        catch (InterruptedException e) {
            throw new XTSException("instructionfactory.cachetermfailed", e);
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[3][0] && (logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0)) != null) {
            logger.log(null, 1, this.getClass().getName(), null, null);
        }
    }

    public void reinitialize() throws XTSException {
        this.terminate();
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getInstruction(XTSEnvironment env, Map instAtts, Map instParams) throws XTSInstructionException {
        Object inst;
        IXTSLogger logger;
        block15: {
            logger = null;
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (logger = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
                logger.log(env, 4, this.getClass().getName() + " - getInstruction", null, null);
            }
            inst = null;
            try {
                Object cache = instAtts.get("cache");
                if (cache != null && cache.toString().equals("false")) {
                    inst = this.createInstruction(env, instAtts, instParams);
                    return inst;
                }
                String hashKey = this.generateHashKey(env, instAtts, instParams);
                this.m_oMutex.readLock();
                try {
                    inst = this.m_oInstructionCache.get(hashKey);
                }
                finally {
                    this.m_oMutex.releaseReadLock();
                }
                if (inst != null) break block15;
                inst = this.createInstruction(env, instAtts, instParams);
                this.m_oMutex.writeLock();
                try {
                    if (this.m_oInstructionCache.get(hashKey) == null) {
                        String sRKey;
                        if (this.m_oInstructionCache.size() >= this.m_iCacheSize && this.m_oOrderMap.size() > 0 && (sRKey = (String)this.m_oOrderMap.removeFirst()) != null) {
                            this.m_oInstructionCache.remove(sRKey);
                        }
                        if (this.m_oInstructionCache.size() + 1 <= this.m_iCacheSize) {
                            this.m_oInstructionCache.put(hashKey, inst);
                        }
                        this.m_oOrderMap.addLast(hashKey);
                    }
                }
                finally {
                    this.m_oMutex.releaseWriteLock();
                }
            }
            catch (InterruptedException e) {
                throw new XTSInstructionException("instructionfactory.cachelockfailed", e);
            }
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && logger != null) {
            logger.log(env, 5, this.getClass().getName() + " - getInstruction", null, null);
        }
        return inst;
    }

    protected Object createInstruction(XTSEnvironment env, Map instAtts, Map instParams) throws XTSInstructionException {
        IXTSLogger logger = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (logger = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            logger.log(env, 4, this.getClass().getName() + " - createInstruction", null, null);
        }
        String instName = (String)instAtts.get("name");
        String className = PropertiesManager.getInstance().getProperty(this.getPropertyPrefix() + instName);
        if (className == null) {
            Object[] args = new String[]{instName};
            throw new XTSInstructionException("instructionfactory.undefinedinstruction", args);
        }
        Object inst = null;
        try {
            inst = Class.forName(className).newInstance();
        }
        catch (Exception e) {
            Object[] args = new String[]{instName};
            throw new XTSInstructionException("instructionfactory.instantiationerror", args, e);
        }
        try {
            ((AXTSInstruction)inst).initialize(env, instName, instAtts, instParams);
        }
        catch (XTSException e) {
            Object[] args = new String[]{instName};
            throw new XTSInstructionException("instructionfactory.initializationerror", args, e);
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && logger != null) {
            logger.log(env, 5, this.getClass().getName() + " - createInstruction", null, null);
        }
        return inst;
    }

    protected abstract String getPropertyPrefix();

    protected abstract String generateHashKey(XTSEnvironment var1, Map var2, Map var3) throws XTSInstructionException;

    protected int getCacheSize() {
        return 10;
    }
}

