/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions;

import com.cognos.xts.XTSException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXReaderPool;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.messages.MessagesManager;
import com.cognos.xts.util.soaputil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Locale;
import org.dom4j.Branch;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public class XTSFaultException
extends XTSInstructionException {
    private Reader m_faultReader = null;
    private Reader m_hdrReader = null;
    private Locale m_locale = null;
    private Element m_xtsFaultEle = null;
    private int m_soapVer = 11;
    private String m_faultCode = null;
    private String m_faultString = null;
    private Element m_soapFaultEle = null;

    public int getSoapVersion() {
        return this.m_soapVer;
    }

    public Reader getFaultReader() {
        return this.m_faultReader;
    }

    public Reader getFaultReaderCopy() {
        StringReader faultReader = null;
        if (this.m_faultReader != null) {
            StringBuffer buf = new StringBuffer();
            try {
                this.m_faultReader = UXTSInstructionUtils.copyReader(this.m_faultReader, buf);
                faultReader = new StringReader(buf.toString());
            }
            catch (IOException e) {
                return null;
            }
        }
        return faultReader;
    }

    public Reader getHdrReader() {
        return this.m_hdrReader;
    }

    public Reader getHdrReaderCopy() {
        StringReader hdrReader = null;
        if (this.m_hdrReader != null) {
            StringBuffer buf = new StringBuffer();
            try {
                this.m_hdrReader = UXTSInstructionUtils.copyReader(this.m_hdrReader, buf);
                hdrReader = new StringReader(buf.toString());
            }
            catch (IOException e) {
                return null;
            }
        }
        return hdrReader;
    }

    public XTSFaultException(Element xtsFaultEle, Locale locale) {
        super("interpreter.xtsfault");
        this.m_locale = locale;
        this.m_soapVer = 11;
        this.m_xtsFaultEle = xtsFaultEle.createCopy();
        this.m_faultCode = "interpreter.xtsfault";
        this.m_faultString = MessagesManager.getInstance().getMessage(locale, "interpreter.xtsfault");
        this.m_hdrReader = null;
        this.m_soapFaultEle = DocumentHelper.createElement((QName)soaputil.getSOAPFaultQName(this.m_soapVer));
        Element faultCodeEle = DocumentHelper.createElement((String)"faultcode");
        faultCodeEle.addText(this.m_faultCode);
        this.m_soapFaultEle.add(faultCodeEle);
        Element faultStringEle = DocumentHelper.createElement((String)"faultstring");
        if (this.m_faultString != null) {
            faultStringEle.addText(this.m_faultString);
        }
        this.m_soapFaultEle.add(faultStringEle);
        Element faultDetailEle = DocumentHelper.createElement((String)"detail");
        faultDetailEle.add(this.m_xtsFaultEle.createCopy());
        this.m_soapFaultEle.add(faultDetailEle);
        this.m_faultReader = new StringReader(this.m_soapFaultEle.asXML());
    }

    @Override
    public Element getSoapEnvElementCopy(Locale locale, int soapVer) {
        Element envEle = DocumentHelper.createElement((QName)soaputil.getSOAPEnvelopeQName(soapVer));
        Element bodyEle = DocumentHelper.createElement((QName)soaputil.getSOAPBodyQName(soapVer));
        envEle.add(bodyEle);
        bodyEle.add(this.m_soapFaultEle.createCopy());
        return envEle;
    }

    public StringBuffer getSoapEnvStringBufferCopy() {
        Element envEle = this.getSoapEnvElementCopy(this.m_locale, this.m_soapVer);
        if (envEle != null) {
            return new StringBuffer(envEle.asXML());
        }
        return null;
    }

    public Reader getSoapEnvReaderCopy() {
        Element envEle = this.getSoapEnvElementCopy(this.m_locale, this.m_soapVer);
        if (envEle != null) {
            return new StringReader(envEle.asXML());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getFaultXML(Locale locale, boolean stackdump) {
        Element exceptionElement = DocumentHelper.createElement((QName)EXCEPTION_QNAME);
        AXTSPoolObject reader = null;
        try {
            reader = XTSSAXReaderPool.getInstance().acquire();
        }
        catch (XTSException e) {
            return exceptionElement;
        }
        try {
            Element faultEle = ((SAXReader)reader.get()).read(new InputSource(this.getFaultReaderCopy())).getRootElement();
            Element excpetionCodeElement = DocumentHelper.createElement((QName)EXCEPTIONCODE_QNAME);
            excpetionCodeElement.addText(this.m_faultCode);
            exceptionElement.add(excpetionCodeElement);
            Element excpetionMsgElement = DocumentHelper.createElement((QName)EXCEPTIONMSG_QNAME);
            if (this.m_faultString != null) {
                excpetionMsgElement.addText(this.m_faultString);
            }
            exceptionElement.add(excpetionMsgElement);
            Element excpetionDetailElement = DocumentHelper.createElement((QName)EXCEPTIONDETAIL_QNAME);
            excpetionDetailElement.appendContent((Branch)faultEle.element("detail"));
            exceptionElement.add(excpetionDetailElement);
        }
        catch (DocumentException documentException) {
        }
        finally {
            XTSSAXReaderPool.getInstance().put(reader);
        }
        return exceptionElement;
    }
}

