/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.interpreter.instructions.IXTSFilterInstructionResult;
import com.cognos.xts.interpreter.instructions.IXTSOutputableInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.XTSSource;
import com.cognos.xts.output.XTSOutputContext;
import com.cognos.xts.output.XTSOutputObject;
import com.cognos.xts.output.XTSOutputSpecUtils;
import com.cognos.xts.util.ByteArrayIOStream;
import com.cognos.xts.util.SequenceReader;
import com.cognos.xts.util.XMLInputStreamToReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import org.dom4j.Document;
import org.dom4j.Element;

public class XTSFilterOutputableInstructionResult
implements IXTSFilterInstructionResult {
    protected XTSOutputContext m_instrOutputContext = null;
    protected IXTSOutputableInstructionResult m_instrResult = null;
    protected XTSEnvironment m_env = null;
    protected XTSSource m_source = null;
    protected boolean m_bReleaseByEnv = true;
    protected String m_instrQName = null;

    public XTSFilterOutputableInstructionResult(XTSEnvironment env, Document inputDoc, IXTSOutputableInstructionResult instrResult, XTSOutputContext instrOutputContext, String instrQName, List childInstResultList) throws XTSInstructionException {
        String partXML;
        InternetHeaders hdrs;
        InputStream attachmentIS;
        String refId;
        this.m_env = env;
        this.m_instrOutputContext = instrOutputContext;
        this.m_instrResult = instrResult;
        this.m_instrQName = instrQName;
        int supportedOptionsBitMap = this.m_instrResult.getSupportedOptionsBitMap();
        int instructionOption = this.m_instrOutputContext.getOption();
        if ((supportedOptionsBitMap & instructionOption) == 1) {
            XTSSource resultSource = this.m_instrResult.getResult();
            if (resultSource.getInputStream() != null && resultSource.getEncoding() == null) {
                ContentType contentType = this.m_instrResult.getDefaultMimeType();
                String charset = contentType.getParameter("charset");
                String encoding = resultSource.detectEncoding();
                if (charset != null) {
                    this.m_source = new XTSSource(resultSource.getInputStream(), charset.toUpperCase());
                } else if (encoding != null) {
                    this.m_source = new XTSSource(resultSource.getInputStream(), encoding);
                }
            }
            if (this.m_source == null) {
                this.m_source = this.m_instrResult.getResult();
            }
            this.m_bReleaseByEnv = false;
        } else if ((supportedOptionsBitMap & instructionOption) == 2) {
            refId = this.m_env.setContentStream(new XTSOutputObject(this.m_instrResult, childInstResultList));
            String contentXML = XTSOutputSpecUtils.createContentElement(this.m_instrOutputContext, refId).asXML();
            this.m_source = new XTSSource(new StringReader(contentXML));
        } else if ((supportedOptionsBitMap & instructionOption) == 4) {
            refId = this.m_env.setContentStream(new XTSOutputObject(this.m_instrResult, childInstResultList));
            InternetHeaders hdrs2 = this.m_instrResult.getProtocolHeaders();
            if (hdrs2 == null) {
                hdrs2 = new InternetHeaders();
            }
            if (this.m_instrOutputContext.getMimeType() == null) {
                hdrs2.addHeader("Content-Type", this.m_instrResult.getDefaultMimeType().toString());
            } else {
                hdrs2.removeHeader("Content-Type");
            }
            StringBuffer buf = new StringBuffer(256);
            XTSOutputSpecUtils.createPartElementAsString(this.m_instrOutputContext, hdrs2, refId, buf);
            this.m_source = new XTSSource(new StringReader(buf.toString()));
        } else if ((supportedOptionsBitMap & instructionOption) == 8) {
            refId = this.m_env.setContentStream(new XTSOutputObject(this.m_instrResult, childInstResultList));
            attachmentIS = this.m_instrResult.getAttachmentInputStream();
            if (attachmentIS != null) {
                hdrs = null;
                try {
                    hdrs = new InternetHeaders(attachmentIS);
                }
                catch (MessagingException e) {
                    throw new XTSInstructionException("soap.invalidmimeheaders", e);
                }
                partXML = XTSOutputSpecUtils.createPartElement(this.m_instrOutputContext, hdrs, refId).asXML();
                this.m_source = new XTSSource(new SequenceReader(this.m_instrResult.getResult().getReader(), new StringReader(partXML)));
            } else {
                this.m_source = new XTSSource(this.m_instrResult.getResult().getReader());
            }
        } else if ((supportedOptionsBitMap & instructionOption) == 16) {
            refId = this.m_env.setContentStream(new XTSOutputObject(this.m_instrResult, childInstResultList));
            attachmentIS = this.m_instrResult.getAttachmentInputStream();
            if (attachmentIS == null) {
                Object[] args = new String[]{instrOutputContext.getOptionString()};
                throw new XTSInstructionException("output.noattachmentreturned", args);
            }
            hdrs = null;
            try {
                hdrs = new InternetHeaders(attachmentIS);
            }
            catch (MessagingException e) {
                throw new XTSInstructionException("soap.invalidmimeheaders", e);
            }
            partXML = XTSOutputSpecUtils.createPartElement(this.m_instrOutputContext, hdrs, refId).asXML();
            this.m_source = new XTSSource(new StringReader(partXML));
        } else {
            Object[] args = new Object[]{this.m_instrOutputContext.getOptionString()};
            throw new XTSInstructionException("instruction.output.optionnotsupported", args);
        }
        if (this.m_instrResult.protocolHeaderSupported() && this.m_instrOutputContext.isProtocolHeader()) {
            Element protocolHeaderElem = XTSOutputSpecUtils.createProtocolHeaderElement(this.m_instrResult.getProtocolHeaders());
            if (this.m_instrOutputContext.getProtocolHeaderSelect() != null) {
                List appendlist = inputDoc.selectNodes(this.m_instrOutputContext.getProtocolHeaderSelect());
                Object obj = null;
                for (int i = 0; i < appendlist.size(); ++i) {
                    obj = appendlist.get(i);
                    if (!(obj instanceof Element)) {
                        Object[] args = new String[]{"protocolHeaderSelect", this.m_instrOutputContext.getProtocolHeaderSelect()};
                        throw new XTSInstructionException("instruction.output.protocolheadernonelementselect", args);
                    }
                    ((Element)obj).add(protocolHeaderElem.createCopy());
                }
            } else {
                String protocolHeaderXML = protocolHeaderElem.asXML();
                if (this.m_source == null) {
                    this.m_source = new XTSSource(new StringReader(protocolHeaderXML));
                } else if (this.m_source.getReader() != null) {
                    this.m_source = new XTSSource(new SequenceReader(this.m_source.getReader(), new StringReader(protocolHeaderXML)));
                } else {
                    try {
                        this.m_source = new XTSSource(new SequenceReader(XMLInputStreamToReader.convert(this.m_source.getInputStream()), new StringReader(protocolHeaderXML)));
                    }
                    catch (Exception e) {
                        Object[] args = new String[]{this.m_instrQName};
                        throw new XTSInstructionException("instruction.convertxmlinputstreamtoreaderfailed", args, e);
                    }
                }
            }
        } else if (!this.m_instrResult.protocolHeaderSupported() && this.m_instrOutputContext.isProtocolHeader()) {
            Object[] args = new Object[]{this.m_instrOutputContext.getOptionString()};
            throw new XTSInstructionException("instruction.output.protocolheadernotsupported", args);
        }
    }

    @Override
    public XTSSource getResult() throws XTSInstructionException {
        return this.m_source;
    }

    @Override
    public void release() throws XTSInstructionException {
        if (!this.m_bReleaseByEnv) {
            this.m_instrResult.release();
        }
    }

    @Override
    public void writeCopyTo(OutputStream out) throws XTSInstructionException {
        try {
            Reader reader = this.m_source.getReader();
            if (reader == null) {
                InputStream stream = this.m_source.getInputStream();
                ByteArrayIOStream bio = new ByteArrayIOStream();
                byte[] buf = new byte[4096];
                int bytesRead = stream.read(buf, 0, 4096);
                while (bytesRead != -1) {
                    bio.write(buf, 0, bytesRead);
                    bytesRead = stream.read(buf, 0, 4096);
                }
                bio.writeTo(out);
                this.m_source = new XTSSource(bio.convert());
            } else {
                ByteArrayIOStream bio = new ByteArrayIOStream();
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)bio, "UTF-8"));
                char[] buf = new char[4096];
                int bytesRead = reader.read(buf, 0, 4096);
                while (bytesRead != -1) {
                    ((Writer)writer).write(buf, 0, bytesRead);
                    bytesRead = reader.read(buf, 0, 4096);
                }
                ((Writer)writer).flush();
                bio.writeTo(out);
                this.m_source = new XTSSource(new BufferedReader(new InputStreamReader((InputStream)bio.convert(), "UTF-8")));
            }
        }
        catch (Exception e) {
            Object[] args = new String[]{this.getClass().getName()};
            throw new XTSInstructionException("instruction.writetooutputstreamfailed", args, e);
        }
    }
}

