/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions;

import com.cognos.xts.UXTSExceptionUtils;
import com.cognos.xts.XTSBlock;
import com.cognos.xts.XTSBlockOrganizer;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.baltic.request.XTSCMResult;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXReaderPool;
import com.cognos.xts.common.thread.IXTSRerunnable;
import com.cognos.xts.interpreter.XTSBlockInterpreter2;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSFilterInstructionResult;
import com.cognos.xts.interpreter.instructions.IXTSInputDocumentUpdateResult;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.IXTSOutputableInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSFaultBlockResult;
import com.cognos.xts.interpreter.instructions.XTSFaultException;
import com.cognos.xts.interpreter.instructions.XTSFilterOutputableInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.XTSOutputableInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSQueryNodeResult;
import com.cognos.xts.interpreter.instructions.XTSQueryValueResult;
import com.cognos.xts.interpreter.instructions.XTSSource;
import com.cognos.xts.interpreter.instructions.XTSTestBlockResult;
import com.cognos.xts.interpreter.instructions.function.IXTSFunctionInstruction;
import com.cognos.xts.interpreter.instructions.function.XTSFunctionFactory;
import com.cognos.xts.interpreter.instructions.nodeop.IXTSNodeOpInstruction;
import com.cognos.xts.interpreter.instructions.nodeop.XTSNodeOpFactory;
import com.cognos.xts.interpreter.instructions.nodeop.XTSNodeOpHelpers;
import com.cognos.xts.interpreter.instructions.request.IXTSRequestInstruction;
import com.cognos.xts.interpreter.instructions.request.XTSBusException;
import com.cognos.xts.interpreter.instructions.request.XTSBusResult;
import com.cognos.xts.interpreter.instructions.request.XTSRequestFactory;
import com.cognos.xts.interpreter.instructions.request.XTSSoapFaultException;
import com.cognos.xts.interpreter.instructions.request.XTSXtsBusResult;
import com.cognos.xts.interpreter.instructions.transform.IXTSTransformInstruction;
import com.cognos.xts.interpreter.instructions.transform.IXTSTransformInstruction2;
import com.cognos.xts.interpreter.instructions.transform.XTSTransformFactory;
import com.cognos.xts.logging.IXTSDebugLog;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSDebugManager;
import com.cognos.xts.logging.XTSPerfLoggerManager;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.output.XTSOutputContext;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.util.ByteArrayIOStream;
import com.cognos.xts.util.CharArrayReaderWriter;
import com.cognos.xts.util.SequenceReader;
import com.cognos.xts.util.StopWatchTimer;
import com.cognos.xts.util.XMLInputStreamToReader;
import com.cognos.xts.util.XTSOutputHeaderUtil;
import com.cognos.xts.util.xmlutil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXReader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class XTSSequenceInstruction
extends DefaultHandler
implements IXTSRerunnable,
LexicalHandler {
    private static final int BUFFER_SIZE = 4096;
    private static final String DEBUG = "debug";
    private static final String DEBUG_TRUE = "true";
    private static final String DEBUG_FALSE = "false";
    private static final String ENCODING = "UTF-8";
    private static final String DUMMYROOT_ELEMENT_START = "<dummyroot>";
    private static final String DUMMYROOT_ELEMENT_END = "</dummyroot>";
    private static final String PROCESSOR = "processor";
    private static final String SRC = "src";
    protected static final char OPEN_BRACKET_START = '<';
    protected static final char OPEN_BRACKET_END = '>';
    protected static final char[] CLOSE_BRACKET_START = new char[]{'<', '/'};
    protected static final char CLOSE_BRACKET_END = '>';
    protected static final char[] XMLNS = new char[]{'x', 'm', 'l', 'n', 's'};
    protected static final char EQUALS = '=';
    protected static final char QUOTE = '\"';
    protected static final char SPACE = ' ';
    protected static final char COLON = ':';
    protected static final char[] CDATA_START = new char[]{'<', '!', '[', 'C', 'D', 'A', 'T', 'A', '['};
    protected static final char[] CDATA_END = new char[]{']', ']', '>'};
    private static Set m_xtsInstructionSet = new HashSet();
    private static HashMap m_mimeMediaTypeFileExtensionMap;
    private XTSEnvironment m_env = null;
    private XTSBlockInterpreter2 m_sourceBlockInterpreter = null;
    private XTSInstructionWrapper m_currentWrapper = null;
    private Document m_document = null;
    private HashMap m_currentGlobalScopePrefixNSMap = new HashMap();
    private HashMap m_currentInstScopePrefixNSMap = new HashMap();
    private boolean m_bDebugEnabled = false;
    private XTSBlockOrganizer m_parentBlkOrg = null;
    protected String m_baseDebugDumpDir = null;
    private StopWatchTimer m_timer = null;
    private String m_id = null;
    private String m_blkid = null;

    @Override
    public boolean recycle() {
        this.cleanup();
        return true;
    }

    @Override
    public void terminate() {
        this.cleanup();
    }

    private void cleanup() {
        this.m_env = null;
        this.m_sourceBlockInterpreter = null;
        this.m_currentWrapper = null;
        this.m_document = null;
        this.m_currentGlobalScopePrefixNSMap = new HashMap();
        this.m_currentInstScopePrefixNSMap = new HashMap();
        this.m_bDebugEnabled = false;
        this.m_parentBlkOrg = null;
        this.m_baseDebugDumpDir = null;
        this.m_timer = null;
        this.m_id = null;
        this.m_blkid = null;
    }

    public void initialize(XTSEnvironment env, XTSBlockOrganizer parent, XTSBlockInterpreter2 sourceBlockInterpreter, Document document, String baseDebugDumpDir, StopWatchTimer timer, int seqid, String blkid) {
        this.m_env = env;
        this.m_sourceBlockInterpreter = sourceBlockInterpreter;
        this.m_document = document;
        this.m_bDebugEnabled = (this.m_env.getMode() & 2) > 0;
        this.m_baseDebugDumpDir = baseDebugDumpDir;
        this.m_parentBlkOrg = parent;
        this.m_timer = timer;
        this.m_id = Integer.toString(seqid);
        this.m_blkid = blkid;
    }

    @Override
    public void run() {
        IXTSLogger traceLogger3 = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger3 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger3.log(this.m_env, 4, "XTSSequenceInstruction Thread", null, null);
        }
        if (this.m_bDebugEnabled) {
            this.m_timer.start();
        }
        try {
            IXTSLogger pLogger = null;
            if (XTSPerfLoggerManager.getInstance().isEnabled[3][0] && (pLogger = XTSPerfLoggerManager.getInstance().getLogger(3, 0)) != null) {
                pLogger.log(this.m_env, 6, this.getClass().getName(), "run", "Sequence:" + this.m_id + "::" + this.m_blkid);
                pLogger.starttimer();
            }
            this.m_currentWrapper.execute(this);
            if (pLogger != null) {
                pLogger.stoptimer();
                pLogger.log(this.m_env, 1, this.getClass().getName(), "run", "Sequence:" + this.m_id + "::" + this.m_blkid);
            }
        }
        catch (Throwable e) {
            Object[] args = new String[]{this.m_blkid};
            this.m_sourceBlockInterpreter.updateStatus(new XTSInstructionException("instruction.executefailed", args, e));
        }
        if (this.m_bDebugEnabled) {
            this.m_timer.stop();
            this.m_timer.getParent().pause();
            IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
            if (debuglogger != null) {
                debuglogger.log(this.m_env, this.m_baseDebugDumpDir, "timing.xml", this.m_timer.toXMLString());
            }
            this.m_timer.getParent().unpause();
        }
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger3 != null) {
            traceLogger3.log(this.m_env, 5, "XTSSequenceInstruction Thread", null, null);
        }
    }

    public String getSequenceId() {
        return this.m_id;
    }

    protected IXTSInstructionResult executeXTSInstruction(XTSInstructionWrapper instrWrapper) throws XTSInstructionException {
        String faultBlockId;
        Map instAtts = instrWrapper.getInstAtts();
        Map instParams = instrWrapper.getInstParams();
        String localName = instrWrapper.getLocalName();
        String debugDumpDir = null;
        boolean bDebugEnabled = this.m_bDebugEnabled;
        if (bDebugEnabled) {
            this.m_timer.pause();
            String sDebugAttribute = (String)instAtts.get(DEBUG);
            if (sDebugAttribute != null && sDebugAttribute.equals(DEBUG_FALSE)) {
                bDebugEnabled = false;
            }
            debugDumpDir = (String)instAtts.get("baseDebugDir");
            this.m_timer.unpause();
        }
        if (bDebugEnabled) {
            this.m_timer.pause();
            IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
            if (debuglogger != null) {
                debuglogger.log(this.m_env, debugDumpDir, "source.xml", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + instrWrapper.toString());
            }
            if (this.m_document == null) {
                throw new XTSInstructionException("interpreter.nulldocument");
            }
            IXTSDebugLog debuglogger2 = XTSDebugManager.getInstance().getLogger();
            if (debuglogger2 != null) {
                debuglogger2.log(this.m_env, debugDumpDir, "input.xml", this.m_document);
            }
            this.m_timer.unpause();
        }
        IXTSLogger traceLogger3 = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger3 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger3.log(this.m_env, 4, localName, null, null);
        }
        IXTSLogger traceLogger5 = null;
        if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger5 = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
            traceLogger5.log(this.m_env, 8, "Source: ", null, null);
            traceLogger5.log(this.m_env, 8, instrWrapper.toString(), null, null);
        }
        IXTSInstructionResult result = null;
        try {
            StopWatchTimer childTimer = null;
            if (bDebugEnabled) {
                childTimer = this.m_timer.createChild();
                childTimer.start();
            }
            if (localName.equals("queryNode")) {
                result = this.executeXTSQueryNode(localName, instAtts, instParams);
            } else if (localName.equals("queryValue")) {
                result = this.executeXTSQueryValue(localName, instAtts, instParams);
            } else if (localName.equals("transform")) {
                XTSOutputContext outputContext;
                result = this.executeXTSTransform(localName, instAtts, instParams, instrWrapper.getInstBody());
                if (result instanceof IXTSOutputableInstructionResult && (outputContext = instrWrapper.getOutputContext()) != null) {
                    try {
                        outputContext.setProperty("mimeType", ((IXTSOutputableInstructionResult)result).getDefaultMimeType().toString());
                    }
                    catch (XTSException e) {
                        throw new XTSInstructionException(e.getRootCauseLocalizedMsgString(this.m_env.getLocale()));
                    }
                }
            } else if (localName.equals("request")) {
                result = this.executeXTSRequest(localName, instAtts, instParams, instrWrapper.getInstBody());
            } else if (localName.equals("function") || XTSFunctionFactory.getInstance().isXTSFunctionInstruction(localName)) {
                result = this.executeXTSFunction(localName, instAtts, instParams, instrWrapper.getInstBody());
            } else if (XTSNodeOpFactory.getInstance().isXTSNodeOpInstruction(localName)) {
                result = this.executeXTSNodeOp(localName, instAtts, instParams, instrWrapper.getInstBody());
            } else if (localName.equals("param")) {
                XTSInstructionWrapper parent = instrWrapper.getParent();
                StringBuffer paramBodyBuf = new StringBuffer();
                Reader paramBodyReader = instrWrapper.getInstBody();
                if (paramBodyReader != null) {
                    try {
                        char[] buf = new char[4096];
                        int bytesRead = paramBodyReader.read(buf, 0, 4096);
                        while (bytesRead != -1) {
                            paramBodyBuf.append(buf, 0, bytesRead);
                            bytesRead = paramBodyReader.read(buf, 0, 4096);
                        }
                    }
                    catch (IOException e) {
                        Object[] args = new Object[]{instrWrapper.getQName()};
                        throw new XTSInstructionException("instruction.readbodycontentfailed", args);
                    }
                }
                parent.addParameter((String)instrWrapper.getInstAtts().get("name"), paramBodyBuf.toString());
            } else if (localName.equals("sequence")) {
                if (instAtts.get("faultSelect") != null) {
                    this.appendFaultBlock(localName, instAtts, instParams, instrWrapper.getInstBody());
                }
            } else if (localName.equals("output-param")) {
                Object[] args = new Object[]{instrWrapper.getQName()};
                throw new XTSInstructionException("instruction.instructionnolongersupported", args);
            }
            if (bDebugEnabled) {
                IXTSDebugLog debuglogger;
                childTimer.stop();
                this.m_timer.pause();
                if ((localName.equals("queryNode") || localName.equals("queryValue") || localName.equals("transform") || localName.equals("request") || localName.equals("function") || XTSFunctionFactory.getInstance().isXTSFunctionInstruction(localName) || XTSNodeOpFactory.getInstance().isXTSNodeOpInstruction(localName)) && (debuglogger = XTSDebugManager.getInstance().getLogger()) != null) {
                    debuglogger.log(this.m_env, debugDumpDir, "timing.xml", childTimer.toXMLString());
                }
                this.m_timer.unpause();
            }
        }
        catch (XTSInstructionException e) {
            faultBlockId = (String)instAtts.get("faultBlock");
            if (faultBlockId == null) {
                throw e;
            }
            result = this.processFaultBlock(localName, faultBlockId, (String)instAtts.get("baseDebugDir"), e);
        }
        try {
            XTSOutputContext outputContext;
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger5 != null) {
                try {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    result.writeCopyTo(bout);
                    if (traceLogger5 != null) {
                        traceLogger5.log(this.m_env, 8, "Result: ", null, null);
                        traceLogger5.log(this.m_env, 8, bout.toString(ENCODING), null, null);
                    }
                }
                catch (Exception bout) {
                    // empty catch block
                }
            }
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && traceLogger3 != null) {
                traceLogger3.log(this.m_env, 5, localName, null, null);
            }
            if (bDebugEnabled) {
                this.m_timer.pause();
                if (result != null) {
                    ByteArrayIOStream bio = new ByteArrayIOStream();
                    result.writeCopyTo(bio);
                    String fileName = "result";
                    if (result != null && result instanceof IXTSOutputableInstructionResult) {
                        String fileExtension = (String)m_mimeMediaTypeFileExtensionMap.get(((IXTSOutputableInstructionResult)result).getDefaultMimeType().getBaseType());
                        if (fileExtension != null) {
                            fileName = fileName + fileExtension;
                        }
                    } else {
                        fileName = "result.xml";
                    }
                    IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
                    if (debuglogger != null) {
                        debuglogger.log(this.m_env, debugDumpDir, fileName, bio.toByteArray());
                    }
                }
                if (this.m_document == null) {
                    result.release();
                    throw new XTSInstructionException("interpreter.nulldocument");
                }
                IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
                if (debuglogger != null) {
                    debuglogger.log(this.m_env, debugDumpDir, "output.xml", this.m_document);
                }
                this.m_timer.unpause();
            }
            if (result instanceof IXTSInputDocumentUpdateResult) {
                ((IXTSInputDocumentUpdateResult)result).updateInputDocument(this.m_document);
            }
            if (result instanceof IXTSOutputableInstructionResult && (outputContext = instrWrapper.getOutputContext()) != null) {
                result = result instanceof IXTSFilterInstructionResult ? new XTSFilterOutputableInstructionResult(this.m_env, this.m_document, (IXTSOutputableInstructionResult)result, outputContext, instrWrapper.getQName(), instrWrapper.getChildInstResultList()) : new XTSOutputableInstructionResult(this.m_env, this.m_document, (IXTSOutputableInstructionResult)result, outputContext, instrWrapper.getQName());
            }
        }
        catch (XTSInstructionException e) {
            faultBlockId = (String)instAtts.get("faultBlock");
            if (faultBlockId == null) {
                throw e;
            }
            result = this.processFaultBlock(localName, faultBlockId, (String)instAtts.get("baseDebugDir"), e);
        }
        return result;
    }

    private IXTSInstructionResult executeXTSQueryValue(String localName, Map instAtts, Map instParams) throws XTSInstructionException {
        String sAttValue = (String)instAtts.get("select");
        if (sAttValue != null) {
            IXTSLogger pLogger = null;
            if (XTSPerfLoggerManager.getInstance().isEnabled[4][0] && (pLogger = XTSPerfLoggerManager.getInstance().getLogger(4, 0)) != null) {
                pLogger.log(this.m_env, 6, this.getClass().getName(), "executeXTSQueryValue", "queryValue: " + sAttValue + ", sequence: " + this.m_id + ", block: " + this.m_blkid);
                pLogger.starttimer();
            }
            String result = null;
            if (this.m_document == null) {
                throw new XTSInstructionException("interpreter.nulldocument");
            }
            if (!XTSNodeOpHelpers.validateSelectXpath(sAttValue)) {
                Object[] args = new String[]{sAttValue, localName};
                throw new XTSInstructionException("nodeoperation.invalidnode", args);
            }
            result = this.m_document.valueOf(sAttValue);
            XTSQueryValueResult queryValueResult = new XTSQueryValueResult(result);
            if (pLogger != null) {
                pLogger.stoptimer();
                pLogger.log(this.m_env, 1, this.getClass().getName(), "executeXTSQueryValue", "queryValue: " + sAttValue + ", sequence: " + this.m_id + ", block: " + this.m_blkid);
            }
            return queryValueResult;
        }
        Object[] args = new String[]{localName};
        throw new XTSInstructionException("interpreter.missingselectattribute", args);
    }

    private IXTSInstructionResult executeXTSQueryNode(String localName, Map instAtts, Map instParams) throws XTSInstructionException {
        String sAttValue = (String)instAtts.get("select");
        if (sAttValue != null) {
            IXTSLogger pLogger = null;
            if (XTSPerfLoggerManager.getInstance().isEnabled[4][0] && (pLogger = XTSPerfLoggerManager.getInstance().getLogger(4, 0)) != null) {
                pLogger.log(this.m_env, 6, this.getClass().getName(), "executeXTSQueryNode", "queryNode: " + sAttValue + ", sequence: " + this.m_id + ", block: " + this.m_blkid);
                pLogger.starttimer();
            }
            List result = null;
            if (this.m_document == null) {
                throw new XTSInstructionException("interpreter.nulldocument");
            }
            if (!XTSNodeOpHelpers.validateSelectXpath(sAttValue)) {
                Object[] args = new String[]{sAttValue, localName};
                throw new XTSInstructionException("nodeoperation.invalidnode", args);
            }
            result = this.m_document.selectNodes(sAttValue);
            XTSQueryNodeResult queryNodeResult = new XTSQueryNodeResult(result);
            if (pLogger != null) {
                pLogger.stoptimer();
                pLogger.log(this.m_env, 1, this.getClass().getName(), "executeXTSQueryNode", "queryNode: " + sAttValue + ", sequence: " + this.m_id + ", block: " + this.m_blkid);
            }
            return queryNodeResult;
        }
        Object[] args = new String[]{localName};
        throw new XTSInstructionException("interpreter.missingselectattribute", args);
    }

    private IXTSInstructionResult executeXTSTransform(String localName, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        String mimeType;
        String src;
        String processor;
        IXTSLogger pLogger = null;
        String sNodeList = null;
        if (XTSPerfLoggerManager.getInstance().isEnabled[4][0] && (pLogger = XTSPerfLoggerManager.getInstance().getLogger(4, 0)) != null) {
            sNodeList = (String)instAtts.get("nodelist");
            if (sNodeList != null) {
                pLogger.log(this.m_env, 6, this.getClass().getName(), "executeXTSTransform", "sequence: " + this.m_id + ", block: " + this.m_blkid + ", nodelist: " + sNodeList);
            } else {
                pLogger.log(this.m_env, 6, this.getClass().getName(), "executeXTSTransform", "sequence: " + this.m_id + ", block: " + this.m_blkid);
            }
            pLogger.starttimer();
        }
        if ((processor = (String)instAtts.get(PROCESSOR)) != null) {
            instAtts.remove(PROCESSOR);
            instAtts.put("name", processor);
        }
        if ((src = (String)instAtts.get(SRC)) != null) {
            instAtts.remove(SRC);
            String[] values = new String[]{src};
            instParams.put("systemId", values);
        }
        if ((mimeType = (String)instAtts.get("mimeType")) != null) {
            instAtts.remove("mimeType");
            try {
                ContentType contentType = new ContentType(mimeType);
                String[] mediaType = new String[]{contentType.getBaseType()};
                instParams.put("mediaType", mediaType);
                String encoding = contentType.getParameter("charset");
                if (encoding != null) {
                    String[] values = new String[]{encoding};
                    instParams.put("encoding", values);
                }
            }
            catch (ParseException e) {
                Object[] args = new Object[]{instAtts.get("name"), mimeType};
                throw new XTSInstructionException("instruction.transform.invalidcontenttype", args, e);
            }
        }
        IXTSInstructionResult result = null;
        String systemIdParam = UXTSInstructionUtils.getParameter("systemId", instParams);
        if (systemIdParam != null && !"".equals(systemIdParam)) {
            try {
                body = xmlutil.removeDOCTYPEInProlog(body);
            }
            catch (Throwable e) {
                throw new XTSInstructionException("protocol.ioexception", e);
            }
        }
        if ((this.m_env.getMode() & 1) > 0 && instAtts.get("testBlock") != null) {
            result = this.processTestBlock(localName, (String)instAtts.get("testBlock"), (String)instAtts.get("baseDebugDir"));
        } else {
            instParams.put("uriResolver", this.m_parentBlkOrg.getExecblock(this.m_blkid));
            XTSTransformFactory transformFactory = XTSTransformFactory.getInstance();
            IXTSTransformInstruction transformInst = (IXTSTransformInstruction)transformFactory.getInstruction(this.m_env, instAtts, instParams);
            result = transformInst instanceof IXTSTransformInstruction2 ? ((IXTSTransformInstruction2)transformInst).execute(this.m_env, this.m_document, instAtts, instParams, body) : transformInst.execute(this.m_env, instAtts, instParams, body);
        }
        if (pLogger != null) {
            pLogger.stoptimer();
            if (sNodeList != null) {
                pLogger.log(this.m_env, 1, this.getClass().getName(), "executeXTSTransform", "sequence: " + this.m_id + ", block: " + this.m_blkid + ", nodelist: " + sNodeList);
            } else {
                pLogger.log(this.m_env, 1, this.getClass().getName(), "executeXTSTransform", "sequence: " + this.m_id + ", block: " + this.m_blkid);
            }
        }
        return result;
    }

    private IXTSInstructionResult executeXTSFunction(String localName, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        if (!localName.equals("function")) {
            instAtts.put("name", localName);
        }
        String sFcnName = (String)instAtts.get("name");
        IXTSLogger pLogger = null;
        if (XTSPerfLoggerManager.getInstance().isEnabled[4][0] && (pLogger = XTSPerfLoggerManager.getInstance().getLogger(4, 0)) != null) {
            pLogger.log(this.m_env, 6, this.getClass().getName(), "executeXTSFunction", "Name: " + sFcnName + ", sequence: " + this.m_id + ", block: " + this.m_blkid);
            pLogger.starttimer();
        }
        IXTSInstructionResult result = null;
        if ((this.m_env.getMode() & 1) > 0 && instAtts.get("testBlock") != null) {
            result = this.processTestBlock(localName, (String)instAtts.get("testBlock"), (String)instAtts.get("baseDebugDir"));
        } else {
            XTSFunctionFactory functionFactory = XTSFunctionFactory.getInstance();
            IXTSFunctionInstruction functionInst = (IXTSFunctionInstruction)functionFactory.getInstruction(this.m_env, instAtts, instParams);
            result = functionInst.execute(this.m_env, instAtts, instParams);
        }
        if (pLogger != null) {
            pLogger.stoptimer();
            pLogger.log(this.m_env, 1, this.getClass().getName(), "executeXTSFunction", "Name: " + sFcnName + ", sequence: " + this.m_id + ", block: " + this.m_blkid);
        }
        return result;
    }

    private void setSoapHeader(Reader soapHdrReader, IXTSRequestInstruction requestInst) throws XTSInstructionException {
        if (soapHdrReader != null) {
            AXTSPoolObject reader = null;
            try {
                reader = XTSSAXReaderPool.getInstance().acquire();
            }
            catch (XTSException e) {
                Object[] args = new Object[]{((AXTSInstruction)((Object)requestInst)).getIdentifier()};
                throw new XTSInstructionException("interpreter.parsesoapheaderfailed", args, e);
            }
            Element soapHdrElem = null;
            try {
                soapHdrElem = ((SAXReader)reader.get()).read(new InputSource(soapHdrReader)).getRootElement();
            }
            catch (Exception e) {
                Object[] args = new Object[]{((AXTSInstruction)((Object)requestInst)).getIdentifier()};
                throw new XTSInstructionException("interpreter.parsesoapheaderfailed", args, e);
            }
            finally {
                XTSSAXReaderPool.getInstance().put(reader);
            }
            soapHdrElem.detach();
            XTSOutputHeaderUtil.setSoapHeader(soapHdrElem, this.m_document);
        }
    }

    private IXTSInstructionResult executeXTSRequest(String localName, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        String outputHeader;
        String responseEnvelope;
        String href;
        String protocol;
        IXTSLogger pLogger = null;
        if (XTSPerfLoggerManager.getInstance().isEnabled[1][0] && (pLogger = XTSPerfLoggerManager.getInstance().getLogger(1, 0)) != null) {
            pLogger.log(this.m_env, 6, this.getClass().getName(), "executeXTSRequest", "sequence: " + this.m_id + ", block: " + this.m_blkid);
            pLogger.starttimer();
        }
        if ((protocol = (String)instAtts.get("protocol")) != null) {
            instAtts.remove("protocol");
            instAtts.put("name", protocol);
        }
        if ((href = (String)instAtts.get("href")) != null) {
            instAtts.remove("href");
            instAtts.put("target", href);
        }
        if ((responseEnvelope = (String)instAtts.get("responseEnvelope")) != null) {
            instAtts.remove("responseEnvelope");
            String[] values = new String[]{responseEnvelope};
            instParams.put("responseEnvelope", values);
        }
        if ((outputHeader = (String)instAtts.get("outputHeader")) != null) {
            instAtts.remove("outputHeader");
            String[] values = new String[]{outputHeader};
            instParams.put("outputHeader", values);
        } else {
            outputHeader = UXTSInstructionUtils.getParameter("outputHeader", instParams);
        }
        String soapAction = (String)instAtts.get("soapAction");
        if (soapAction != null) {
            instAtts.remove("soapAction");
            String[] values = new String[]{soapAction};
            instParams.put("soapAction", values);
        }
        IXTSInstructionResult result = null;
        if ((this.m_env.getMode() & 1) > 0 && instAtts.get("testBlock") != null) {
            result = this.processTestBlock(localName, (String)instAtts.get("testBlock"), (String)instAtts.get("baseDebugDir"));
        } else {
            XTSRequestFactory requestFactory = XTSRequestFactory.getInstance();
            IXTSRequestInstruction requestInst = (IXTSRequestInstruction)requestFactory.getInstruction(this.m_env, instAtts, instParams);
            try {
                result = requestInst.execute(this.m_env, instAtts, instParams, body);
                if ((result instanceof XTSBusResult || result instanceof XTSXtsBusResult) && outputHeader != null && outputHeader.equals(DEBUG_TRUE)) {
                    Reader soapHdrReader = null;
                    soapHdrReader = result instanceof XTSBusResult ? ((XTSBusResult)result).getSOAPHeader() : ((XTSXtsBusResult)result).getSOAPHeader();
                    this.setSoapHeader(soapHdrReader, requestInst);
                } else if (result instanceof XTSCMResult) {
                    Reader soapHdrReader = ((XTSCMResult)result).getSOAPHeader();
                    this.setSoapHeader(soapHdrReader, requestInst);
                }
            }
            catch (XTSSoapFaultException e) {
                boolean bDebugEnabled;
                Reader hdrReader;
                if (e instanceof XTSBusException && outputHeader != null && outputHeader.equals(DEBUG_TRUE) && (hdrReader = e.getHdrReaderCopy()) != null) {
                    this.setSoapHeader(hdrReader, requestInst);
                }
                if (bDebugEnabled = this.m_bDebugEnabled) {
                    String debugDumpDir;
                    String sDebugAttribute = (String)instAtts.get(DEBUG);
                    if (sDebugAttribute != null && sDebugAttribute.equals(DEBUG_FALSE)) {
                        bDebugEnabled = false;
                    }
                    if (bDebugEnabled && (debugDumpDir = (String)instAtts.get("baseDebugDir")) != null) {
                        ByteArrayIOStream bio = new ByteArrayIOStream();
                        try {
                            bio.write(xmlutil.m_defaultXMLHeaderByte);
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace(System.err);
                        }
                        StringBuffer envBuffer = e.getSoapEnvStringBufferCopy();
                        IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
                        if (debuglogger != null) {
                            debuglogger.log(this.m_env, debugDumpDir, "fault.xml", envBuffer == null ? "" : envBuffer.toString());
                        }
                    }
                }
                throw e;
            }
        }
        if (pLogger != null) {
            pLogger.stoptimer();
            pLogger.log(this.m_env, 1, this.getClass().getName(), "executeXTSRequest", "sequence: " + this.m_id + ", block: " + this.m_blkid);
        }
        return result;
    }

    private IXTSInstructionResult executeXTSNodeOp(String localName, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        IXTSLogger pLogger = null;
        if (XTSPerfLoggerManager.getInstance().isEnabled[4][0] && (pLogger = XTSPerfLoggerManager.getInstance().getLogger(4, 0)) != null) {
            pLogger.log(this.m_env, 6, this.getClass().getName(), "executeXTSNodeOp", "sequence: " + this.m_id + ", block: " + this.m_blkid);
            pLogger.starttimer();
        }
        instAtts.put("name", localName);
        XTSNodeOpFactory nodeOpFactory = XTSNodeOpFactory.getInstance();
        IXTSNodeOpInstruction nodeOpInst = (IXTSNodeOpInstruction)nodeOpFactory.getInstruction(this.m_env, instAtts, instParams);
        if (this.m_document == null) {
            throw new XTSInstructionException("interpreter.nulldocument");
        }
        nodeOpInst.execute(this.m_env, this.m_document, instAtts, instParams, body);
        if (pLogger != null) {
            pLogger.stoptimer();
            pLogger.log(this.m_env, 1, this.getClass().getName(), "executeNodeOp", "nodeop: " + localName + ", sequence: " + this.m_id + ", block: " + this.m_blkid);
        }
        return null;
    }

    protected IXTSInstructionResult processFaultBlock(String localName, String faultBlockId, String baseDebugDirectory, XTSInstructionException e) throws XTSInstructionException {
        boolean stackdump = false;
        String sDebugEnable = PropertiesManager.getInstance().getProperty("option.debugenable");
        if (sDebugEnable != null && sDebugEnable.equals(DEBUG_TRUE)) {
            stackdump = true;
        }
        Element faultEle = UXTSExceptionUtils.generateFaultXML(e, this.m_env.getLocale(), stackdump);
        return this.processFaultBlock(localName, faultBlockId, baseDebugDirectory, faultEle);
    }

    private IXTSInstructionResult processFaultBlock(String localName, String faultBlockId, String baseDebugDirectory, Element faultEle) throws XTSInstructionException {
        Element XTSFaultElem = faultEle;
        while (faultBlockId != null) {
            XTSBlock faultBlk = this.m_parentBlkOrg.getFaultBlock(faultBlockId);
            if (faultBlk == null) {
                Object[] args = new String[]{faultBlockId};
                throw new XTSInstructionException("interpreter.unexistedfaultid", args);
            }
            Element cloneroot = null;
            cloneroot = this.m_document.getRootElement().createCopy();
            cloneroot.add(XTSFaultElem.createCopy());
            Document faultdoc = DocumentHelper.createDocument((Element)cloneroot);
            StopWatchTimer childTimer = null;
            if ((this.m_env.getMode() & 2) > 0) {
                childTimer = this.m_timer.createChild();
                baseDebugDirectory = baseDebugDirectory + "/fault";
                this.m_timer.pause();
                IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
                if (debuglogger != null) {
                    debuglogger.log(this.m_env, baseDebugDirectory, "input.xml", faultdoc);
                    debuglogger.log(this.m_env, baseDebugDirectory, "source.xml", faultBlk.toString());
                }
                this.m_timer.unpause();
            }
            CharArrayReaderWriter rw = null;
            try {
                rw = new CharArrayReaderWriter(4096);
                faultBlk.process(this.m_env, (Source)new DocumentSource(faultdoc), new StreamResult(rw), baseDebugDirectory, childTimer);
            }
            catch (XTSException e) {
                Object[] args = new Object[]{localName, faultBlockId};
                throw new XTSInstructionException("instruction.processfaultblockfailed", args, e);
            }
            if ((this.m_env.getMode() & 2) > 0) {
                this.m_timer.pause();
                IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
                if (debuglogger != null) {
                    debuglogger.log(this.m_env, baseDebugDirectory, "result.xml", rw.toString());
                }
                this.m_timer.unpause();
            }
            AXTSPoolObject reader = null;
            try {
                reader = XTSSAXReaderPool.getInstance().acquire();
            }
            catch (XTSException e) {
                Object[] args = new Object[]{localName};
                throw new XTSInstructionException("instruction.parsefaultfailed", args, e);
            }
            try {
                XTSFaultElem = ((SAXReader)reader.get()).read(new InputSource(rw.convert())).getRootElement();
            }
            catch (Exception e) {
                Object[] args = new Object[]{localName};
                throw new XTSInstructionException("instruction.parsefaultfailed", args, e);
            }
            finally {
                XTSSAXReaderPool.getInstance().put(reader);
            }
            if (!XTSFaultElem.getName().equals("fault")) break;
            faultBlockId = faultBlk.getFaultBlock();
        }
        if (XTSFaultElem.getName().equals("fault")) {
            throw new XTSFaultException(XTSFaultElem, this.m_env.getLocale());
        }
        return new XTSFaultBlockResult(XTSFaultElem.asXML());
    }

    private void appendFaultBlock(String localName, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        block16: {
            List appendlist;
            Element dummyRootElem;
            String sSelectValue;
            block15: {
                if (body == null) {
                    return;
                }
                sSelectValue = (String)instAtts.get("faultSelect");
                if (sSelectValue == null) {
                    return;
                }
                if (this.m_document == null) {
                    throw new XTSInstructionException("interpreter.nulldocument");
                }
                SequenceReader readerWithFragmentSupport = new SequenceReader(new SequenceReader(new StringReader(DUMMYROOT_ELEMENT_START), body), new StringReader(DUMMYROOT_ELEMENT_END));
                AXTSPoolObject reader = null;
                try {
                    reader = XTSSAXReaderPool.getInstance().acquire();
                }
                catch (XTSException e) {
                    Object[] args = new Object[]{localName};
                    throw new XTSInstructionException("instruction.parsefaultfailed", args, e);
                }
                dummyRootElem = null;
                try {
                    dummyRootElem = ((SAXReader)reader.get()).read(new InputSource(readerWithFragmentSupport)).getRootElement();
                }
                catch (Exception e) {
                    Object[] args = new Object[]{localName};
                    throw new XTSInstructionException("instruction.parsefaultfailed", args, e);
                }
                finally {
                    XTSSAXReaderPool.getInstance().put(reader);
                }
                appendlist = this.m_document.selectNodes(sSelectValue);
                if (appendlist.size() != 1) break block15;
                Object tgtnode = appendlist.get(0);
                if (!(tgtnode instanceof Element)) {
                    Object[] args = new String[]{sSelectValue, localName};
                    throw new XTSInstructionException("nodeoperation.nonelementnode", args);
                }
                Object srcnode = null;
                int size = dummyRootElem.content().size();
                for (int i = 0; i < size; ++i) {
                    srcnode = dummyRootElem.content().remove(0);
                    if (!(srcnode instanceof Node)) continue;
                    ((Node)srcnode).detach();
                    ((Element)tgtnode).add((Node)srcnode);
                }
                break block16;
            }
            if (appendlist.size() <= 1) break block16;
            Object tgtnode = null;
            for (int i = 0; i < appendlist.size(); ++i) {
                tgtnode = appendlist.get(i);
                if (!(tgtnode instanceof Element)) {
                    Object[] args = new String[]{sSelectValue, localName};
                    throw new XTSInstructionException("nodeoperation.nonelementnode", args);
                }
                ((Element)tgtnode).appendContent((Branch)dummyRootElem);
            }
        }
    }

    private IXTSInstructionResult processTestBlock(String localName, String testBlockId, String baseDebugDirectory) throws XTSInstructionException {
        XTSBlock testBlk = this.m_parentBlkOrg.getTestBlock(testBlockId);
        if (testBlk == null) {
            Object[] args = new String[]{testBlockId};
            throw new XTSInstructionException("interpreter.unexistedtestid", args);
        }
        Element cloneroot = null;
        cloneroot = this.m_document.getRootElement().createCopy();
        Document testdoc = DocumentHelper.createDocument((Element)cloneroot);
        CharArrayReaderWriter rw = null;
        try {
            StopWatchTimer childTimer = null;
            if ((this.m_env.getMode() & 2) > 0) {
                childTimer = this.m_timer.createChild();
                baseDebugDirectory = baseDebugDirectory + "/test";
                this.m_timer.pause();
                IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
                if (debuglogger != null) {
                    debuglogger.log(this.m_env, baseDebugDirectory, "input.xml", testdoc);
                    debuglogger.log(this.m_env, baseDebugDirectory, "source.xml", testBlk.toString());
                }
                this.m_timer.unpause();
            }
            rw = new CharArrayReaderWriter(4096);
            testBlk.process(this.m_env, (Source)new DocumentSource(testdoc), new StreamResult(rw), baseDebugDirectory, childTimer);
        }
        catch (XTSException e) {
            Object[] args = new Object[]{localName, testBlockId};
            throw new XTSInstructionException("instruction.processfaultblockfailed", args, e);
        }
        if ((this.m_env.getMode() & 2) > 0) {
            this.m_timer.pause();
            IXTSDebugLog debuglogger = XTSDebugManager.getInstance().getLogger();
            if (debuglogger != null) {
                debuglogger.log(this.m_env, baseDebugDirectory, "result.xml", rw.toString());
            }
            this.m_timer.unpause();
        }
        return new XTSTestBlockResult(rw.convert());
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (namespaceURI.equals("http://developer.cognos.com/schemas/xts/") && m_xtsInstructionSet.contains(localName)) {
            XTSInstructionWrapper newInstruction = null;
            try {
                newInstruction = new XTSInstructionWrapper(this.m_env, this.m_currentWrapper, localName, qName, atts);
            }
            catch (XTSException e) {
                throw new SAXException(e.getMessage());
            }
            if (this.m_currentWrapper != null) {
                this.m_currentWrapper.addInstruction(newInstruction);
            }
            this.m_currentWrapper = newInstruction;
        } else {
            this.m_currentWrapper.startXMLContent(qName, atts, this.m_currentGlobalScopePrefixNSMap, this.m_currentInstScopePrefixNSMap);
            this.m_currentInstScopePrefixNSMap.clear();
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (namespaceURI.equals("http://developer.cognos.com/schemas/xts/") && m_xtsInstructionSet.contains(localName)) {
            if (this.m_currentWrapper.getParent() != null) {
                this.m_currentWrapper = this.m_currentWrapper.getParent();
            }
        } else {
            this.m_currentWrapper.endXMLContent(qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_currentWrapper.addContent(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.m_currentWrapper.addContent(ch, start, length);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.m_currentGlobalScopePrefixNSMap.put(prefix, uri);
        this.m_currentInstScopePrefixNSMap.put(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.m_currentGlobalScopePrefixNSMap.remove(prefix);
        this.m_currentInstScopePrefixNSMap.remove(prefix);
    }

    @Override
    public void comment(char[] ch, int start, int length) {
    }

    @Override
    public void endCDATA() {
        this.m_currentWrapper.addContent(CDATA_END, 0, CDATA_END.length);
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void endEntity(String name) {
    }

    @Override
    public void startCDATA() {
        this.m_currentWrapper.addContent(CDATA_START, 0, CDATA_START.length);
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) {
    }

    @Override
    public void startEntity(String name) {
    }

    static {
        m_xtsInstructionSet.add("sequence");
        m_xtsInstructionSet.add("queryNode");
        m_xtsInstructionSet.add("queryValue");
        m_xtsInstructionSet.add("request");
        m_xtsInstructionSet.add("transform");
        m_xtsInstructionSet.add("function");
        m_xtsInstructionSet.add("param");
        m_xtsInstructionSet.add("output-param");
        XTSFunctionFactory.getInstance().getRecognizedInstructions(m_xtsInstructionSet);
        XTSNodeOpFactory.getInstance().getRecognizedInstructions(m_xtsInstructionSet);
        m_mimeMediaTypeFileExtensionMap = new HashMap();
        m_mimeMediaTypeFileExtensionMap.put("application/pdf", ".pdf");
        m_mimeMediaTypeFileExtensionMap.put("text/xml", ".xml");
        m_mimeMediaTypeFileExtensionMap.put("text/html", ".html");
    }

    private final class XTSInstructionWrapper {
        private static final int WORKING_BUFFER_SIZE = 1024;
        private XTSOutputContext m_instOutputContext = null;
        private StringBuffer m_workingBuf = new StringBuffer(1024);
        private HashMap m_instAtts = new HashMap();
        private HashMap m_instParams = new HashMap();
        private ArrayList m_instContent = new ArrayList();
        private String m_localName = null;
        private String m_qName = null;
        private XTSInstructionWrapper m_parent = null;
        private int m_xmlContentDepth = 0;
        private int m_iChildInstrCount = 0;
        private Reader m_instBodyReader = null;
        private XTSEnvironment m_env = null;
        private ArrayList m_childInstResultList = new ArrayList();

        public XTSInstructionWrapper(XTSEnvironment env, XTSInstructionWrapper parent, String localName, String qName, Attributes atts) throws XTSInstructionException {
            this.m_env = env;
            this.m_parent = parent;
            this.m_localName = localName;
            this.m_qName = qName;
            if (parent != null) {
                if ((this.m_env.getMode() & 2) > 0) {
                    StringBuffer baseDebugDirBuf = new StringBuffer();
                    baseDebugDirBuf.append((String)this.m_parent.getInstAtts().get("baseDebugDir"));
                    baseDebugDirBuf.append(File.separatorChar);
                    baseDebugDirBuf.append(XTSDebugManager.getInstance().generateDirName(this.m_parent.getChildInstrCount(), localName, null));
                    this.m_instAtts.put("baseDebugDir", baseDebugDirBuf.toString());
                }
            } else if ((this.m_env.getMode() & 2) > 0) {
                this.m_instAtts.put("baseDebugDir", XTSSequenceInstruction.this.m_baseDebugDumpDir);
            }
            int attlen = atts.getLength();
            for (int i = 0; i < attlen; ++i) {
                this.m_instAtts.put(atts.getQName(i), xmlutil.xmldecode(atts.getValue(i)));
            }
            try {
                this.m_instOutputContext = new XTSOutputContext(atts);
            }
            catch (XTSException e) {
                Object[] args = new String[]{this.m_localName};
                throw new XTSInstructionException("instruction.createoutputcontextfailed", args, e);
            }
        }

        public XTSOutputContext getOutputContext() {
            return this.m_instOutputContext;
        }

        public int getChildInstrCount() {
            return this.m_iChildInstrCount;
        }

        public XTSInstructionWrapper getParent() {
            return this.m_parent;
        }

        public String getLocalName() {
            return this.m_localName;
        }

        public String getQName() {
            return this.m_qName;
        }

        public Map getInstAtts() {
            return this.m_instAtts;
        }

        public Map getInstParams() {
            return this.m_instParams;
        }

        public Reader getInstBody() {
            return this.m_instBodyReader;
        }

        public List getChildInstResultList() {
            return this.m_childInstResultList;
        }

        public String toString() {
            Map.Entry pair;
            Iterator it;
            StringBuffer strBuf = new StringBuffer();
            strBuf.append('<');
            strBuf.append(this.m_qName);
            strBuf.append(' ');
            strBuf.append(XMLNS);
            strBuf.append(':');
            strBuf.append("xts");
            strBuf.append('=');
            strBuf.append('\"');
            strBuf.append("http://developer.cognos.com/schemas/xts/");
            strBuf.append('\"');
            if (!this.m_instAtts.isEmpty()) {
                it = this.m_instAtts.entrySet().iterator();
                pair = null;
                while (it.hasNext()) {
                    pair = it.next();
                    strBuf.append(' ');
                    strBuf.append((String)pair.getKey());
                    strBuf.append('=');
                    strBuf.append('\"');
                    xmlutil.xmlencode((String)pair.getValue(), strBuf);
                    strBuf.append('\"');
                }
            }
            strBuf.append('>');
            if (!this.m_instParams.isEmpty()) {
                it = this.m_instParams.entrySet().iterator();
                pair = null;
                while (it.hasNext()) {
                    pair = it.next();
                    String[] values = (String[])pair.getValue();
                    for (int i = 0; i < values.length; ++i) {
                        strBuf.append('<');
                        strBuf.append("xts");
                        strBuf.append(':');
                        strBuf.append("param");
                        strBuf.append(' ');
                        strBuf.append("name");
                        strBuf.append('=');
                        strBuf.append('\"');
                        xmlutil.xmlencode((String)pair.getKey(), strBuf);
                        strBuf.append('\"');
                        strBuf.append('>');
                        xmlutil.xmlencode(values[i], strBuf);
                        strBuf.append(CLOSE_BRACKET_START);
                        strBuf.append("xts");
                        strBuf.append(':');
                        strBuf.append("param");
                        strBuf.append('>');
                    }
                }
            }
            if (this.m_instBodyReader != null) {
                StringBuffer resultBuf = new StringBuffer(4096);
                char[] buf = new char[4096];
                try {
                    int bytesRead = this.m_instBodyReader.read(buf, 0, 4096);
                    while (bytesRead != -1) {
                        resultBuf.append(buf, 0, bytesRead);
                        bytesRead = this.m_instBodyReader.read(buf, 0, 4096);
                    }
                    strBuf.append(resultBuf.toString());
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
                this.m_instBodyReader = new StringReader(resultBuf.toString());
            } else {
                int contentSize = this.m_instContent.size();
                Object contentObj = null;
                for (int i = 0; i < contentSize; ++i) {
                    contentObj = this.m_instContent.get(i);
                    if (contentObj instanceof XTSInstructionWrapper) {
                        strBuf.append(((XTSInstructionWrapper)contentObj).toString());
                        continue;
                    }
                    Reader reader = contentObj;
                    StringBuffer resultBuf = new StringBuffer(4096);
                    char[] buf = new char[4096];
                    try {
                        int bytesRead = reader.read(buf, 0, 4096);
                        while (bytesRead != -1) {
                            resultBuf.append(buf, 0, bytesRead);
                            bytesRead = reader.read(buf, 0, 4096);
                        }
                        strBuf.append(resultBuf.toString());
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                    }
                    this.m_instContent.set(i, new StringReader(resultBuf.toString()));
                }
            }
            strBuf.append(CLOSE_BRACKET_START);
            strBuf.append(this.m_qName);
            strBuf.append('>');
            return strBuf.toString();
        }

        public IXTSInstructionResult execute(XTSSequenceInstruction parentInst) throws XTSInstructionException {
            if (this.m_workingBuf.length() > 0) {
                this.m_instContent.add(new StringReader(this.m_workingBuf.toString()));
            }
            IXTSInstructionResult result = null;
            try {
                int contentSize = this.m_instContent.size();
                for (int i = 0; i < contentSize; ++i) {
                    Object contentObj = this.m_instContent.get(i);
                    Reader childResultReader = null;
                    if (contentObj instanceof XTSInstructionWrapper) {
                        IXTSInstructionResult childResult = ((XTSInstructionWrapper)contentObj).execute(parentInst);
                        List grandChildResultList = ((XTSInstructionWrapper)contentObj).getChildInstResultList();
                        if (grandChildResultList != null && grandChildResultList.size() > 0) {
                            this.m_childInstResultList.addAll(grandChildResultList);
                        }
                        if (childResult != null) {
                            this.m_childInstResultList.add(childResult);
                            try {
                                block27: {
                                    XTSSource instrResultSource = childResult.getResult();
                                    try {
                                        childResultReader = instrResultSource.getReader();
                                        if (childResultReader != null) break block27;
                                        String charset = instrResultSource.getEncoding();
                                        if (charset != null) {
                                            try {
                                                childResultReader = new InputStreamReader(instrResultSource.getInputStream(), charset);
                                            }
                                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                                // empty catch block
                                            }
                                        }
                                        try {
                                            if (childResultReader == null) {
                                                childResultReader = new InputStreamReader(instrResultSource.getInputStream(), XTSSequenceInstruction.ENCODING);
                                            }
                                        }
                                        catch (Exception e) {
                                            Object[] args = new String[]{((XTSInstructionWrapper)contentObj).getQName()};
                                            throw new XTSInstructionException("instruction.convertinputstreamtoreaderfailed", args, e);
                                        }
                                    }
                                    catch (XTSInstructionException e1) {
                                        String faultBlockId = (String)this.m_instAtts.get("faultBlock");
                                        if (faultBlockId == null) {
                                            throw e1;
                                        }
                                        XTSSource faultResultSource = parentInst.processFaultBlock(this.m_localName, faultBlockId, (String)this.m_instAtts.get("baseDebugDir"), e1).getResult();
                                        childResultReader = faultResultSource.getReader();
                                        if (childResultReader != null) break block27;
                                        try {
                                            childResultReader = XMLInputStreamToReader.convert(faultResultSource.getInputStream());
                                        }
                                        catch (Exception e) {
                                            Object[] args = new String[]{((XTSInstructionWrapper)contentObj).getQName()};
                                            throw new XTSInstructionException("instruction.convertxmlinputstreamtoreaderfailed", args, e);
                                        }
                                    }
                                }
                                childResultReader = xmlutil.removeXMLProlog(childResultReader);
                            }
                            catch (IOException iOException) {}
                        }
                    } else {
                        childResultReader = (Reader)contentObj;
                    }
                    if (this.m_instBodyReader == null) {
                        this.m_instBodyReader = childResultReader;
                        continue;
                    }
                    if (childResultReader == null) continue;
                    this.m_instBodyReader = new SequenceReader(this.m_instBodyReader, childResultReader);
                }
                this.m_instContent.clear();
                result = parentInst.executeXTSInstruction(this);
                if (!(result instanceof IXTSFilterInstructionResult)) {
                    int size = this.m_childInstResultList.size();
                    for (int j = 0; j < size; ++j) {
                        IXTSInstructionResult instResult = (IXTSInstructionResult)this.m_childInstResultList.get(j);
                        instResult.release();
                    }
                    this.m_childInstResultList.clear();
                }
            }
            catch (XTSInstructionException e) {
                int size = this.m_childInstResultList.size();
                for (int j = 0; j < size; ++j) {
                    IXTSInstructionResult instResult = (IXTSInstructionResult)this.m_childInstResultList.get(j);
                    instResult.release();
                }
                this.m_childInstResultList.clear();
                throw e;
            }
            catch (Throwable e) {
                int size = this.m_childInstResultList.size();
                for (int j = 0; j < size; ++j) {
                    IXTSInstructionResult instResult = (IXTSInstructionResult)this.m_childInstResultList.get(j);
                    instResult.release();
                }
                this.m_childInstResultList.clear();
                Object[] args = new String[]{this.m_localName};
                throw new XTSInstructionException("instruction.executefailed", args, e);
            }
            return result;
        }

        public void addParameter(String name, String value) {
            name = xmlutil.xmldecode(name);
            value = xmlutil.xmldecode(value);
            String[] values = (String[])this.m_instParams.get(name);
            if (values == null) {
                values = new String[]{value};
            } else {
                String[] newValues = new String[values.length + 1];
                System.arraycopy(values, 0, newValues, 0, values.length);
                newValues[values.length] = value;
                values = newValues;
            }
            this.m_instParams.put(name, values);
        }

        public void addContent(char[] ch, int start, int length) {
            if (this.m_workingBuf.length() > 0) {
                this.m_workingBuf.append(ch, start, length);
            } else if (new String(ch, start, length).trim().length() > 0) {
                this.m_workingBuf.append(ch, start, length);
            }
        }

        public void startXMLContent(String qName, Attributes atts, Map globalNamespaceDecl, Map localNamespaceDecl) {
            Map namespaceDecl = null;
            namespaceDecl = ++this.m_xmlContentDepth == 1 ? globalNamespaceDecl : localNamespaceDecl;
            this.m_workingBuf.append('<');
            this.m_workingBuf.append(qName);
            int attlen = atts.getLength();
            for (int i = 0; i < attlen; ++i) {
                if (atts.getQName(i).startsWith("xmlns")) continue;
                this.m_workingBuf.append(' ');
                this.m_workingBuf.append(atts.getQName(i));
                this.m_workingBuf.append('=');
                this.m_workingBuf.append('\"');
                xmlutil.xmlencode2(atts.getValue(i), this.m_workingBuf);
                this.m_workingBuf.append('\"');
            }
            if (!namespaceDecl.isEmpty()) {
                Iterator it = namespaceDecl.entrySet().iterator();
                Map.Entry pair = null;
                String prefix = null;
                while (it.hasNext()) {
                    pair = it.next();
                    this.m_workingBuf.append(' ');
                    this.m_workingBuf.append(XMLNS);
                    prefix = (String)pair.getKey();
                    if (prefix.length() > 0) {
                        this.m_workingBuf.append(':');
                        this.m_workingBuf.append((String)pair.getKey());
                    }
                    this.m_workingBuf.append('=');
                    this.m_workingBuf.append('\"');
                    this.m_workingBuf.append((String)pair.getValue());
                    this.m_workingBuf.append('\"');
                }
            }
            this.m_workingBuf.append('>');
        }

        public void endXMLContent(String qName) {
            --this.m_xmlContentDepth;
            this.m_workingBuf.append(CLOSE_BRACKET_START);
            this.m_workingBuf.append(qName);
            this.m_workingBuf.append('>');
        }

        public void addInstruction(XTSInstructionWrapper inst) {
            if (this.m_workingBuf.length() > 0) {
                this.m_instContent.add(new StringReader(this.m_workingBuf.toString()));
                this.m_workingBuf = new StringBuffer(1024);
            }
            this.m_instContent.add(inst);
            ++this.m_iChildInstrCount;
        }
    }
}

