/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class XTSSource {
    Reader m_reader = null;
    InputStream m_stream = null;
    String m_encoding = null;
    private static final Map encodingMap = Collections.synchronizedMap(new HashMap());
    private static final String ENCODING_UTF_8 = "UTF-8";
    private static final String ENCODING_ISO_8859_1 = "ISO-8859-1";
    private static final String ENCODING_ASCII = "ASCII";
    private static final String ENCODING_UCS_2_12 = "UTF-16BE";
    private static final String ENCODING_UCS_2_21 = "UTF-16LE";
    private static final String ENCODING_UCS_4_1234 = "UTF-32BE";
    private static final String ENCODING_UCS_4_4321 = "UTF-32LE";
    private static final String ENCODING_UCS_4_2143 = "ISO-10646-UCS-4";
    private static final String ENCODING_UCS_4_3412 = "ISO-10646-UCS-4";
    private static final String ENCODING_PARM = "encoding=";

    public XTSSource(InputStream stream) {
        this.m_stream = !stream.markSupported() ? new BufferedInputStream(stream) : stream;
    }

    public XTSSource(InputStream stream, String encoding) {
        this(stream);
        this.m_encoding = encoding;
    }

    public XTSSource(Reader reader) {
        this.m_reader = reader;
    }

    public Reader getReader() {
        return this.m_reader;
    }

    public InputStream getInputStream() {
        return this.m_stream;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    private int[] getHeader() throws IOException {
        if (this.m_stream == null) {
            return null;
        }
        int[] header = new int[4];
        this.m_stream.mark(4);
        header[0] = this.m_stream.read();
        header[1] = this.m_stream.read();
        header[2] = this.m_stream.read();
        header[3] = this.m_stream.read();
        this.m_stream.reset();
        return header;
    }

    public String detectEncoding() {
        try {
            int[] header = this.getHeader();
            long headerNumber = this.longFromHeader(header);
            this.m_encoding = (String)encodingMap.get(new Long(headerNumber));
            if (this.m_encoding == null) {
                this.m_encoding = ENCODING_UTF_8;
            }
            this.updateStream(headerNumber);
            return this.m_encoding;
        }
        catch (IOException exc) {
            this.m_encoding = null;
            return this.m_encoding;
        }
    }

    private void updateStream(long header) throws IOException {
        if (header == 65534L || header == 65279L) {
            this.m_stream.read();
            this.m_stream.read();
        } else if (header == 1836597052L) {
            this.read8bitEncodingDeclaration();
        } else if (header == 0xBFBBEFL) {
            this.m_stream.read();
            this.m_stream.read();
            this.m_stream.read();
        }
    }

    private long longFromHeader(int[] header) {
        long result = 0L;
        result |= (long)header[0];
        result |= (long)(header[1] << 8);
        if (!this.hasBOM(header) && (result |= (long)(header[2] << 16)) != 0xBFBBEFL) {
            result |= (long)(header[3] << 24);
        }
        return result;
    }

    private boolean hasBOM(int[] header) {
        if (header[0] == 255 && header[1] == 254) {
            return true;
        }
        return header[1] == 255 && header[0] == 254;
    }

    private void read8bitEncodingDeclaration() throws IOException {
        if (this.m_stream != null && this.m_encoding == ENCODING_UTF_8) {
            try {
                boolean readBufferPos = false;
                int readBufferLength = 0;
                int maxbuffer = 100;
                char[] readBuffer = new char[maxbuffer];
                boolean done = false;
                boolean error = false;
                this.m_stream.mark(maxbuffer + 1);
                while (!done && readBufferLength <= maxbuffer) {
                    int ch = this.m_stream.read();
                    readBuffer[readBufferLength++] = (char)ch;
                    switch (ch) {
                        case 62: {
                            done = true;
                            break;
                        }
                        case -1: {
                            done = true;
                            error = true;
                        }
                    }
                }
                this.m_stream.reset();
                if (!error && readBufferLength < maxbuffer) {
                    String sBuf = new String(readBuffer);
                    int encparm_pos = sBuf.indexOf(ENCODING_PARM);
                    if (encparm_pos == -1) {
                        return;
                    }
                    int nextCharPosition = encparm_pos + ENCODING_PARM.length();
                    if (nextCharPosition >= sBuf.length()) {
                        return;
                    }
                    char nextChar = sBuf.charAt(nextCharPosition);
                    if (nextChar != '\"' && nextChar != '\'') {
                        return;
                    }
                    int start_pos = encparm_pos + ENCODING_PARM.length() + 1;
                    int end_pos = sBuf.indexOf(nextChar, start_pos);
                    if (end_pos == -1) {
                        return;
                    }
                    String encodingName = sBuf.substring(start_pos, end_pos);
                    this.m_encoding = (encodingName = encodingName.toUpperCase()).equals(ENCODING_ISO_8859_1) || encodingName.equals("8859_1") || encodingName.equals("ISO8859_1") ? ENCODING_ISO_8859_1 : (encodingName.equals("US-ASCII") || encodingName.equals(ENCODING_ASCII) ? ENCODING_ASCII : encodingName);
                }
            }
            catch (IOException exc) {
                this.m_encoding = ENCODING_UTF_8;
                return;
            }
        }
    }

    static {
        encodingMap.put(new Long(0x3C000000L), ENCODING_UCS_4_1234);
        encodingMap.put(new Long(60L), ENCODING_UCS_4_4321);
        encodingMap.put(new Long(0x3C0000L), "ISO-10646-UCS-4");
        encodingMap.put(new Long(15360L), "ISO-10646-UCS-4");
        encodingMap.put(new Long(65534L), ENCODING_UCS_2_12);
        encodingMap.put(new Long(65279L), ENCODING_UCS_2_21);
        encodingMap.put(new Long(1056979968L), ENCODING_UCS_2_12);
        encodingMap.put(new Long(4128828L), ENCODING_UCS_2_21);
        encodingMap.put(new Long(1836597052L), ENCODING_UTF_8);
        encodingMap.put(new Long(0xBFBBEFL), ENCODING_UTF_8);
    }
}

