/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions;

import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.XTSSource;
import com.cognos.xts.util.CharArrayReaderWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;

public final class XTSTestBlockResult
implements IXTSInstructionResult {
    private Reader m_reader = null;

    public XTSTestBlockResult(Reader reader) throws XTSInstructionException {
        this.m_reader = reader;
    }

    @Override
    public XTSSource getResult() {
        return new XTSSource(this.m_reader);
    }

    @Override
    public void release() throws XTSInstructionException {
        try {
            if (this.m_reader != null) {
                this.m_reader.close();
                this.m_reader = null;
            }
        }
        catch (IOException e) {
            throw new XTSInstructionException("protocol.ioexception", e);
        }
    }

    @Override
    public void writeCopyTo(OutputStream out) throws XTSInstructionException {
        try {
            CharArrayReaderWriter rw = new CharArrayReaderWriter();
            char[] buf = new char[4096];
            int bytesRead = this.m_reader.read(buf, 0, 4096);
            while (bytesRead != -1) {
                rw.write(buf, 0, bytesRead);
                bytesRead = this.m_reader.read(buf, 0, 4096);
            }
            rw.flush();
            out.write(new String(rw.toCharArray()).getBytes("UTF-8"));
            this.m_reader = rw.convert();
        }
        catch (IOException e) {
            Object[] args = new String[]{this.getClass().getName()};
            throw new XTSInstructionException("instruction.writetooutputstreamfailed", args, e);
        }
    }
}

