/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.function;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.configuration.XTSConfigManager;
import com.cognos.xts.configuration.XTSConfigurationException;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.function.IXTSFunctionInstruction;
import com.cognos.xts.interpreter.instructions.function.XTSFunctionResult;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.util.LocaleUtils;
import java.util.Map;

public class XTSGetConfigurationProperty
extends AXTSInstruction
implements IXTSFunctionInstruction {
    private static final int BUFFER_SIZE = 256;
    private boolean m_bInitialized = false;
    private String m_sIdentifier = null;
    private static final String CONFIGURATION = "configuration";
    private static final String PROPERTY = "property";

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
        this.m_bInitialized = true;
    }

    @Override
    public void terminate() throws XTSInstructionException {
        this.m_bInitialized = false;
    }

    @Override
    public boolean isInitialized() {
        return this.m_bInitialized;
    }

    @Override
    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams) throws XTSInstructionException {
        if (!this.m_bInitialized) {
            return null;
        }
        StringBuffer configXML = new StringBuffer(256);
        configXML.append("<");
        configXML.append(CONFIGURATION);
        configXML.append(">");
        for (Map.Entry pair : instParams.entrySet()) {
            String paramName = (String)pair.getKey();
            String localelist = null;
            String propertyValue = null;
            String[] valueList = (String[])pair.getValue();
            if (valueList != null) {
                localelist = valueList[0];
            }
            try {
                if (paramName.equals("productLocales")) {
                    propertyValue = XTSConfigManager.getInstance().getProductLocalesProperty(LocaleUtils.parseHttpLocaleList(localelist, false));
                    configXML.append(propertyValue);
                    continue;
                }
                if (paramName.equals("contentLocales")) {
                    propertyValue = XTSConfigManager.getInstance().getContentLocalesProperty(LocaleUtils.parseHttpLocaleList(localelist, false));
                    configXML.append(propertyValue);
                    continue;
                }
                if (paramName.equals("timeZones")) {
                    propertyValue = XTSConfigManager.getInstance().getTimeZonesProperty(LocaleUtils.parseHttpLocaleList(localelist, false));
                    configXML.append(propertyValue);
                    continue;
                }
                if (paramName.equals("currencies")) {
                    propertyValue = XTSConfigManager.getInstance().getCurrenciesProperty(LocaleUtils.parseHttpLocaleList(localelist, false));
                    configXML.append(propertyValue);
                    continue;
                }
                if (paramName.equals("fonts")) {
                    propertyValue = XTSConfigManager.getInstance().getFontsProperty(LocaleUtils.parseHttpLocaleList(localelist, false));
                    configXML.append(propertyValue);
                    continue;
                }
                if (paramName.equals("installedComponents") || paramName.equals("installedComponentsPerDispatcher")) {
                    propertyValue = PropertiesManager.getInstance().getProperty(paramName);
                    configXML.append(propertyValue);
                    continue;
                }
                propertyValue = PropertiesManager.getInstance().getProperty(paramName);
                if (propertyValue == null) {
                    propertyValue = "";
                }
                configXML.append("<");
                configXML.append(PROPERTY);
                configXML.append(" name=\"");
                configXML.append(paramName);
                configXML.append("\">");
                configXML.append(propertyValue);
                configXML.append("</");
                configXML.append(PROPERTY);
                configXML.append(">");
            }
            catch (XTSConfigurationException e) {
                configXML.append("<");
                configXML.append(PROPERTY);
                configXML.append(" name=\"");
                configXML.append(paramName);
                configXML.append("\">");
                configXML.append("</");
                configXML.append(PROPERTY);
                configXML.append(">");
            }
        }
        configXML.append("</");
        configXML.append(CONFIGURATION);
        configXML.append(">");
        return new XTSFunctionResult(configXML.toString());
    }
}

