/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.function;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.function.IXTSFunctionInstruction;
import com.cognos.xts.interpreter.instructions.function.XTSFunctionResult;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSPerfLoggerManager;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.util.TDSStorageHelper;
import java.util.List;
import java.util.Map;

public final class XTSTDSRequestFunction
extends AXTSInstruction
implements IXTSFunctionInstruction {
    private boolean m_bInitialized = false;
    private String m_sIdentifier = null;
    private TDSStorageHelper tdsHelpeWithError;
    private static String PARAM_NAME_ACTION = "action";
    private static String PARAM_NAME_ACTION_SET = "set";
    private static String PARAM_NAME_ACTION_GET = "get";
    private static String PARAM_NAME_ACTION_DELETE = "delete";
    private static String PARAM_NAME_ACTION_DELETE_MATCHTYPE = "match-type";
    private static String PARAM_NAME_ACTION_DELETE_MATCHTYPE_STARTSWITH = TDSStorageHelper.MATCHTYPE_STARTSWITH;
    private static String PARAM_NAME_SESSION_ID = "session-id";
    private static String PARAM_NAME_MAP_ID = "map-id";
    private static String PARAM_NAME_NAME = "name";
    private static String PARAM_NAME_SOURCE = "source";
    private static String PARAM_NAME_COMPONENT_ID = "component-id";
    private static String PARAM_NAME_REPORT_ERRORS = "report-errors";

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
        this.tdsHelpeWithError = TDSStorageHelper.createInstance(true);
        this.m_bInitialized = true;
    }

    @Override
    public void terminate() throws XTSInstructionException {
        this.m_bInitialized = false;
    }

    @Override
    public boolean isInitialized() {
        return this.m_bInitialized;
    }

    @Override
    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams) throws XTSInstructionException {
        IXTSLogger traceLogger = null;
        IXTSLogger perfLogger = null;
        try {
            if (!this.m_bInitialized) {
                Object[] args = new String[]{this.m_sIdentifier};
                throw new XTSInstructionException("instruction.executefailed", args);
            }
            if (XTSTraceLoggerManager.getInstance().isEnabled[4][0] && (traceLogger = XTSTraceLoggerManager.getInstance().getLogger(4, 0)) != null) {
                traceLogger.log(env, 4, "TDS Request", null, null);
            }
            String action = UXTSInstructionUtils.getParameter(PARAM_NAME_ACTION, instParams);
            String componentId = UXTSInstructionUtils.getParameter(PARAM_NAME_COMPONENT_ID, instParams);
            String sessionId = UXTSInstructionUtils.getParameter(PARAM_NAME_SESSION_ID, instParams);
            String name = UXTSInstructionUtils.getParameter(PARAM_NAME_NAME, instParams);
            String mapId = UXTSInstructionUtils.getParameter(PARAM_NAME_MAP_ID, instParams);
            boolean isReportErrors = "true".equalsIgnoreCase(UXTSInstructionUtils.getParameter(PARAM_NAME_REPORT_ERRORS, instParams));
            if (action == null || "".equals(action)) {
                Object[] args = new String[]{PARAM_NAME_ACTION, this.m_sIdentifier};
                throw new XTSInstructionException("function.emptyparameter", args);
            }
            if (name == null || "".equals(name)) {
                Object[] args = new String[]{PARAM_NAME_NAME, this.m_sIdentifier};
                throw new XTSInstructionException("function.emptyparameter", args);
            }
            if (sessionId == null || "".equals(sessionId)) {
                Object[] args = new String[]{PARAM_NAME_SESSION_ID, this.m_sIdentifier};
                throw new XTSInstructionException("function.emptyparameter", args);
            }
            if (componentId == null || "".equals(componentId)) {
                componentId = "PS";
            }
            if (XTSPerfLoggerManager.getInstance().isEnabled[4][0] && (perfLogger = XTSPerfLoggerManager.getInstance().getLogger(4, 0)) != null) {
                perfLogger.log(env, 6, this.getClass().getName(), "TDS", "TDS Request action=" + action);
                perfLogger.starttimer();
            }
            String result = "";
            TDSStorageHelper tdsInstance = isReportErrors ? this.tdsHelpeWithError : TDSStorageHelper.instance;
            if (PARAM_NAME_ACTION_SET.equals(action) || action.startsWith(PARAM_NAME_ACTION_SET)) {
                String source = UXTSInstructionUtils.getParameter(PARAM_NAME_SOURCE, instParams);
                if (source == null) {
                    Object[] args = new String[]{PARAM_NAME_SOURCE, this.m_sIdentifier};
                    throw new XTSInstructionException("function.emptyparameter", args);
                }
                if (mapId != null) {
                    tdsInstance.putMappedValue(componentId, sessionId, mapId, name, source);
                } else {
                    tdsInstance.putValue(componentId, sessionId, name, source);
                }
            } else if (PARAM_NAME_ACTION_GET.equals(action) || action.startsWith(PARAM_NAME_ACTION_GET)) {
                result = mapId != null ? tdsInstance.getMappedValue(componentId, sessionId, mapId, name) : tdsInstance.getValue(componentId, sessionId, name);
                if (result == null) {
                    result = "";
                }
            } else if (PARAM_NAME_ACTION_DELETE.equals(action) || action.startsWith(PARAM_NAME_ACTION_DELETE)) {
                String matchType = UXTSInstructionUtils.getParameter(PARAM_NAME_ACTION_DELETE_MATCHTYPE, instParams);
                if (matchType != null && !PARAM_NAME_ACTION_DELETE_MATCHTYPE_STARTSWITH.equals(matchType)) {
                    Object[] args = new String[]{PARAM_NAME_ACTION_DELETE_MATCHTYPE, this.m_sIdentifier};
                    throw new XTSInstructionException("function.unrecognizedparameter", args);
                }
                if (mapId != null) {
                    if (matchType == null) {
                        tdsInstance.removeMappedValue(componentId, sessionId, mapId, name);
                    } else {
                        List<String> names = tdsInstance.getMappedNamesForSession(componentId, sessionId, mapId, name, matchType);
                        for (String k : names) {
                            tdsInstance.removeMappedValue(componentId, sessionId, mapId, k);
                        }
                    }
                } else {
                    tdsInstance.removeValue(componentId, sessionId, name);
                }
            } else {
                Object[] args = new String[]{PARAM_NAME_ACTION, this.m_sIdentifier};
                throw new XTSInstructionException("function.unrecognizedparameter", args);
            }
            if (perfLogger != null) {
                perfLogger.stoptimer();
                perfLogger.log(env, 1, this.getClass().getName(), "TDS", "TDS Request action=" + action);
            }
            XTSFunctionResult xTSFunctionResult = new XTSFunctionResult(result);
            return xTSFunctionResult;
        }
        catch (XTSInstructionException e) {
            throw e;
        }
        catch (Exception e) {
            Object[] args = new String[]{this.m_sIdentifier};
            throw new XTSInstructionException("instruction.executefailed", args, e);
        }
        finally {
            if (traceLogger != null) {
                traceLogger.log(env, 5, "TDS Request", null, null);
            }
        }
    }
}

