/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.function;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.ext.XTSExt;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.function.IXTSFunctionInstruction;
import com.cognos.xts.interpreter.instructions.function.XTSFunctionResult;
import java.util.Map;

public final class XTSWeb64DecodeFunction
extends AXTSInstruction
implements IXTSFunctionInstruction {
    private static final String PARAM_NAME_SOURCE = "source";
    private static final String PARAM_NAME_DECOMPRESS = "decompress";
    private boolean m_bInitialized = false;
    private String m_sIdentifier = null;

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
        this.m_bInitialized = true;
    }

    @Override
    public void terminate() throws XTSInstructionException {
        this.m_bInitialized = false;
    }

    @Override
    public boolean isInitialized() {
        return this.m_bInitialized;
    }

    @Override
    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams) throws XTSInstructionException {
        if (!this.m_bInitialized) {
            return null;
        }
        String source = UXTSInstructionUtils.getParameter(PARAM_NAME_SOURCE, instParams);
        if (source == null || source.length() == 0) {
            Object[] args = new String[]{PARAM_NAME_SOURCE, this.m_sIdentifier};
            throw new XTSInstructionException("function.emptyparameter", args);
        }
        boolean bDecompress = false;
        String decompress = UXTSInstructionUtils.getParameter(PARAM_NAME_DECOMPRESS, instParams);
        if (decompress != null && decompress.equalsIgnoreCase(Boolean.TRUE.toString())) {
            bDecompress = true;
        }
        return new XTSFunctionResult(XTSExt.web64decode(source, bDecompress));
    }
}

