/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.nodeop;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXReaderPool;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.nodeop.IXTSNodeOpInstruction;
import com.cognos.xts.interpreter.instructions.nodeop.XTSNodeOpHelpers;
import com.cognos.xts.util.SequenceReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public final class XTSAppend
extends AXTSInstruction
implements IXTSNodeOpInstruction {
    private static final String DUMMYROOT_ELEMENT_START = "<dummyroot>";
    private static final String DUMMYROOT_ELEMENT_END = "</dummyroot>";
    private String m_sIdentifier = null;

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
    }

    @Override
    public void terminate() throws XTSInstructionException {
    }

    @Override
    public boolean isInitialized() {
        return this.m_sIdentifier != null;
    }

    @Override
    public void execute(XTSEnvironment env, Document inputDoc, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        if (body == null) {
            return;
        }
        String sSelectValue = (String)instAtts.get("select");
        SequenceReader readerWithFragmentSupport = new SequenceReader(new SequenceReader(new StringReader(DUMMYROOT_ELEMENT_START), body), new StringReader(DUMMYROOT_ELEMENT_END));
        AXTSPoolObject reader = null;
        try {
            reader = XTSSAXReaderPool.getInstance().acquire();
        }
        catch (XTSException e) {
            Object[] args = new Object[]{this.m_sIdentifier};
            throw new XTSInstructionException("nodeoperation.parsefailed", args, e);
        }
        Element dummyRootElem = null;
        try {
            dummyRootElem = ((SAXReader)reader.get()).read(new InputSource(readerWithFragmentSupport)).getRootElement();
        }
        catch (Exception e) {
            Object[] args = new Object[]{this.m_sIdentifier};
            throw new XTSInstructionException("nodeoperation.parsefailed", args, e);
        }
        finally {
            XTSSAXReaderPool.getInstance().put(reader);
        }
        if (sSelectValue == null) {
            inputDoc.getRootElement().appendContent((Branch)dummyRootElem);
        } else {
            if (!XTSNodeOpHelpers.validateSelectXpath(sSelectValue)) {
                Object[] args = new String[]{sSelectValue, this.m_sIdentifier};
                throw new XTSInstructionException("nodeoperation.invalidnode", args);
            }
            List appendlist = inputDoc.selectNodes(sSelectValue);
            if (appendlist.size() == 0) {
                String sMandatory = (String)instAtts.get("mandatory");
                if (sMandatory != null && sMandatory.equals("true")) {
                    Object[] args = new String[]{sSelectValue, this.m_sIdentifier};
                    throw new XTSInstructionException("nodeoperation.mandatoryfailed", args);
                }
            } else if (appendlist.size() == 1) {
                Object tgtnode = appendlist.get(0);
                if (!(tgtnode instanceof Element)) {
                    Object[] args = new String[]{sSelectValue, this.m_sIdentifier};
                    throw new XTSInstructionException("nodeoperation.nonelementnode", args);
                }
                Object srcnode = null;
                int size = dummyRootElem.content().size();
                for (int i = 0; i < size; ++i) {
                    srcnode = dummyRootElem.content().remove(0);
                    if (!(srcnode instanceof Node)) continue;
                    ((Node)srcnode).detach();
                    ((Element)tgtnode).add((Node)srcnode);
                }
            } else {
                Object tgtnode = null;
                for (int i = 0; i < appendlist.size(); ++i) {
                    tgtnode = appendlist.get(i);
                    if (!(tgtnode instanceof Element)) {
                        Object[] args = new String[]{sSelectValue, this.m_sIdentifier};
                        throw new XTSInstructionException("nodeoperation.nonelementnode", args);
                    }
                    ((Element)tgtnode).appendContent((Branch)dummyRootElem);
                }
            }
        }
    }
}

