/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.nodeop;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.interpreter.instructions.AXTSInstructionFactory;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.properties.PropertiesManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class XTSNodeOpFactory
extends AXTSInstructionFactory {
    private static final String PROPERTY_PREFIX = "nodeop.class.";
    private static final String CACHE_SIZE_PROPERTY_NAME = "nodeop.cache.size";
    private static XTSNodeOpFactory m_factory = new XTSNodeOpFactory();
    private HashSet m_supportedOpsSet = new HashSet();

    @Override
    public final void initialize() throws XTSException {
        super.initialize();
        HashMap supportedOpsMap = PropertiesManager.getInstance().getPropertiesMap(PROPERTY_PREFIX);
        Map.Entry pair2 = null;
        for (Map.Entry pair2 : supportedOpsMap.entrySet()) {
            this.m_supportedOpsSet.add(((String)pair2.getKey()).substring(PROPERTY_PREFIX.length()));
        }
    }

    @Override
    public final void terminate() throws XTSException {
        super.terminate();
        this.m_supportedOpsSet.clear();
    }

    @Override
    protected String getPropertyPrefix() {
        return PROPERTY_PREFIX;
    }

    @Override
    protected String generateHashKey(XTSEnvironment env, Map instAtts, Map instParams) {
        return (String)instAtts.get("name");
    }

    public static XTSNodeOpFactory getInstance() {
        return m_factory;
    }

    public boolean isXTSNodeOpInstruction(String instName) {
        return this.m_supportedOpsSet.contains(instName);
    }

    public void getRecognizedInstructions(Set instSet) {
        Iterator it = this.m_supportedOpsSet.iterator();
        while (it.hasNext()) {
            instSet.add(it.next());
        }
    }

    @Override
    protected int getCacheSize() {
        int cacheSize;
        block3: {
            cacheSize = 0;
            String sCacheSize = PropertiesManager.getInstance().getProperty(CACHE_SIZE_PROPERTY_NAME);
            if (sCacheSize != null) {
                try {
                    cacheSize = Integer.parseInt(sCacheSize);
                }
                catch (NumberFormatException e) {
                    cacheSize = super.getCacheSize();
                    if (!XTSTraceLoggerManager.getInstance().isEnabled[3][0]) break block3;
                    StringBuffer msg = new StringBuffer();
                    msg.append("Default cache size used for node operation factory...\n");
                    msg.append("  Reason: ").append(e.getMessage()).append("\n");
                    IXTSLogger logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0);
                    if (logger == null) break block3;
                    logger.log(null, 8, msg.toString(), null, null);
                }
            }
        }
        return cacheSize;
    }
}

