/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.nodeop;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXReaderPool;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.nodeop.IXTSNodeOpInstruction;
import com.cognos.xts.interpreter.instructions.nodeop.XTSNodeOpHelpers;
import com.cognos.xts.util.SequenceReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public final class XTSReplace
extends AXTSInstruction
implements IXTSNodeOpInstruction {
    private static final String DUMMYROOT_ELEMENT_START = "<dummyroot>";
    private static final String DUMMYROOT_ELEMENT_END = "</dummyroot>";
    private String m_sIdentifier = null;

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
    }

    @Override
    public void terminate() throws XTSInstructionException {
    }

    @Override
    public boolean isInitialized() {
        return this.m_sIdentifier != null;
    }

    @Override
    public void execute(XTSEnvironment env, Document inputDoc, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        if (body == null) {
            return;
        }
        String sSelectValue = (String)instAtts.get("select");
        if (sSelectValue == null) {
            Object[] args = new String[]{this.m_sIdentifier};
            throw new XTSInstructionException("nodeoperation.missingselection", args);
        }
        if (!XTSNodeOpHelpers.validateSelectXpath(sSelectValue)) {
            Object[] args = new String[]{sSelectValue, this.m_sIdentifier};
            throw new XTSInstructionException("nodeoperation.invalidnode", args);
        }
        List tgtlist = inputDoc.selectNodes(sSelectValue);
        if (tgtlist.size() == 0) {
            String sMandatory = (String)instAtts.get("mandatory");
            if (sMandatory != null && sMandatory.equals("true")) {
                Object[] args = new String[]{sSelectValue, this.m_sIdentifier};
                throw new XTSInstructionException("nodeoperation.mandatoryfailed", args);
            }
        } else {
            SequenceReader readerWithFragmentSupport = new SequenceReader(new SequenceReader(new StringReader(DUMMYROOT_ELEMENT_START), body), new StringReader(DUMMYROOT_ELEMENT_END));
            AXTSPoolObject reader = null;
            try {
                reader = XTSSAXReaderPool.getInstance().acquire();
            }
            catch (XTSException e) {
                Object[] args = new Object[]{this.m_sIdentifier};
                throw new XTSInstructionException("nodeoperation.parsefailed", args, e);
            }
            Element dummyRootElem = null;
            try {
                dummyRootElem = ((SAXReader)reader.get()).read(new InputSource(readerWithFragmentSupport)).getRootElement();
            }
            catch (Exception e) {
                Object[] args = new Object[]{this.m_sIdentifier};
                throw new XTSInstructionException("nodeoperation.parsefailed", args, e);
            }
            finally {
                XTSSAXReaderPool.getInstance().put(reader);
            }
            if (tgtlist.size() == 1) {
                Object obj = tgtlist.get(0);
                if (!(obj instanceof Node)) {
                    Object[] args = new String[]{sSelectValue, this.m_sIdentifier};
                    throw new XTSInstructionException("nodeoperation.invalidnode", args);
                }
                Node tgtnode = (Node)obj;
                Element tgtparent = tgtnode.getParent();
                int srcsize = dummyRootElem.content().size();
                if (tgtparent != null) {
                    int index = tgtparent.indexOf(tgtnode);
                    Object srcnode = null;
                    for (int i = 0; i < srcsize; ++i) {
                        srcnode = dummyRootElem.content().remove(0);
                        if (!(srcnode instanceof Node)) continue;
                        ((Node)srcnode).detach();
                        tgtparent.content().add(index++, srcnode);
                    }
                    tgtnode.detach();
                } else {
                    if (srcsize > 1) {
                        Object[] args = new String[]{sSelectValue, this.m_sIdentifier};
                        throw new XTSInstructionException("nodeoperation.multiplerootcreation", args);
                    }
                    Node srcnode = dummyRootElem.node(0);
                    if (!(srcnode instanceof Element)) {
                        Object[] args = new String[]{sSelectValue, this.m_sIdentifier};
                        throw new XTSInstructionException("nodeoperation.invalidnode", args);
                    }
                    srcnode.detach();
                    inputDoc.setRootElement((Element)srcnode);
                }
            } else {
                List srclist = dummyRootElem.content();
                Object obj = null;
                Node tgtnode = null;
                Element tgtparent = null;
                Node srcnode = null;
                Element newroot = null;
                int index = 0;
                for (int i = 0; i < tgtlist.size(); ++i) {
                    obj = tgtlist.get(i);
                    if (!(obj instanceof Node)) {
                        Object[] args = new String[]{sSelectValue, this.m_sIdentifier};
                        throw new XTSInstructionException("nodeoperation.invalidnode", args);
                    }
                    tgtnode = obj;
                    tgtparent = tgtnode.getParent();
                    if (tgtparent != null) {
                        index = tgtparent.indexOf(tgtnode);
                        for (int j = 0; j < srclist.size(); ++j) {
                            srcnode = (Node)((Node)srclist.get(j)).clone();
                            srcnode.detach();
                            tgtparent.content().add(index++, srcnode);
                        }
                        tgtnode.detach();
                        continue;
                    }
                    if (srclist.size() > 1) {
                        Object[] args = new String[]{sSelectValue, this.m_sIdentifier};
                        throw new XTSInstructionException("nodeoperation.multiplerootcreation", args);
                    }
                    srcnode = (Node)srclist.get(0);
                    if (!(srcnode instanceof Element)) {
                        Object[] args = new String[]{sSelectValue, this.m_sIdentifier};
                        throw new XTSInstructionException("nodeoperation.invalidnode", args);
                    }
                    newroot = ((Element)srcnode).createCopy();
                    inputDoc.setRootElement(newroot);
                }
            }
        }
    }
}

