/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.request;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.interpreter.instructions.IXTSOutputableInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.XTSSource;
import com.cognos.xts.interpreter.instructions.request.SOAPSAXContentHandler;
import com.cognos.xts.interpreter.instructions.request.XTSSoapFaultException;
import com.cognos.xts.util.ByteArrayIOStream;
import com.cognos.xts.util.MultipartMimeInputStream;
import com.cognos.xts.util.message;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.ParseException;

public abstract class AXTSSoapResult
implements IXTSOutputableInstructionResult {
    private static final String MULTIPART = "multipart";
    private static final String BOUNDARY = "boundary";
    private static final int BUFFER_SIZE = 4096;
    private static final String XML_BASE_CONTENT_TYPE = "text/xml; charset=utf-8";
    private ContentType m_contentType = null;
    private Reader m_soapEnvReader = null;
    private InputStream m_soapAttIn = null;
    private boolean m_bConnected = false;

    protected void process(XTSEnvironment env, boolean includeEnvelope, InputStream in, String contentType) throws XTSInstructionException, XTSSoapFaultException {
        InputStream soapEnvIn;
        ContentType ct;
        block28: {
            ct = null;
            if (contentType != null) {
                try {
                    ct = new ContentType(contentType);
                }
                catch (ParseException e) {
                    Object[] args = new Object[]{contentType};
                    throw new XTSInstructionException("soap.invalidcontenttype", args, e);
                }
            }
            soapEnvIn = null;
            try {
                if (ct != null && ct.getPrimaryType().equalsIgnoreCase(MULTIPART)) {
                    String boundary = ct.getParameter(BOUNDARY);
                    String boundary_start = "--" + boundary;
                    String boundary_end = boundary_start + "--";
                    String line = message.getFirstNonWhiteSpaceLine(in);
                    if (line == null) {
                        throw new XTSInstructionException("soap.endofstream");
                    }
                    if (!line.equals(boundary_start)) {
                        throw new XTSInstructionException("soap.invalidboundary");
                    }
                    InternetHeaders hd = null;
                    try {
                        hd = new InternetHeaders(in);
                    }
                    catch (MessagingException e) {
                        throw new XTSInstructionException("soap.invalidmimeheaders", e);
                    }
                    String bodySize = hd.getHeader("Content-Length", null);
                    byte[] buf = null;
                    if (bodySize != null) {
                        int size = Integer.parseInt(bodySize);
                        buf = new byte[size];
                        in.read(buf, 0, size);
                        soapEnvIn = new ByteArrayInputStream(buf);
                        do {
                            if ((buf = message.readLine(in)) == null) {
                                throw new XTSInstructionException("soap.endofstream");
                            }
                            line = new String(buf, "UTF-8");
                        } while (!(line = line.trim()).equals(boundary_start) && !line.equals(boundary_end));
                    } else {
                        ByteArrayIOStream out = new ByteArrayIOStream(4096);
                        while (true) {
                            if ((buf = message.readLine(in)) == null) {
                                throw new XTSInstructionException("soap.endofstream");
                            }
                            line = new String(buf, "UTF-8");
                            if ((line = line.trim()).equals(boundary_start) || line.equals(boundary_end)) break;
                            out.write(buf);
                        }
                        soapEnvIn = out.convert();
                    }
                    if (!line.equals(boundary_end)) {
                        this.m_soapAttIn = in;
                    } else {
                        in.close();
                    }
                    break block28;
                }
                if (ct != null && ct.getPrimaryType().equalsIgnoreCase("text") && ct.getSubType().equalsIgnoreCase("html")) {
                    int b;
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    while ((b = in.read()) != -1) {
                        bos.write(b);
                    }
                    Exception e = new Exception(bos.toString());
                    throw new XTSInstructionException("soap.expectxmlresponse", e);
                }
                soapEnvIn = in;
            }
            catch (IOException e) {
                throw new XTSInstructionException("protocol.bibusrequestfailed", e);
            }
        }
        SOAPSAXContentHandler soapParser = new SOAPSAXContentHandler(env, includeEnvelope, false);
        this.m_soapEnvReader = soapParser.processEnvelope(soapEnvIn);
        if (this.m_soapAttIn == null || soapParser.hasSoapFault()) {
            this.disconnect();
        } else if (this.m_soapAttIn != null) {
            this.m_bConnected = true;
            try {
                this.m_soapAttIn = new MultipartMimeInputStream(this.m_soapAttIn, ct.getParameter(BOUNDARY), true);
            }
            catch (UnsupportedEncodingException e) {
                Object[] args = new String[]{"soap"};
                throw new XTSInstructionException("protocol.unsupportedencodingexception", args, e);
            }
            catch (IOException e) {
                throw new XTSInstructionException("protocol.ioexception", e);
            }
        } else {
            this.m_bConnected = true;
        }
        if (soapParser.hasSoapFault()) {
            Reader hdrReader = soapParser.getSoapHeader();
            throw new XTSSoapFaultException("request.soapfault", this.m_soapEnvReader, hdrReader, soapParser.getSoapVersion(), includeEnvelope);
        }
    }

    protected abstract void disconnect();

    @Override
    public XTSSource getResult() {
        return new XTSSource(this.m_soapEnvReader);
    }

    @Override
    public void release() throws XTSInstructionException {
        if (this.m_bConnected) {
            this.disconnect();
            this.m_bConnected = false;
        }
        try {
            if (this.m_soapEnvReader != null) {
                this.m_soapEnvReader.close();
                this.m_soapEnvReader = null;
            }
            if (this.m_soapAttIn != null) {
                this.m_soapAttIn.close();
                this.m_soapAttIn = null;
            }
        }
        catch (IOException e) {
            throw new XTSInstructionException("protocol.ioexception", e);
        }
    }

    @Override
    public void writeCopyTo(OutputStream out) throws XTSInstructionException {
        try {
            ByteArrayIOStream bio = new ByteArrayIOStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)bio, "UTF-8"));
            char[] buf = new char[4096];
            int bytesRead = this.m_soapEnvReader.read(buf, 0, 4096);
            while (bytesRead != -1) {
                ((Writer)writer).write(buf, 0, bytesRead);
                bytesRead = this.m_soapEnvReader.read(buf, 0, 4096);
            }
            ((Writer)writer).flush();
            bio.writeTo(out);
            this.m_soapEnvReader = new BufferedReader(new InputStreamReader((InputStream)bio.convert(), "UTF-8"));
        }
        catch (IOException e) {
            Object[] args = new String[]{this.getClass().getName()};
            throw new XTSInstructionException("instruction.writetooutputstreamfailed", args, e);
        }
    }

    @Override
    public boolean attachmentsSupported() {
        return true;
    }

    @Override
    public int getSupportedOptionsBitMap() {
        return 31;
    }

    @Override
    public boolean statusHeaderSupported() {
        return false;
    }

    @Override
    public boolean protocolHeaderSupported() {
        return true;
    }

    @Override
    public InputStream getAttachmentInputStream() throws XTSInstructionException {
        return this.m_soapAttIn;
    }

    @Override
    public InternetHeaders getStatusHeaders() throws XTSInstructionException {
        return null;
    }

    @Override
    public abstract InternetHeaders getProtocolHeaders() throws XTSInstructionException;

    @Override
    public ContentType getDefaultMimeType() throws XTSInstructionException {
        if (this.m_contentType == null) {
            try {
                this.m_contentType = new ContentType(XML_BASE_CONTENT_TYPE);
            }
            catch (ParseException e) {
                Object[] args = new Object[]{XML_BASE_CONTENT_TYPE};
                throw new XTSInstructionException("protocol.invalidcontenttype", args, e);
            }
        }
        return this.m_contentType;
    }
}

