/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.request;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.common.cache.XTSCacheException;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.request.IXTSRequestInstruction;
import com.cognos.xts.interpreter.instructions.request.XTSUrlResult;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.security.IXTSCacheSecurity;
import com.cognos.xts.security.XTSSecurityException;
import com.cognos.xts.security.XTSSecurityFactory;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;

public abstract class AXTSUrlRequest
extends AXTSInstruction
implements IXTSRequestInstruction {
    private static final String HEADER_IDENTIFIER = "header";
    private static final String SIZELIMIT_IDENTIFIER = "sizeLimit";
    private static final String TIMEOUT_IDENTIFIER = "timeout";
    private static final String INTERNAL_REQUEST_IDENTIFIER = "internalRequest";
    private static final String USE_PROXY_IDENTIFIER = "useProxy";
    private String m_sIdentifier = null;
    private static final String CONNECTION_TIMEOUT = "urlrequest.connectiontimeout";
    private static final String SOCKET_TIMEOUT = "urlrequest.sockettimeout";
    private static final int DEFAULT_CONNECTIONTIMEOUT = 240000;
    private static final int DEFAULT_SOCKETTIMEOUT = 240000;
    private int m_iConnectionTimeout = 240000;
    private int m_iSocketTimeout = 240000;
    private int m_timeoutValue = -1;

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
        this.m_iConnectionTimeout = 240000;
        String sConnectionTimeout = PropertiesManager.getInstance().getProperty(CONNECTION_TIMEOUT);
        if (sConnectionTimeout != null) {
            try {
                this.m_iConnectionTimeout = Integer.parseInt(sConnectionTimeout);
            }
            catch (NumberFormatException e) {
                this.m_iConnectionTimeout = 240000;
            }
        }
        this.m_iSocketTimeout = 240000;
        String sSocketTimeout = PropertiesManager.getInstance().getProperty(SOCKET_TIMEOUT);
        if (sSocketTimeout != null) {
            try {
                this.m_iSocketTimeout = Integer.parseInt(sSocketTimeout);
            }
            catch (NumberFormatException e) {
                this.m_iSocketTimeout = 240000;
            }
        }
    }

    @Override
    public void terminate() throws XTSInstructionException {
    }

    @Override
    public boolean isInitialized() {
        return this.m_sIdentifier != null;
    }

    @Override
    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        StringBuffer urlPrefix = new StringBuffer(256);
        StringBuffer params = new StringBuffer(2048);
        String target = (String)instAtts.get("target");
        if (target == null || target.length() == 0) {
            throw new XTSInstructionException("protocol.missingtarget");
        }
        try {
            URL url = new URL(target);
            String query = url.getQuery();
            if (query != null && query.length() > 0) {
                params.append(query);
            }
            urlPrefix.append(url.getProtocol());
            urlPrefix.append("://");
            urlPrefix.append(url.getHost());
            if (url.getPort() != -1) {
                urlPrefix.append(":");
                urlPrefix.append(url.getPort());
            }
            urlPrefix.append(url.getPath());
        }
        catch (MalformedURLException e) {
            Object[] args = new String[]{target};
            throw new XTSInstructionException("protocol.malformedtarget", args, e);
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        String name = null;
        String[] values = null;
        Map.Entry pair2 = null;
        String headerValue = null;
        long sizeLimitValue = 0L;
        boolean isInternalRequest = false;
        boolean useProxy = false;
        for (Map.Entry pair2 : instParams.entrySet()) {
            name = (String)pair2.getKey();
            values = (String[])pair2.getValue();
            if (name.equals(HEADER_IDENTIFIER)) {
                if (values == null) continue;
                for (int i = 0; i < values.length; ++i) {
                    headerValue = values[i];
                    int equalpos = headerValue.indexOf("=");
                    if (equalpos == -1) {
                        Object[] args = new String[]{this.getIdentifier()};
                        throw new XTSInstructionException("protocol.url.invalidheadersyntax", args);
                    }
                    headerMap.put(headerValue.substring(0, equalpos), headerValue.substring(equalpos + 1));
                }
                continue;
            }
            if (name.equals(SIZELIMIT_IDENTIFIER)) {
                sizeLimitValue = Long.parseLong(values[0]);
                continue;
            }
            if (name.equals(TIMEOUT_IDENTIFIER)) {
                this.m_timeoutValue = Integer.parseInt(values[0]);
                continue;
            }
            if (name.equals(INTERNAL_REQUEST_IDENTIFIER)) {
                if (values == null || values[0] == null || !values[0].equals("true")) continue;
                isInternalRequest = true;
                continue;
            }
            if (!name.equals(USE_PROXY_IDENTIFIER) || values == null || values[0] == null || !values[0].equals("true")) continue;
            useProxy = true;
        }
        HttpMethod connMethod = this.submitURL(env, urlPrefix.toString(), params.toString(), headerMap, body, isInternalRequest, useProxy);
        return new XTSUrlResult(env, connMethod, sizeLimitValue);
    }

    protected HttpMethod submitURL(XTSEnvironment env, String prefix, String query, Map headerMap, Reader body, boolean isInternalRequest, boolean useProxy) throws XTSInstructionException {
        String urlStr = this.prepareUrl(prefix, query);
        try {
            HttpMethod connMethod;
            URL url = new URL(urlStr);
            HttpClient client = null;
            if (isInternalRequest) {
                client = this.getInternalClient(url);
                connMethod = this.createConnectionMethod(null, url.getFile());
            } else {
                String proxyHost;
                client = new HttpClient();
                if (useProxy && (proxyHost = System.getProperty("http.proxyHost")) != null) {
                    HostConfiguration config = client.getHostConfiguration();
                    int proxyPort = Integer.parseInt(System.getProperty("http.proxyPort", "80"));
                    config.setProxy(proxyHost, proxyPort);
                    if (System.getProperty("http.proxyUserName") != null) {
                        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(System.getProperty("http.proxyUserName"), System.getProperty("http.proxyPassword"));
                        AuthScope authScope = new AuthScope(proxyHost, proxyPort);
                        client.getState().setProxyCredentials(authScope, (Credentials)credentials);
                    }
                }
                connMethod = this.createConnectionMethod(url.toString(), null);
            }
            this.initClient(client, connMethod, url, headerMap);
            this.prepareConnectionMethod(connMethod, query, headerMap, body);
            client.executeMethod(connMethod);
            return connMethod;
        }
        catch (MalformedURLException e) {
            Object[] args = new String[]{urlStr};
            throw new XTSInstructionException("protocol.malformedurl", args);
        }
        catch (ProtocolException e) {
            throw new XTSInstructionException("protocol.urlsubmiterror", e);
        }
        catch (HttpException e) {
            throw new XTSInstructionException("protocol.urlsubmiterror", e);
        }
        catch (IOException e) {
            throw new XTSInstructionException("protocol.urlsubmiterror", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpClient getInternalClient(URL url) throws XTSInstructionException {
        HttpClient client;
        block7: {
            client = null;
            try {
                HashMap<String, String> attr = new HashMap<String, String>();
                attr.put("name", "cognos.cam");
                IXTSCacheSecurity security = (IXTSCacheSecurity)((Object)XTSSecurityFactory.getInstance().getObject(null, attr));
                if (security == null) {
                    client = new HttpClient();
                    HostConfiguration hc = new HostConfiguration();
                    hc.setHost(url.getHost(), url.getPort(), url.getProtocol());
                    client.setHostConfiguration(hc);
                    break block7;
                }
                try {
                    client = security.getHttpClient(null, url.getHost(), url.getPort(), url.getProtocol().equals("https"), null);
                }
                finally {
                    security.release();
                }
            }
            catch (XTSSecurityException e) {
                throw new XTSInstructionException("protocol.urlsubmiterror", e);
            }
            catch (XTSCacheException e) {
                throw new XTSInstructionException("protocol.urlsubmiterror", e);
            }
        }
        return client;
    }

    protected void initClient(HttpClient client, HttpMethod connMethod, URL url, Map headerMap) throws HttpException {
        client.setStrictMode(true);
        client.setConnectionTimeout(this.m_timeoutValue < 0 ? this.m_iConnectionTimeout : this.m_timeoutValue);
        client.setTimeout(this.m_timeoutValue < 0 ? this.m_iSocketTimeout : this.m_timeoutValue);
        HttpState state = client.getState();
        boolean cookieParm = false;
        Map.Entry pair2 = null;
        for (Map.Entry pair2 : headerMap.entrySet()) {
            if (pair2.getKey().toString().equalsIgnoreCase("Cookie")) {
                cookieParm = true;
                String host = url.getHost();
                String path = url.getPath();
                boolean secure = url.getProtocol().equals("https");
                HeaderElement[] hdrElements = HeaderElement.parse((String)((String)pair2.getValue()));
                for (int i = 0; i < hdrElements.length; ++i) {
                    state.addCookie(new Cookie(host, hdrElements[i].getName(), hdrElements[i].getValue(), path, -1, secure));
                    NameValuePair[] valuePairs = hdrElements[i].getParameters();
                    if (valuePairs == null) continue;
                    for (int j = 0; j < valuePairs.length; ++j) {
                        state.addCookie(new Cookie(host, valuePairs[j].getName(), valuePairs[j].getValue(), path, -1, secure));
                    }
                }
                continue;
            }
            connMethod.addRequestHeader((String)pair2.getKey(), (String)pair2.getValue());
        }
        if (cookieParm) {
            client.setState(state);
        }
    }

    protected static String getMimeType(String contentType) {
        int semipos;
        if (null != contentType && (semipos = contentType.indexOf(59)) != -1) {
            return contentType.substring(0, semipos);
        }
        return contentType;
    }

    protected static String getCharset(String contentType) {
        int pos;
        if (null != contentType && (pos = contentType.indexOf("charset=")) != -1) {
            int semipos = contentType.indexOf(59, pos += "charset=".length());
            if (semipos != -1) {
                return contentType.substring(pos, semipos);
            }
            return contentType.substring(pos);
        }
        return "UTF-8";
    }

    protected abstract String prepareUrl(String var1, String var2);

    protected abstract HttpMethod createConnectionMethod(String var1, String var2);

    protected abstract void prepareConnectionMethod(HttpMethod var1, String var2, Map var3, Reader var4) throws XTSInstructionException;
}

