/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.request;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXParserPool;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.messages.MessagesManager;
import com.cognos.xts.util.soaputil;
import com.cognos.xts.util.xmlutil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

final class SOAPSAXContentHandler
extends DefaultHandler
implements LexicalHandler {
    private static final String ENCODING = "UTF-8";
    public static final String NAMESPACE_FEATURE = "http://xml.org/sax/features/namespaces";
    public static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private static final String LEXICALHANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private static final char ENTITYREF_START = '&';
    private static final char ENTITYREF_END = ';';
    private static final char OPEN_BRACKET_START = '<';
    private static final char OPEN_BRACKET_END = '>';
    private static final char[] CLOSE_BRACKET_START = new char[]{'<', '/'};
    private static final char CLOSE_BRACKET_END = '>';
    private static final char[] PROCESSING_INSTRUCTION_START = new char[]{'<', '?'};
    private static final char[] PROCESSING_INSTRUCTION_END = new char[]{'?', '>'};
    private static final char[] XMLNS = new char[]{'x', 'm', 'l', 'n', 's'};
    private static final char EQUALS = '=';
    private static final char QUOTE = '\"';
    private static final char SPACE = ' ';
    private static final char COLON = ':';
    private static final int SOAP_ENVELOPE = 0;
    private static final int SOAP_HEADER = 1;
    private static final int SOAP_BODY = 2;
    private String m_currentEntity = null;
    private boolean m_bcData = false;
    private boolean m_bIncludeEnvelope = false;
    private boolean m_bSeparateSoapHeader = false;
    private int m_iSoapVersion = -1;
    private int m_iCurrentContextElement = 0;
    private XTSEnvironment m_env = null;
    private boolean m_bSoapFault = false;
    private int m_iSoapBodyElementDepth = 0;
    private int m_iSoapHeaderElementDepth = 0;
    private HashMap m_workingPrefixNSMap = new HashMap();
    private HashMap m_globalScopePrefixNSMap = new HashMap();
    StringBuffer m_resultBodyBuf = null;
    StringBuffer m_resultHeaderBuf = null;
    StringBuffer m_currentBuf = null;

    private SOAPSAXContentHandler() {
    }

    public SOAPSAXContentHandler(XTSEnvironment env, boolean includeEnvelope, boolean separateSoapHeader) {
        this.m_env = env;
        this.m_bIncludeEnvelope = includeEnvelope;
        this.m_bSeparateSoapHeader = separateSoapHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader processEnvelope(InputStream soapEnvIn) throws XTSInstructionException {
        this.m_resultBodyBuf = new StringBuffer();
        try {
            AXTSPoolObject parser = XTSSAXParserPool.getInstance().acquire();
            try {
                XMLReader reader = ((SAXParser)parser.get()).getXMLReader();
                reader.setContentHandler(this);
                reader.setProperty(LEXICALHANDLER_PROPERTY, this);
                reader.parse(new InputSource(soapEnvIn));
            }
            finally {
                XTSSAXParserPool.getInstance().put(parser);
            }
        }
        catch (SAXException e) {
            if (!this.m_bSoapFault) {
                throw new XTSInstructionException("soap.documentparseerror", e);
            }
            if (XTSTraceLoggerManager.getInstance().isEnabled[2][0]) {
                StringBuffer msg = new StringBuffer();
                msg.append("Soap fault encountered...\n");
                msg.append("  fault: ").append(this.m_resultBodyBuf.toString()).append("\n");
                IXTSLogger logger = XTSTraceLoggerManager.getInstance().getLogger(2, 0);
                if (logger != null) {
                    logger.log(this.m_env, 8, msg.toString(), null, null);
                }
            }
        }
        catch (IOException e) {
            throw new XTSInstructionException("soap.documentparseerror", e);
        }
        catch (XTSException e) {
            throw new XTSInstructionException("soap.documentparseerror", e);
        }
        return new StringReader(this.m_resultBodyBuf.toString());
    }

    public Reader getSoapHeader() {
        if (this.m_resultHeaderBuf == null) {
            return null;
        }
        return new StringReader(this.m_resultHeaderBuf.toString());
    }

    public int getSoapVersion() {
        return this.m_iSoapVersion;
    }

    public boolean hasSoapFault() {
        return this.m_bSoapFault;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.m_workingPrefixNSMap.put(prefix, uri);
        this.m_globalScopePrefixNSMap.put(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.m_workingPrefixNSMap.remove(prefix);
        this.m_globalScopePrefixNSMap.remove(prefix);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.m_currentBuf != null) {
            if (this.m_bcData) {
                xmlutil.xmlencode(new String(ch, start, length), this.m_currentBuf);
            } else if (this.m_currentEntity != null) {
                this.m_currentBuf.append(xmlutil.outEntityReference(this.m_currentEntity, ch, start, length));
            } else {
                this.m_currentBuf.append(ch, start, length);
            }
        }
        this.m_currentEntity = null;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        if (this.m_currentBuf != null) {
            this.m_currentBuf.append(ch, start, length);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.m_currentEntity = null;
        switch (this.m_iCurrentContextElement) {
            case 0: {
                if (localName.equals("Header")) {
                    this.m_iCurrentContextElement = 1;
                    if (!this.m_bSeparateSoapHeader && !this.m_bIncludeEnvelope) break;
                    this.m_currentBuf = this.m_resultHeaderBuf = new StringBuffer();
                    SOAPSAXContentHandler.writeElementStart(this.m_currentBuf, qName, atts, this.m_workingPrefixNSMap);
                    break;
                }
                if (localName.equals("Body")) {
                    this.m_iCurrentContextElement = 2;
                    this.m_currentBuf = this.m_resultBodyBuf;
                    if (this.m_bIncludeEnvelope) {
                        SOAPSAXContentHandler.writeElementStart(this.m_currentBuf, qName, atts, this.m_workingPrefixNSMap);
                        break;
                    }
                    Iterator it = this.m_globalScopePrefixNSMap.entrySet().iterator();
                    Map.Entry pair = null;
                    while (it.hasNext()) {
                        pair = it.next();
                        this.m_workingPrefixNSMap.put((String)pair.getKey(), (String)pair.getValue());
                    }
                    break;
                }
                if (localName.equals("Envelope")) {
                    this.m_iSoapVersion = soaputil.getSOAPVersion(namespaceURI);
                    if (this.m_iSoapVersion == -1) {
                        throw new SAXException(MessagesManager.getInstance().getMessage(this.m_env.getLocale(), "soap.invalidenvelope"));
                    }
                    if (!this.m_bIncludeEnvelope) break;
                    this.m_currentBuf = this.m_resultBodyBuf;
                    SOAPSAXContentHandler.writeElementStart(this.m_currentBuf, qName, atts, this.m_workingPrefixNSMap);
                    break;
                }
                throw new SAXException(MessagesManager.getInstance().getMessage(this.m_env.getLocale(), "soap.invalidenvelope"));
            }
            case 1: {
                ++this.m_iSoapHeaderElementDepth;
                if (this.m_bSeparateSoapHeader || this.m_bIncludeEnvelope) {
                    SOAPSAXContentHandler.writeElementStart(this.m_currentBuf, qName, atts, this.m_workingPrefixNSMap);
                }
                this.m_workingPrefixNSMap.clear();
                break;
            }
            case 2: {
                ++this.m_iSoapBodyElementDepth;
                if (this.m_iSoapBodyElementDepth == 1 && namespaceURI.equals(soaputil.getSOAPNamespaceURI(this.m_iSoapVersion)) && localName.equals("Fault")) {
                    this.m_currentBuf = this.m_resultBodyBuf = new StringBuffer();
                    this.m_workingPrefixNSMap.clear();
                    if (!this.m_globalScopePrefixNSMap.isEmpty()) {
                        for (Map.Entry pair : this.m_globalScopePrefixNSMap.entrySet()) {
                            this.m_workingPrefixNSMap.put((String)pair.getKey(), (String)pair.getValue());
                        }
                    }
                }
                SOAPSAXContentHandler.writeElementStart(this.m_currentBuf, qName, atts, this.m_workingPrefixNSMap);
                this.m_workingPrefixNSMap.clear();
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        switch (this.m_iCurrentContextElement) {
            case 1: {
                if (this.m_bSeparateSoapHeader || this.m_bIncludeEnvelope) {
                    SOAPSAXContentHandler.writeElementEnd(this.m_currentBuf, qName);
                }
                if (this.m_iSoapHeaderElementDepth == 0 && localName.equals("Header")) {
                    this.m_iCurrentContextElement = 0;
                    this.m_currentBuf = null;
                    if (this.m_bIncludeEnvelope) {
                        this.m_resultBodyBuf.append(this.m_resultHeaderBuf.toString());
                    }
                }
                --this.m_iSoapHeaderElementDepth;
                break;
            }
            case 2: {
                switch (this.m_iSoapBodyElementDepth) {
                    case 0: {
                        if (localName.equals("Body")) {
                            this.m_iCurrentContextElement = 0;
                        }
                        if (this.m_bIncludeEnvelope) {
                            SOAPSAXContentHandler.writeElementEnd(this.m_currentBuf, qName);
                        }
                        this.m_currentBuf = null;
                        break;
                    }
                    case 1: {
                        if (namespaceURI.equals(soaputil.getSOAPNamespaceURI(this.m_iSoapVersion)) && localName.equals("Fault")) {
                            this.m_bSoapFault = true;
                            SOAPSAXContentHandler.writeElementEnd(this.m_currentBuf, qName);
                            throw new SAXException(MessagesManager.getInstance().getMessage(this.m_env.getLocale(), "soap.soapfault"));
                        }
                        SOAPSAXContentHandler.writeElementEnd(this.m_currentBuf, qName);
                        break;
                    }
                    default: {
                        SOAPSAXContentHandler.writeElementEnd(this.m_currentBuf, qName);
                    }
                }
                --this.m_iSoapBodyElementDepth;
                break;
            }
            case 0: {
                if (!this.m_bIncludeEnvelope) break;
                SOAPSAXContentHandler.writeElementEnd(this.m_resultBodyBuf, qName);
            }
        }
    }

    @Override
    public void processingInstruction(String target, String data) {
        if (this.m_currentBuf != null) {
            this.m_currentBuf.append(PROCESSING_INSTRUCTION_START);
            this.m_currentBuf.append(target);
            this.m_currentBuf.append(' ');
            this.m_currentBuf.append(data);
            this.m_currentBuf.append(PROCESSING_INSTRUCTION_END);
        }
    }

    private static void writeElementStart(StringBuffer buf, String qName, Attributes atts, Map namespaceDecl) {
        buf.append('<');
        buf.append(qName);
        int attlen = atts.getLength();
        for (int i = 0; i < attlen; ++i) {
            buf.append(' ');
            buf.append(atts.getQName(i));
            buf.append('=');
            buf.append('\"');
            xmlutil.xmlencode(atts.getValue(i), buf);
            buf.append('\"');
        }
        if (!namespaceDecl.isEmpty()) {
            Iterator it = namespaceDecl.entrySet().iterator();
            String prefix = null;
            Map.Entry pair = null;
            while (it.hasNext()) {
                pair = it.next();
                buf.append(' ');
                buf.append(XMLNS);
                prefix = (String)pair.getKey();
                if (prefix.length() > 0) {
                    buf.append(':');
                    buf.append((String)pair.getKey());
                }
                buf.append('=');
                buf.append('\"');
                buf.append((String)pair.getValue());
                buf.append('\"');
            }
        }
        buf.append('>');
    }

    private static void writeElementEnd(StringBuffer buf, String qName) {
        buf.append(CLOSE_BRACKET_START);
        buf.append(qName);
        buf.append('>');
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.m_currentEntity = '&' + name + ';';
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        this.m_bcData = true;
    }

    @Override
    public void endCDATA() throws SAXException {
        this.m_bcData = false;
    }

    @Override
    public void comment(char[] ch, int start, int end) throws SAXException {
    }
}

