/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.request;

import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.http.httpclient.MsgBodyGenerator;
import com.cognos.pogo.transport.DispatcherConnectionManager;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.XTSProcessor;
import com.cognos.xts.application.XTSApplicationManager;
import com.cognos.xts.baltic.UXTSBusExceptionUtils;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXReaderPool;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.request.IXTSRequestInstruction;
import com.cognos.xts.interpreter.instructions.request.XTSBusException;
import com.cognos.xts.interpreter.instructions.request.XTSBusResult;
import com.cognos.xts.interpreter.instructions.request.XTSXtsBusResult;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSAuditLoggerManager;
import com.cognos.xts.logging.XTSPerfLoggerManager;
import com.cognos.xts.output.XTSConstants;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.request.XTSBusHelper;
import com.cognos.xts.request.XTSBusRequestUtil;
import com.cognos.xts.util.SequenceReader;
import com.cognos.xts.util.soaputil;
import com.cognos.xts.util.xmlutil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public final class XTSBusRequest
extends AXTSInstruction
implements IXTSRequestInstruction {
    private static final int ENVELOPE_READ_SIZE = 1024;
    private static final String DUMMYROOT_ELEMENT_START = "<dummyroot>";
    private static final String DUMMYROOT_ELEMENT_END = "</dummyroot>";
    private static final String REQUEST_HREF_BIBUS = "bus://";
    private static final String BIBUS_CM = "cm";
    private static final String BIBUS_XTS = "xts";
    private static final String BIBUS_XTS2 = "xts2";
    private static final String BIBUS_DISPATCHER = "dispatcher";
    private static final String ERR_CM = "Content Manager";
    private static final String ERR_DISPATCHER = "Dispatcher";
    private String m_sIdentifier = null;
    private String m_cmURL = null;
    private String m_dispatcherURL = null;

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
        this.m_cmURL = PropertiesManager.getInstance().getProperty("cm.url");
        this.m_dispatcherURL = PropertiesManager.getInstance().getProperty("dispatcher.url");
    }

    @Override
    public void terminate() throws XTSInstructionException {
    }

    @Override
    public boolean isInitialized() {
        return this.m_sIdentifier != null;
    }

    @Override
    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        String target = (String)instAtts.get("target");
        if (target == null || target.length() == 0) {
            throw new XTSInstructionException("protocol.missingtarget");
        }
        boolean includeEnvelope = false;
        String responseEnvelope = UXTSInstructionUtils.getParameter("responseEnvelope", instParams);
        if (responseEnvelope != null && responseEnvelope.equals("true")) {
            includeEnvelope = true;
        }
        if ((target = target.substring(REQUEST_HREF_BIBUS.length())).equals(BIBUS_XTS) || target.startsWith("xts/")) {
            return this.handleXtsRequest(env, target, instAtts, instParams, body, includeEnvelope);
        }
        if (target.startsWith("xts2/")) {
            return this.handleXTS2Request(env, target, instAtts, instParams, body, includeEnvelope);
        }
        return this.handleBusRequest(env, target, instAtts, instParams, body, includeEnvelope);
    }

    public IXTSInstructionResult handleXTS2Request(XTSEnvironment env, String target, Map instAtts, Map instParams, Reader body, boolean includeEnvelope) throws XTSInstructionException {
        Element processingElement;
        Element systemElement;
        target = target.substring(BIBUS_XTS2.length());
        Element root = DocumentHelper.createElement((String)"root");
        Element outputElement = DocumentHelper.createElement((String)"output");
        Element protocolHeaderElement = DocumentHelper.createElement((QName)XTSConstants.ELEM_NM_PROTOCOLHEADER);
        outputElement.add(protocolHeaderElement);
        root.add(outputElement);
        Document inputDoc = DocumentHelper.createDocument((Element)root);
        Element dummyRootElem = null;
        if (body != null) {
            SequenceReader readerWithFragmentSupport = new SequenceReader(new StringReader(DUMMYROOT_ELEMENT_START), body);
            readerWithFragmentSupport = new SequenceReader(readerWithFragmentSupport, new StringReader(DUMMYROOT_ELEMENT_END));
            AXTSPoolObject reader = null;
            try {
                reader = XTSSAXReaderPool.getInstance().acquire();
            }
            catch (XTSException e) {
                Object[] args = new Object[]{this.m_sIdentifier};
                throw new XTSInstructionException("protocol.xts.parsefailed", args, e);
            }
            try {
                dummyRootElem = ((SAXReader)reader.get()).read(new InputSource(readerWithFragmentSupport)).getRootElement();
            }
            catch (Exception e) {
                Object[] args = new Object[]{this.m_sIdentifier};
                throw new XTSInstructionException("protocol.xts.parsefailed", args, e);
            }
            finally {
                XTSSAXReaderPool.getInstance().put(reader);
            }
            root.appendContent((Branch)dummyRootElem);
        }
        if ((systemElement = XTSApplicationManager.getInstance().searchSystemOptions(target)) != null) {
            root.add(systemElement);
        }
        if ((processingElement = XTSApplicationManager.getInstance().searchProcessingOptions(target)) != null) {
            root.add(processingElement);
        }
        XTSEnvironment requestEnv = new XTSEnvironment(env.getCallerID());
        requestEnv.setUserCapabilities(env.getUserCapabilities());
        String lang = XTSBusRequestUtil.getRequestLang(inputDoc);
        Locale locale = XTSBusRequestUtil.getRequestLocale(inputDoc, lang, env.getLocale());
        requestEnv.setLocale(locale);
        requestEnv.setLookupList(XTSBusRequestUtil.getRequestLocaleLookupList(locale, lang != null && lang.length() > 0));
        requestEnv.setMorphletName(target);
        requestEnv.setMode(env.getMode() & 0xFFFFFFFB);
        boolean outputHeader = false;
        String outputHeaderStr = UXTSInstructionUtils.getParameter("outputHeader", instParams);
        if (outputHeaderStr != null && outputHeaderStr.equals("true")) {
            outputHeader = true;
        }
        try {
            XTSProcessor.getInstance(env.getCallerID()).execute(target, inputDoc, requestEnv, true);
        }
        catch (XTSException e) {
            throw this.createBusException(e, requestEnv, 11, inputDoc, outputHeader, includeEnvelope);
        }
        return new XTSXtsBusResult(requestEnv, inputDoc, 11, includeEnvelope, outputHeader);
    }

    private IXTSInstructionResult handleBusRequest(XTSEnvironment env, String target, Map instAtts, Map instParams, Reader body, boolean includeEnvelope) throws XTSInstructionException {
        String soapAction;
        if (XTSAuditLoggerManager.getInstance().isEnabled[3][1]) {
            StringBuffer buf = new StringBuffer();
            try {
                body = UXTSInstructionUtils.copyReader(body, buf);
                IXTSLogger logger = XTSAuditLoggerManager.getInstance().getLogger(3, 1);
                if (logger != null) {
                    logger.log(env, 2, buf.toString(), null, null);
                }
            }
            catch (IOException e) {
                throw new XTSInstructionException("instruction.failedtocopyreader", e);
            }
        }
        if ((soapAction = UXTSInstructionUtils.getParameter("soapAction", instParams)) == null) {
            soapAction = "";
        }
        boolean outputHeader = false;
        String outputHeaderStr = UXTSInstructionUtils.getParameter("outputHeader", instParams);
        if (outputHeaderStr != null && outputHeaderStr.equals("true")) {
            outputHeader = true;
        }
        ServerConnection con = this.sendBusEnvelope(env, body, target, soapAction);
        return new XTSBusResult(env, con, target, includeEnvelope, outputHeader);
    }

    private ServerConnection sendBusEnvelope(XTSEnvironment env, final Reader envelope, String target, String soapAction) throws XTSInstructionException {
        ServerConnection conn = null;
        String url = null;
        if (BIBUS_CM.equals(target)) {
            conn = DispatcherConnectionManager.getContentManagerConnection();
            url = this.m_cmURL;
        } else if (BIBUS_DISPATCHER.equals(target)) {
            conn = DispatcherConnectionManager.getLocalDispatcherConnection();
            url = this.m_dispatcherURL;
        }
        if (conn == null || url == null) {
            Object[] args = new String[]{target};
            throw new XTSInstructionException("protocol.nobusconnection", args);
        }
        try {
            conn.setRequestHeader("SOAPAction", soapAction);
            conn.addRequestHeader("Content-Type", "text/xml; charset=utf-8");
            conn.addRequestHeader("Connection", "Keep-Alive");
            conn.setRequestBodySource(new MsgBodyGenerator(){

                public boolean rewind() {
                    return false;
                }

                public void writeBody(OutputStream os) throws IOException {
                    os.write(xmlutil.m_defaultXMLHeaderByte);
                    os.flush();
                    BufferedWriter bufWriter = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
                    char[] buf = new char[1024];
                    int bytesRead = envelope.read(buf, 0, 1024);
                    while (bytesRead != -1) {
                        bufWriter.write(buf, 0, bytesRead);
                        bytesRead = envelope.read(buf, 0, 1024);
                    }
                    bufWriter.flush();
                }
            });
            IXTSLogger pLogger = null;
            if (XTSPerfLoggerManager.getInstance().isEnabled[1][0] && (pLogger = XTSPerfLoggerManager.getInstance().getLogger(1, 0)) != null) {
                pLogger.log(env, 6, this.getClass().getName(), "sendBusEnvelope", "sub-timer: start connection-execute");
                pLogger.starttimer();
            }
            conn.sendRequest(url);
            if (pLogger != null) {
                pLogger.stoptimer();
                pLogger.log(env, 1, this.getClass().getName(), "sendBusEnvelope", "sub-timer: done connection-execute");
            }
            return conn;
        }
        catch (IOException e) {
            conn.release();
            Object[] argsCM = new String[]{ERR_CM};
            String[] argsDISP = new String[]{ERR_DISPATCHER};
            Object[] args = target.equals(BIBUS_CM) ? argsCM : argsDISP;
            throw new XTSInstructionException("protocol.bus.requestfailed.prod", args, e);
        }
    }

    private XTSBusException createBusException(XTSException e, XTSEnvironment env, int soapVer, Document doc, boolean outputHeader, boolean includeEnvelope) {
        Element busSoapFault;
        Element busFaultHdr;
        Element setSoapHdrEl;
        Element soapHdr;
        List setSoapHdrList;
        Element outputEl;
        StringReader hdrReader = null;
        StringReader faultReader = null;
        if (outputHeader && (outputEl = doc.getRootElement().element("output")) != null && (setSoapHdrList = XTSConstants.getProtocolHeaderParamSetSoapHeaderList(outputEl)).size() > 0 && (soapHdr = (setSoapHdrEl = (Element)setSoapHdrList.get(0)).element("Header")) != null) {
            hdrReader = new StringReader(soapHdr.asXML());
        }
        Element busFaultEnv = UXTSBusExceptionUtils.convertXTSExceptionToBusFault(e, soapVer, env.getLocale());
        if (hdrReader == null && (busFaultHdr = busFaultEnv.element(soaputil.getSOAPHeaderQName(soapVer))) != null) {
            hdrReader = new StringReader(busFaultHdr.asXML());
        }
        if ((busSoapFault = busFaultEnv.element(soaputil.getSOAPBodyQName(soapVer)).element(soaputil.getSOAPFaultQName(soapVer))) != null) {
            faultReader = new StringReader(busSoapFault.asXML());
        }
        return new XTSBusException("request.soapfault", faultReader, hdrReader, soapVer, includeEnvelope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IXTSInstructionResult handleXtsRequest(XTSEnvironment env, String target, Map instAtts, Map instParams, Reader body, boolean includeEnvelope) throws XTSInstructionException {
        String pathInfo = target.substring(BIBUS_XTS.length());
        XTSBusHelper busHelper = null;
        XTSEnvironment requestEnv = null;
        Document inputDoc = null;
        AXTSPoolObject reader = null;
        try {
            reader = XTSSAXReaderPool.getInstance().acquire();
        }
        catch (XTSException e) {
            throw new XTSInstructionException("protocol.xtsrequestfailed", e);
        }
        try {
            Element envelopeElem = ((SAXReader)reader.get()).read(new InputSource(body)).getRootElement();
            envelopeElem.detach();
            busHelper = new XTSBusHelper(envelopeElem, pathInfo);
        }
        catch (DocumentException e) {
            throw new XTSInstructionException("protocol.xtsrequestfailed", e);
        }
        catch (XTSException e) {
            throw new XTSInstructionException("protocol.xtsrequestfailed", e);
        }
        finally {
            XTSSAXReaderPool.getInstance().put(reader);
        }
        boolean outputHeader = false;
        String outputHeaderStr = UXTSInstructionUtils.getParameter("outputHeader", instParams);
        if (outputHeaderStr != null && outputHeaderStr.equals("true")) {
            outputHeader = true;
        }
        requestEnv = busHelper.generateEnv(env.getCallerID());
        requestEnv.setMode(requestEnv.getMode() & 0xFFFFFFFB);
        try {
            try {
                inputDoc = busHelper.getInputDoc();
                XTSProcessor.getInstance(env.getCallerID()).execute(requestEnv.getMorphletName(), inputDoc, requestEnv);
            }
            catch (XTSException e) {
                throw this.createBusException(e, requestEnv, busHelper.getSoapVersion(), inputDoc, outputHeader, includeEnvelope);
            }
            XTSXtsBusResult xTSXtsBusResult = new XTSXtsBusResult(requestEnv, inputDoc, busHelper.getSoapVersion(), includeEnvelope, outputHeader);
            return xTSXtsBusResult;
        }
        finally {
            requestEnv.cleanup();
        }
    }
}

