/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.request;

import com.cognos.pogo.http.ServerConnection;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.interpreter.instructions.IXTSOutputableInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.XTSSource;
import com.cognos.xts.interpreter.instructions.request.SOAPSAXContentHandler;
import com.cognos.xts.interpreter.instructions.request.XTSBusException;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSAuditLoggerManager;
import com.cognos.xts.output.XTSOutputSpecUtils;
import com.cognos.xts.util.ByteArrayIOStream;
import com.cognos.xts.util.MultipartMimeInputStream;
import com.cognos.xts.util.message;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.ParseException;
import org.apache.commons.httpclient.Header;

public final class XTSBusResult
implements IXTSOutputableInstructionResult {
    private static final String MULTIPART = "multipart";
    private static final String BOUNDARY = "boundary";
    private static final int BUFFER_SIZE = 4096;
    private static final String XML_BASE_CONTENT_TYPE = "text/xml; charset=utf-8";
    private ContentType m_contentType;
    private ServerConnection m_conn;
    private Reader m_soapEnvReader;
    private InputStream m_soapAttIn;
    private Reader m_soapHdrReader;
    private boolean m_bConnected;
    private String m_target;

    private XTSBusResult() {
        this.m_contentType = null;
        this.m_conn = null;
        this.m_soapEnvReader = null;
        this.m_soapAttIn = null;
        this.m_soapHdrReader = null;
        this.m_bConnected = false;
        this.m_target = null;
    }

    public XTSBusResult(XTSEnvironment env, ServerConnection conn, String target, boolean includeEnvelope, boolean separateSoapHeader) throws XTSInstructionException, XTSBusException {
        InputStream soapEnvIn;
        ContentType ct;
        block38: {
            String contentType;
            this.m_contentType = null;
            this.m_conn = null;
            this.m_soapEnvReader = null;
            this.m_soapAttIn = null;
            this.m_soapHdrReader = null;
            this.m_bConnected = false;
            this.m_target = null;
            this.m_conn = conn;
            this.m_target = target;
            InputStream in = null;
            try {
                in = this.m_conn.getInputStream();
            }
            catch (IOException e) {
                this.m_conn.release();
                Object[] args = new String[]{this.m_target};
                throw new XTSInstructionException("protocol.bus.responsefailed", args, e);
            }
            ct = null;
            try {
                contentType = this.m_conn.getResponseContentType();
            }
            catch (IllegalStateException e) {
                contentType = null;
            }
            if (contentType != null) {
                try {
                    ct = new ContentType(contentType);
                }
                catch (ParseException e) {
                    this.m_conn.release();
                    Object[] args = new Object[]{contentType, this.m_target};
                    throw new XTSInstructionException("protocol.bus.invalidcontenttype", args, e);
                }
            }
            soapEnvIn = null;
            try {
                if (ct != null && ct.getPrimaryType().equalsIgnoreCase(MULTIPART)) {
                    String boundary = ct.getParameter(BOUNDARY);
                    String boundary_start = "--" + boundary;
                    String boundary_end = boundary_start + "--";
                    String line = message.getFirstNonWhiteSpaceLine(in);
                    if (line == null) {
                        Object[] args = new Object[]{this.m_target};
                        throw new XTSInstructionException("protocol.bus.endofstream", args);
                    }
                    if (!line.equals(boundary_start)) {
                        Object[] args = new Object[]{this.m_target};
                        throw new XTSInstructionException("protocol.bus.invalidboundary", args);
                    }
                    InternetHeaders hd = null;
                    try {
                        hd = new InternetHeaders(in);
                    }
                    catch (MessagingException e) {
                        Object[] args = new Object[]{this.m_target};
                        throw new XTSInstructionException("protocol.bus.invalidmimeheaders", args, e);
                    }
                    String bodySize = hd.getHeader("Content-Length", null);
                    byte[] buf = null;
                    if (bodySize != null) {
                        int size = Integer.parseInt(bodySize);
                        buf = new byte[size];
                        for (int sizeRead = in.read(buf, 0, size); sizeRead < size; sizeRead += in.read(buf, sizeRead, size - sizeRead)) {
                        }
                        soapEnvIn = new ByteArrayInputStream(buf);
                        do {
                            if ((buf = message.readLine(in)) == null) {
                                Object[] args = new Object[]{this.m_target};
                                throw new XTSInstructionException("protocol.bus.endofstream", args);
                            }
                            line = new String(buf, "UTF-8");
                        } while (!(line = line.trim()).equals(boundary_start) && !line.equals(boundary_end));
                    } else {
                        ByteArrayIOStream out = new ByteArrayIOStream(4096);
                        while (true) {
                            if ((buf = message.readLine(in)) == null) {
                                Object[] args = new Object[]{this.m_target};
                                throw new XTSInstructionException("protocol.bus.endofstream", args);
                            }
                            line = new String(buf, "UTF-8");
                            if ((line = line.trim()).equals(boundary_start) || line.equals(boundary_end)) break;
                            out.write(buf);
                        }
                        soapEnvIn = out.convert();
                    }
                    if (!line.equals(boundary_end)) {
                        this.m_soapAttIn = in;
                    }
                    break block38;
                }
                if (ct != null && ct.getPrimaryType().equalsIgnoreCase("text") && ct.getSubType().equalsIgnoreCase("html")) {
                    int b;
                    Object[] args = new Object[]{this.m_target};
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    while ((b = in.read()) != -1) {
                        bos.write(b);
                    }
                    Exception e = new Exception(bos.toString());
                    throw new XTSInstructionException("protocol.bus.expectxmlresponse", args, e);
                }
                soapEnvIn = in;
            }
            catch (IOException e) {
                this.m_conn.release();
                Object[] args = new String[]{this.m_target};
                throw new XTSInstructionException("protocol.bus.responsefailed", args, e);
            }
            catch (XTSInstructionException e) {
                this.m_conn.release();
                throw e;
            }
        }
        if (XTSAuditLoggerManager.getInstance().isEnabled[3][1]) {
            StringBuffer buf = new StringBuffer();
            try {
                soapEnvIn = UXTSInstructionUtils.copyInputStream(soapEnvIn, buf);
                IXTSLogger logger = XTSAuditLoggerManager.getInstance().getLogger(3, 1);
                if (logger != null) {
                    logger.log(env, 3, buf.toString(), null, null);
                }
            }
            catch (IOException e) {
                throw new XTSInstructionException("instruction.failedtocopyreader", e);
            }
        }
        SOAPSAXContentHandler soapParser = new SOAPSAXContentHandler(env, includeEnvelope, separateSoapHeader);
        this.m_soapEnvReader = soapParser.processEnvelope(soapEnvIn);
        this.m_soapHdrReader = soapParser.getSoapHeader();
        if (soapParser.hasSoapFault()) {
            this.m_conn.release();
            StringReader hdrReader = null;
            StringBuffer buf = new StringBuffer();
            if (this.m_soapHdrReader != null) {
                try {
                    this.m_soapHdrReader = UXTSInstructionUtils.copyReader(this.m_soapHdrReader, buf);
                    hdrReader = new StringReader(buf.toString());
                }
                catch (IOException e) {
                    throw new XTSInstructionException("instruction.failedtocopyreader", e);
                }
            }
            throw new XTSBusException("request.soapfault", this.m_soapEnvReader, hdrReader, soapParser.getSoapVersion(), includeEnvelope);
        }
        if (this.m_soapAttIn == null) {
            this.m_conn.release();
        } else {
            try {
                this.m_soapAttIn = new MultipartMimeInputStream(this.m_soapAttIn, ct.getParameter(BOUNDARY), true);
            }
            catch (UnsupportedEncodingException e) {
                this.m_conn.release();
                Object[] args = new String[]{"BUS"};
                throw new XTSInstructionException("protocol.unsupportedencodingexception", args, e);
            }
            catch (IOException e) {
                this.m_conn.release();
                throw new XTSInstructionException("protocol.ioexception", e);
            }
            this.m_bConnected = true;
        }
    }

    @Override
    public void writeCopyTo(OutputStream out) throws XTSInstructionException {
        try {
            ByteArrayIOStream bio = new ByteArrayIOStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)bio, "UTF-8"));
            char[] buf = new char[4096];
            int bytesRead = this.m_soapEnvReader.read(buf, 0, 4096);
            while (bytesRead != -1) {
                ((Writer)writer).write(buf, 0, bytesRead);
                bytesRead = this.m_soapEnvReader.read(buf, 0, 4096);
            }
            ((Writer)writer).flush();
            bio.writeTo(out);
            this.m_soapEnvReader = new BufferedReader(new InputStreamReader((InputStream)bio.convert(), "UTF-8"));
        }
        catch (IOException e) {
            Object[] args = new String[]{this.getClass().getName()};
            throw new XTSInstructionException("instruction.writetooutputstreamfailed", args, e);
        }
    }

    @Override
    public XTSSource getResult() throws XTSInstructionException {
        return new XTSSource(this.m_soapEnvReader);
    }

    @Override
    public void release() throws XTSInstructionException {
        if (this.m_bConnected) {
            this.m_conn.release();
            this.m_bConnected = false;
        }
        try {
            if (this.m_soapEnvReader != null) {
                this.m_soapEnvReader.close();
                this.m_soapEnvReader = null;
            }
            if (this.m_soapAttIn != null) {
                this.m_soapAttIn.close();
                this.m_soapAttIn = null;
            }
            if (this.m_soapHdrReader != null) {
                this.m_soapHdrReader.close();
                this.m_soapHdrReader = null;
            }
        }
        catch (IOException e) {
            throw new XTSInstructionException("protocol.ioexception", e);
        }
    }

    public Reader getSOAPHeader() {
        return this.m_soapHdrReader;
    }

    @Override
    public boolean attachmentsSupported() {
        return true;
    }

    @Override
    public int getSupportedOptionsBitMap() {
        return 31;
    }

    @Override
    public boolean statusHeaderSupported() {
        return false;
    }

    @Override
    public boolean protocolHeaderSupported() {
        return true;
    }

    @Override
    public InputStream getAttachmentInputStream() throws XTSInstructionException {
        return this.m_soapAttIn;
    }

    @Override
    public InternetHeaders getStatusHeaders() throws XTSInstructionException {
        return null;
    }

    @Override
    public InternetHeaders getProtocolHeaders() throws XTSInstructionException {
        InternetHeaders iHdrs = new InternetHeaders();
        Header[] hdrs = this.m_conn.getResponseHeaders();
        Header hdr = null;
        for (int i = 0; i < hdrs.length; ++i) {
            hdr = hdrs[i];
            String hdrName = hdr.getName();
            if (XTSOutputSpecUtils.isMimeHeader(hdrName)) continue;
            iHdrs.addHeader(hdrName, hdr.getValue());
        }
        return iHdrs;
    }

    @Override
    public ContentType getDefaultMimeType() throws XTSInstructionException {
        if (this.m_contentType == null) {
            try {
                this.m_contentType = new ContentType(XML_BASE_CONTENT_TYPE);
            }
            catch (ParseException e) {
                Object[] args = new Object[]{XML_BASE_CONTENT_TYPE};
                throw new XTSInstructionException("protocol.invalidcontenttype", args, e);
            }
        }
        return this.m_contentType;
    }
}

