/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.request;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXReaderPool;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.request.IXTSRequestInstruction;
import com.cognos.xts.interpreter.instructions.request.XTSCogxResult;
import com.cognos.xts.util.CogXConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public final class XTSCogxRequest
extends AXTSInstruction
implements IXTSRequestInstruction {
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String ENCODING = "encoding";
    public static final String COGX_NAMESPACE_URI = "http://developer.cognos.com/schemas/cogx/";
    public static final String COGX_NAMESPACE_PREFIX = "cogx";
    public static final String COGX_ENVELOPE = "envelope";
    public static final String COGX_ATTRIB_ENCODING = "encoding";
    public static final String COGX_ROUTING = "routing";
    public static final String COGX_COMMAND = "command";
    public static final String COGX_RESULT = "result";
    public static final Namespace COGX_NAMESPACE = new Namespace("cogx", "http://developer.cognos.com/schemas/cogx/");
    public static final QName COGX_ENVELOPE_QNAME = new QName("envelope", COGX_NAMESPACE);
    private static final QName COGX_ROUTING_QNAME = new QName("routing", COGX_NAMESPACE);
    private static final QName COGX_COMMAND_QNAME = new QName("command", COGX_NAMESPACE);
    private String m_sIdentifier = null;

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
    }

    @Override
    public void terminate() throws XTSInstructionException {
    }

    @Override
    public boolean isInitialized() {
        return this.m_sIdentifier != null;
    }

    @Override
    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        String target = (String)instAtts.get("target");
        if (target == null || target.length() == 0) {
            throw new XTSInstructionException("protocol.missingtarget");
        }
        AXTSPoolObject reader = null;
        try {
            reader = XTSSAXReaderPool.getInstance().acquire();
        }
        catch (XTSException e) {
            throw new XTSInstructionException("request.invalidrequestdocument", e);
        }
        Element request_elem = null;
        try {
            request_elem = ((SAXReader)reader.get()).read(new InputSource(body)).getRootElement();
        }
        catch (DocumentException e) {
            throw new XTSInstructionException("request.invalidrequestdocument", e);
        }
        finally {
            XTSSAXReaderPool.getInstance().put(reader);
        }
        if (!request_elem.getName().equals(COGX_ENVELOPE_QNAME.getName()) || !request_elem.getNamespaceURI().equals(COGX_ENVELOPE_QNAME.getNamespaceURI())) {
            Object[] args = new String[]{COGX_ENVELOPE_QNAME.getQualifiedName()};
            throw new XTSInstructionException("request.requestdocumentelementmissing", args);
        }
        String sHost = UXTSInstructionUtils.getParameter(HOST, instParams);
        String sPort = UXTSInstructionUtils.getParameter(PORT, instParams);
        String sEncoding = UXTSInstructionUtils.getParameter("encoding", instParams);
        CogXConnection conn = null;
        try {
            conn = new CogXConnection(target, sHost, sPort, sEncoding);
        }
        catch (MalformedURLException e) {
            Object[] args = new String[]{target};
            throw new XTSInstructionException("request.targetparseerror", args, e);
        }
        this.sendRequest(env, conn, request_elem);
        return new XTSCogxResult(env, conn, (String)instAtts.get("baseDebugDir"));
    }

    private void sendRequest(XTSEnvironment env, CogXConnection conn, Element cogx_elem) throws XTSInstructionException {
        Element routing_elem = cogx_elem.element(COGX_ROUTING_QNAME);
        if (routing_elem == null) {
            Object[] args = new String[]{COGX_ROUTING_QNAME.getQualifiedName()};
            throw new XTSInstructionException("request.malformed", args);
        }
        Element command_elem = cogx_elem.element(COGX_COMMAND_QNAME);
        if (command_elem == null) {
            Object[] args = new String[]{COGX_COMMAND_QNAME.getQualifiedName()};
            throw new XTSInstructionException("request.malformed", args);
        }
        byte[] routingArr = null;
        byte[] commandArr = null;
        try {
            routingArr = routing_elem.asXML().getBytes(conn.getEncoding());
            commandArr = command_elem.asXML().getBytes(conn.getEncoding());
        }
        catch (Exception ex) {
            Object[] args = new String[]{ex.getMessage()};
            throw new XTSInstructionException("request.serialize", args);
        }
        try {
            conn.connect();
        }
        catch (IOException io) {
            Object[] args = new String[]{conn.getTarget(), conn.getHost(), conn.getPortString()};
            throw new XTSInstructionException("request.connecterror", args);
        }
        try {
            conn.write(routingArr, commandArr);
        }
        catch (IOException io) {
            Object[] args = new String[]{conn.getTarget(), conn.getHost(), conn.getPortString()};
            throw new XTSInstructionException("request.sendcommanderror", args, io);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: " + XTSCogxRequest.class.getName() + " target");
            System.exit(0);
        }
        XTSCogxRequest inst = new XTSCogxRequest();
        String routing = "<routing><apiversion>2.0</apiversion><dispatcher did=\"\"><server sid=\"\"></server></dispatcher><target/></routing>";
        String command = "<command><apiversion>3.0</apiversion><sender component=\"Upfront\" msgversion=\"1.1\" version=\"7.0 Build 182 - Not for Resale\"/><messageattribute><ticket>XXX</ticket><locale>en-us</locale><utcoffset>0</utcoffset><language>en</language><theme>standard70</theme></messageattribute><message><actionnotify xmlns=\"http://developer.cognos.com/schemas/upfront/\"><DescribeProviderNewsItem><id>0A421E6D92A0C6AD00E8BFAEF8208004</id><contentname/></DescribeProviderNewsItem></actionnotify></message></command>";
        String body = "<envelope xmlns=\"http://developer.cognos.com/schemas/cogx/\">" + routing + command + "</envelope>";
        XTSEnvironment env = new XTSEnvironment("TEST");
        env.setLocale(Locale.getDefault());
        HashMap<String, String> instAtts = new HashMap<String, String>();
        instAtts.put("target", args[0]);
        HashMap instParams = new HashMap();
        IXTSInstructionResult result = null;
        try {
            System.out.println("\nSending request to: " + args[0]);
            result = inst.execute(env, instAtts, instParams, new StringReader(body));
            System.out.println("Result:");
            InputStream resultInputStream = result.getResult().getInputStream();
            byte[] buf = new byte[4096];
            try {
                int bytesRead = resultInputStream.read(buf, 0, 4096);
                while (bytesRead != -1) {
                    System.out.println(new String(buf, 0, bytesRead));
                    bytesRead = resultInputStream.read(buf, 0, 4096);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (result != null) {
                try {
                    result.release();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            env.cleanup();
        }
    }
}

