/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.request;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.atlantic.CCogxResultXMLFilter;
import com.cognos.xts.atlantic.upfront.CUpfResultXMLFilter;
import com.cognos.xts.interpreter.instructions.IXTSOutputableInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.XTSSource;
import com.cognos.xts.interpreter.instructions.request.XTSCogxRequest;
import com.cognos.xts.util.ByteArrayIOStream;
import com.cognos.xts.util.CogXConnection;
import com.cognos.xts.util.SequenceReader;
import com.cognos.xts.util.XMLInputStreamToReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.ParseException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class XTSCogxResult
implements IXTSOutputableInstructionResult {
    private static final String OPEN_BRACKET_START = "<";
    private static final String OPEN_BRACKET_END = ">";
    private static final String CLOSE_BRACKET_START = "</";
    private static final String CLOSE_BRACKET_END = ">";
    private static final String COGX_XMLNS_DECLARATION = new String("xmlns:cogx=\"http://developer.cognos.com/schemas/cogx/\"");
    private static final String EQUALS = "=";
    private static final String QUOTE = "\"";
    private static final String SPACE = " ";
    private static final String UPFRONT = "upfront";
    private CogXConnection m_conn = null;
    private Reader m_cogxResultReader = null;
    private String m_contentType = "text/xml";

    private XTSCogxResult() {
    }

    public XTSCogxResult(XTSEnvironment env, CogXConnection conn, String baseDebugDir) throws XTSInstructionException {
        this.m_conn = conn;
        try {
            this.m_conn.read();
            this.m_contentType = this.m_contentType + "; charset=" + this.m_conn.getEncoding();
        }
        catch (IOException io) {
            Object[] args = new String[]{io.getMessage()};
            throw new XTSInstructionException("response.ioerror", args);
        }
        StringBuffer resultStartBuf = new StringBuffer();
        resultStartBuf.append(OPEN_BRACKET_START);
        resultStartBuf.append(XTSCogxRequest.COGX_ENVELOPE_QNAME.getQualifiedName());
        resultStartBuf.append(SPACE);
        resultStartBuf.append(COGX_XMLNS_DECLARATION);
        resultStartBuf.append(">");
        this.m_cogxResultReader = new StringReader(resultStartBuf.toString());
        try {
            byte[] routingBytes = this.m_conn.getRouting();
            if (routingBytes.length > 0) {
                this.m_cogxResultReader = new SequenceReader(this.m_cogxResultReader, XMLInputStreamToReader.convert(new ByteArrayInputStream(routingBytes)));
            }
        }
        catch (Exception e) {
            Object[] args = new String[]{this.m_conn.getTarget()};
            throw new XTSInstructionException("response.cogx.parseroutingfailed", args, e);
        }
        ContentHandler filter = new CCogxResultXMLFilter(env.getLocale());
        if (this.m_conn.getTarget().equalsIgnoreCase(UPFRONT)) {
            filter = new CUpfResultXMLFilter(env.getLocale(), (XMLReader)((Object)filter));
        }
        try {
            this.m_cogxResultReader = new SequenceReader(this.m_cogxResultReader, XMLInputStreamToReader.convert(new ByteArrayInputStream(this.m_conn.getResult()), filter));
        }
        catch (SAXException e) {
            throw new XTSInstructionException(e.getMessage());
        }
        catch (Exception e) {
            Object[] args = new String[]{this.m_conn.getTarget()};
            throw new XTSInstructionException("response.cogx.parseresultfailed", args, e);
        }
        StringBuffer resultEndBuf = new StringBuffer();
        resultEndBuf.append(CLOSE_BRACKET_START);
        resultEndBuf.append(XTSCogxRequest.COGX_ENVELOPE_QNAME.getQualifiedName());
        resultEndBuf.append(">");
        this.m_cogxResultReader = new SequenceReader(this.m_cogxResultReader, new StringReader(resultEndBuf.toString()));
    }

    @Override
    public XTSSource getResult() {
        return new XTSSource(this.m_cogxResultReader);
    }

    @Override
    public void release() throws XTSInstructionException {
        this.m_conn.disconnect();
        try {
            if (this.m_cogxResultReader != null) {
                this.m_cogxResultReader.close();
                this.m_cogxResultReader = null;
            }
        }
        catch (IOException e) {
            throw new XTSInstructionException("protocol.ioexception", e);
        }
    }

    @Override
    public void writeCopyTo(OutputStream out) throws XTSInstructionException {
        try {
            ByteArrayIOStream bio = new ByteArrayIOStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)bio, "UTF-8"));
            char[] buf = new char[4096];
            int bytesRead = this.m_cogxResultReader.read(buf, 0, 4096);
            while (bytesRead != -1) {
                ((Writer)writer).write(buf, 0, bytesRead);
                bytesRead = this.m_cogxResultReader.read(buf, 0, 4096);
            }
            ((Writer)writer).flush();
            bio.writeTo(out);
            this.m_cogxResultReader = new BufferedReader(new InputStreamReader((InputStream)bio.convert(), "UTF-8"));
        }
        catch (IOException e) {
            Object[] args = new String[]{this.getClass().getName()};
            throw new XTSInstructionException("instruction.writetooutputstreamfailed", args, e);
        }
    }

    @Override
    public boolean attachmentsSupported() {
        return false;
    }

    @Override
    public int getSupportedOptionsBitMap() {
        return 7;
    }

    @Override
    public boolean statusHeaderSupported() {
        return false;
    }

    @Override
    public boolean protocolHeaderSupported() {
        return false;
    }

    @Override
    public InputStream getAttachmentInputStream() throws XTSInstructionException {
        return null;
    }

    @Override
    public InternetHeaders getStatusHeaders() throws XTSInstructionException {
        return null;
    }

    @Override
    public InternetHeaders getProtocolHeaders() throws XTSInstructionException {
        return null;
    }

    @Override
    public ContentType getDefaultMimeType() throws XTSInstructionException {
        ContentType contentType = null;
        try {
            contentType = new ContentType(this.m_contentType);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return contentType;
    }
}

