/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.request;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.request.IXTSRequestInstruction;
import com.cognos.xts.interpreter.instructions.request.XTSFileReadResult;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.resource.PathUtils;
import com.cognos.xts.util.XTSObjectCache;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;

public class XTSDbgFileReadRequest
extends AXTSInstruction
implements IXTSRequestInstruction {
    private static final int READ_SIZE = 4096;
    private String m_sIdentifier = null;
    private XTSObjectCache m_oFileCache = new XTSObjectCache();
    private Object m_oMutexObj = new Object();
    private String m_OptionDebugDirCanonical = null;
    private String m_TemplateRootCanonical = null;

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
        String sTemplateRoot = PropertiesManager.getInstance().getProperty("template.root");
        if (sTemplateRoot == null) {
            throw new XTSInstructionException("reader.missingroot");
        }
        try {
            this.m_TemplateRootCanonical = new File(sTemplateRoot).getCanonicalPath();
        }
        catch (IOException e) {
            throw new XTSInstructionException("reader.instantiationerror", e);
        }
        String sOptionDebugDir = PropertiesManager.getInstance().getProperty("option.debugdir");
        if (sOptionDebugDir == null) {
            throw new XTSInstructionException("reader.missingroot");
        }
        try {
            this.m_OptionDebugDirCanonical = new File(sOptionDebugDir).getCanonicalPath();
        }
        catch (IOException e) {
            throw new XTSInstructionException("reader.instantiationerror", e);
        }
    }

    @Override
    public void terminate() throws XTSInstructionException {
    }

    @Override
    public boolean isInitialized() {
        return this.m_sIdentifier != null;
    }

    private boolean exists(String sFileName) throws XTSException {
        File fileObj = new File(sFileName);
        String sCanonicalPath = null;
        try {
            sCanonicalPath = fileObj.getCanonicalPath();
        }
        catch (IOException e) {
            throw new XTSException("reader.instantiationerror", e);
        }
        if (!sCanonicalPath.startsWith(this.m_OptionDebugDirCanonical) && !sCanonicalPath.startsWith(this.m_TemplateRootCanonical)) {
            Object[] args = new String[]{sFileName};
            throw new XTSException("reader.securityviolation", args);
        }
        return fileObj.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        ByteArrayOutputStream fout;
        block14: {
            String target = (String)instAtts.get("target");
            if (target == null || target.length() == 0) {
                throw new XTSInstructionException("protocol.missingtarget");
            }
            String sFileName = null;
            try {
                sFileName = PathUtils.buildPath(this.m_OptionDebugDirCanonical, target);
            }
            catch (IOException e) {
                Object[] args = new String[]{this.m_sIdentifier, "", target};
                throw new XTSInstructionException("instruction.buildfullpathfailed", args, e);
            }
            fout = null;
            try {
                fout = (ByteArrayOutputStream)this.m_oFileCache.getObject(target);
                if (fout != null) break block14;
                Object args = this.m_oMutexObj;
                synchronized (args) {
                    fout = (ByteArrayOutputStream)this.m_oFileCache.getObject(target);
                    if (fout == null) {
                        try {
                            if (!this.exists(sFileName)) {
                                Object[] args2 = new String[]{sFileName};
                                throw new XTSInstructionException("protocol.fileopenfailed", args2);
                            }
                            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sFileName));
                            fout = new ByteArrayOutputStream();
                            byte[] buf = new byte[4096];
                            int bytesRead = ((InputStream)bis).read(buf, 0, 4096);
                            while (bytesRead != -1) {
                                fout.write(buf, 0, bytesRead);
                                bytesRead = ((InputStream)bis).read(buf, 0, 4096);
                            }
                        }
                        catch (IOException e) {
                            Object[] args3 = new String[]{sFileName};
                            throw new XTSInstructionException("protocol.fileopenfailed", args3, e);
                        }
                        catch (XTSException e) {
                            Object[] args4 = new String[]{sFileName};
                            throw new XTSInstructionException("protocol.fileopenfailed", args4, e);
                        }
                        this.m_oFileCache.addObject(target, fout);
                    }
                }
            }
            catch (InterruptedException e) {
                throw new XTSInstructionException("objectfactory.lockinterrupted", e);
            }
        }
        return new XTSFileReadResult(new ByteArrayInputStream(fout.toByteArray()));
    }
}

