/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.request;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.request.IXTSRequestInstruction;
import com.cognos.xts.interpreter.instructions.request.XTSFileReadResult;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.resource.PathUtils;
import com.cognos.xts.resource.XTSResourceManager;
import com.cognos.xts.util.XTSObjectCache;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;

public class XTSFileReadRequest
extends AXTSInstruction
implements IXTSRequestInstruction {
    private static final int READ_SIZE = 4096;
    private String m_sIdentifier = null;
    private String m_sTemplateRoot = null;
    private XTSObjectCache m_oFileCache = new XTSObjectCache();
    private Object m_oMutexObj = new Object();

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
        this.m_sTemplateRoot = PropertiesManager.getInstance().getProperty("template.root");
    }

    @Override
    public void terminate() throws XTSInstructionException {
    }

    @Override
    public boolean isInitialized() {
        return this.m_sIdentifier != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        ByteArrayOutputStream fout;
        block17: {
            String target = (String)instAtts.get("target");
            if (target == null || target.length() == 0) {
                throw new XTSInstructionException("protocol.missingtarget");
            }
            String errNode = (String)instAtts.get("genErrorNode");
            String errNodeName = null;
            if (errNode != null && errNode.length() > 0) {
                errNodeName = errNode.trim();
            }
            String sFileName = null;
            try {
                sFileName = PathUtils.buildPath(target);
            }
            catch (IOException e) {
                Object[] args = new String[]{this.m_sIdentifier, this.m_sTemplateRoot, target};
                throw new XTSInstructionException("instruction.buildfullpathfailed", args, e);
            }
            fout = null;
            try {
                fout = (ByteArrayOutputStream)this.m_oFileCache.getObject(target);
                if (fout != null) break block17;
                Object args = this.m_oMutexObj;
                synchronized (args) {
                    fout = (ByteArrayOutputStream)this.m_oFileCache.getObject(target);
                    if (fout == null) {
                        try {
                            InputStream is = XTSResourceManager.getInstance().getResource(sFileName);
                            if (is == null && errNodeName == null) {
                                Object[] args2 = new String[]{sFileName};
                                throw new XTSInstructionException("protocol.fileopenfailed", args2);
                            }
                            fout = new ByteArrayOutputStream();
                            byte[] buf = new byte[4096];
                            if (is != null) {
                                BufferedInputStream bis = new BufferedInputStream(is);
                                int bytesRead = ((InputStream)bis).read(buf, 0, 4096);
                                while (bytesRead != -1) {
                                    fout.write(buf, 0, bytesRead);
                                    bytesRead = ((InputStream)bis).read(buf, 0, 4096);
                                }
                            } else {
                                StringBuffer msg = new StringBuffer();
                                msg.append("<");
                                msg.append(errNodeName);
                                msg.append(">");
                                msg.append(target);
                                msg.append(" - file not available</");
                                msg.append(errNodeName);
                                msg.append(">\n");
                                buf = msg.toString().getBytes("UTF-8");
                                fout.write(buf, 0, msg.length() - 1);
                            }
                        }
                        catch (IOException e) {
                            Object[] args3 = new String[]{sFileName};
                            throw new XTSInstructionException("protocol.fileopenfailed", args3, e);
                        }
                        catch (XTSException e) {
                            Object[] args4 = new String[]{sFileName};
                            throw new XTSInstructionException("protocol.fileopenfailed", args4, e);
                        }
                        this.m_oFileCache.addObject(target, fout);
                    }
                }
            }
            catch (InterruptedException e) {
                throw new XTSInstructionException("TODO:objectfactory.lockinterrupted", e);
            }
        }
        return new XTSFileReadResult(new ByteArrayInputStream(fout.toByteArray()));
    }
}

