/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.request;

import com.cognos.xts.interpreter.instructions.IXTSOutputableInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.XTSSource;
import com.cognos.xts.util.ByteArrayIOStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.ParseException;

public class XTSFileReadResult
implements IXTSOutputableInstructionResult {
    private static final String XML_BASE_CONTENT_TYPE = "text/xml; charset=utf-8";
    private ContentType m_contentType = null;
    private InputStream m_stream = null;

    public XTSFileReadResult(InputStream stream) throws XTSInstructionException {
        this.m_stream = stream;
    }

    @Override
    public XTSSource getResult() throws XTSInstructionException {
        return new XTSSource(this.m_stream);
    }

    @Override
    public void release() throws XTSInstructionException {
        try {
            if (this.m_stream != null) {
                this.m_stream.close();
                this.m_stream = null;
            }
        }
        catch (IOException e) {
            throw new XTSInstructionException("protocol.fileclosefailed", e);
        }
    }

    @Override
    public void writeCopyTo(OutputStream out) throws XTSInstructionException {
        try {
            ByteArrayIOStream bio = new ByteArrayIOStream();
            byte[] buf = new byte[4096];
            int bytesRead = this.m_stream.read(buf, 0, 4096);
            while (bytesRead != -1) {
                bio.write(buf, 0, bytesRead);
                bytesRead = this.m_stream.read(buf, 0, 4096);
            }
            bio.writeTo(out);
            this.m_stream = bio.convert();
        }
        catch (Exception e) {
            Object[] args = new String[]{this.getClass().getName()};
            throw new XTSInstructionException("instruction.writetooutputstreamfailed", args, e);
        }
    }

    @Override
    public boolean attachmentsSupported() {
        return false;
    }

    @Override
    public int getSupportedOptionsBitMap() {
        return 7;
    }

    @Override
    public boolean statusHeaderSupported() {
        return false;
    }

    @Override
    public boolean protocolHeaderSupported() {
        return false;
    }

    @Override
    public InputStream getAttachmentInputStream() throws XTSInstructionException {
        return null;
    }

    @Override
    public InternetHeaders getStatusHeaders() throws XTSInstructionException {
        return null;
    }

    @Override
    public InternetHeaders getProtocolHeaders() throws XTSInstructionException {
        return null;
    }

    @Override
    public ContentType getDefaultMimeType() throws XTSInstructionException {
        if (this.m_contentType == null) {
            try {
                this.m_contentType = new ContentType(XML_BASE_CONTENT_TYPE);
            }
            catch (ParseException e) {
                Object[] args = new Object[]{XML_BASE_CONTENT_TYPE};
                throw new XTSInstructionException("protocol.invalidcontenttype", args, e);
            }
        }
        return this.m_contentType;
    }
}

