/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.request;

import com.cognos.pogo.http.ServerConnection;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.request.AXTSSoapResult;
import com.cognos.xts.interpreter.instructions.request.XTSSoapFaultException;
import com.cognos.xts.output.XTSOutputSpecUtils;
import java.io.IOException;
import javax.mail.internet.InternetHeaders;
import org.apache.commons.httpclient.Header;

public class XTSHttpClientSoapResult
extends AXTSSoapResult {
    private ServerConnection m_conn = null;
    private InternetHeaders internetHeaders = null;

    public XTSHttpClientSoapResult(XTSEnvironment env, ServerConnection conn, boolean includeEnvelope) throws XTSInstructionException, XTSSoapFaultException {
        this.m_conn = conn;
        this.setInternetHeaders();
        try {
            String contentType;
            try {
                contentType = conn.getResponseContentType();
            }
            catch (IllegalStateException e) {
                contentType = null;
            }
            this.process(env, includeEnvelope, this.m_conn.getInputStream(), contentType);
        }
        catch (IOException e) {
            throw new XTSInstructionException("protocol.ioexception", e);
        }
    }

    @Override
    protected void disconnect() {
        this.m_conn.release();
    }

    private void setInternetHeaders() throws XTSInstructionException {
        this.internetHeaders = new InternetHeaders();
        Header[] headers = this.m_conn.getResponseHeaders();
        for (int i = 0; i < headers.length; ++i) {
            String key = headers[i].getName();
            String keyValue = headers[i].getValue();
            if (key == null || XTSOutputSpecUtils.isMimeHeader(key)) continue;
            this.internetHeaders.addHeader(key, keyValue);
        }
    }

    @Override
    public InternetHeaders getProtocolHeaders() throws XTSInstructionException {
        return this.internetHeaders;
    }
}

