/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.request;

import com.cognos.xts.XTSException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXReaderPool;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public class XTSHttpResponseException
extends XTSInstructionException {
    private int m_responseCode;
    private String m_responseMessage;
    private String m_responseBody;
    private boolean m_parseResponseBody;
    private Map m_responseHeaders;

    public XTSHttpResponseException(String key, int responseCode, String responseMessage, String responseBody, boolean parseResponseBody, Map responseHeaders) {
        super(key);
        this.m_responseCode = responseCode;
        this.m_responseMessage = responseMessage;
        this.m_responseBody = responseBody;
        this.m_parseResponseBody = parseResponseBody;
        this.m_responseHeaders = responseHeaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getFaultXML(Locale locale, boolean stackdump) {
        Element exceptionElement = DocumentHelper.createElement((QName)EXCEPTION_QNAME);
        Element exceptionCodeElement = DocumentHelper.createElement((QName)EXCEPTIONCODE_QNAME);
        exceptionCodeElement.setText(super.getKey());
        exceptionElement.add(exceptionCodeElement);
        Element exceptionMsgElement = DocumentHelper.createElement((QName)EXCEPTIONMSG_QNAME);
        exceptionMsgElement.setText(super.getLocalizedMsgString(locale));
        exceptionElement.add(exceptionMsgElement);
        Element exceptionDetailElement = DocumentHelper.createElement((QName)EXCEPTIONDETAIL_QNAME);
        Element httpResponseElem = DocumentHelper.createElement((String)"httpResponse");
        exceptionDetailElement.add(httpResponseElem);
        Element responseCodeElem = DocumentHelper.createElement((String)"code");
        responseCodeElem.setText(Integer.toString(this.m_responseCode));
        httpResponseElem.add(responseCodeElem);
        Element responseMsgElem = DocumentHelper.createElement((String)"message");
        responseMsgElem.setText(this.m_responseMessage);
        httpResponseElem.add(responseMsgElem);
        Element responseHdrsElem = DocumentHelper.createElement((String)"header");
        Element header = null;
        Iterator it = this.m_responseHeaders.entrySet().iterator();
        Map.Entry pair = null;
        while (it.hasNext()) {
            pair = it.next();
            header = DocumentHelper.createElement((String)"param");
            header.addAttribute("name", (String)pair.getKey());
            header.setText((String)pair.getValue());
            responseHdrsElem.add(header);
        }
        httpResponseElem.add(responseHdrsElem);
        Element bodyElem = DocumentHelper.createElement((String)"body");
        httpResponseElem.add(bodyElem);
        if (this.m_parseResponseBody) {
            AXTSPoolObject reader = null;
            try {
                reader = XTSSAXReaderPool.getInstance().acquire();
                try {
                    Element responseBodyElem = ((SAXReader)reader.get()).read(new InputSource(new StringReader(this.m_responseBody))).getRootElement();
                    bodyElem.add(responseBodyElem);
                }
                catch (DocumentException e) {
                    bodyElem.setText(this.m_responseBody);
                }
                finally {
                    XTSSAXReaderPool.getInstance().put(reader);
                }
            }
            catch (XTSException e) {
                bodyElem.setText(this.m_responseBody);
            }
        } else {
            bodyElem.setText(this.m_responseBody);
        }
        exceptionElement.add(exceptionDetailElement);
        return exceptionElement;
    }
}

