/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.request;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXParserPool;
import com.cognos.xts.interpreter.instructions.IXTSOutputableInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.XTSSource;
import com.cognos.xts.interpreter.instructions.request.SOAPSAXContentHandler;
import com.cognos.xts.interpreter.instructions.request.XTSSoapFaultException;
import com.cognos.xts.output.XTSConstants;
import com.cognos.xts.output.XTSOutputObject;
import com.cognos.xts.output.XTSOutputSpecUtils;
import com.cognos.xts.util.ByteArrayIOStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.ParseException;
import javax.xml.parsers.SAXParser;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class XTSInternalSoapResult
implements IXTSOutputableInstructionResult {
    private static final String XML_BASE_CONTENT_TYPE = "text/xml; charset=utf-8";
    private Reader m_soapEnvReader = null;
    private InputStream m_soapAttIn = null;
    private XTSEnvironment m_requestEnv = null;
    private InternetHeaders m_protocolHdrs = null;
    private List m_cleanUpObjList = null;

    private XTSInternalSoapResult() {
    }

    public XTSInternalSoapResult(XTSEnvironment requestEnv, Document resultDoc, boolean includeEnvelope) throws XTSInstructionException {
        this.m_requestEnv = requestEnv;
        Element outputElement = resultDoc.getRootElement().element("output");
        List protocolHeaderElemList = outputElement.elements(XTSConstants.ELEM_NM_PROTOCOLHEADER);
        for (Element protocolHeaderElem : protocolHeaderElemList) {
            List paramElemList = protocolHeaderElem.elements(XTSConstants.ELEM_NM_PARAM);
            if (paramElemList.size() <= 0) continue;
            this.m_protocolHdrs = new InternetHeaders();
            Element paramElem2 = null;
            for (Element paramElem2 : paramElemList) {
                this.m_protocolHdrs.addHeader(paramElem2.attributeValue("name"), paramElem2.getTextTrim());
            }
        }
        InputStream in = null;
        List partElemList = outputElement.elements(XTSConstants.ELEM_NM_PART);
        if (partElemList.size() > 0) {
            Element partElem = (Element)partElemList.get(0);
            try {
                in = XTSOutputSpecUtils.generateInputStream(this.m_requestEnv, partElem, false, this.m_cleanUpObjList, null);
            }
            catch (XTSException e) {
                throw new XTSInstructionException("protocol.xts.parseinternalresultfailed", e);
            }
        }
        SOAPSAXContentHandler soapParser = new SOAPSAXContentHandler(this.m_requestEnv, includeEnvelope, false);
        this.m_soapEnvReader = soapParser.processEnvelope(in);
        if (partElemList.size() > 1) {
            Element partElem = (Element)partElemList.get(1);
            try {
                this.m_soapAttIn = XTSOutputSpecUtils.generateInputStream(this.m_requestEnv, partElem, false, this.m_cleanUpObjList, null);
            }
            catch (XTSException e) {
                throw new XTSInstructionException("protocol.xts.parseinternalresultfailed", e);
            }
        }
        if (soapParser.hasSoapFault()) {
            Element faultElement = null;
            try {
                AXTSPoolObject parser = XTSSAXParserPool.getInstance().acquire();
                try {
                    XMLReader reader = ((SAXParser)parser.get()).getXMLReader();
                    SAXReader saxreader = new SAXReader(reader);
                    Document document = saxreader.read(this.m_soapEnvReader);
                    faultElement = document.getRootElement();
                }
                catch (DocumentException e) {
                    throw new XTSInstructionException("protocol.xts.parseinternalresultfailed", e);
                }
                finally {
                    XTSSAXParserPool.getInstance().put(parser);
                }
            }
            catch (SAXException e) {
                throw new XTSInstructionException("protocol.xts.parseinternalresultfailed", e);
            }
            catch (XTSException e) {
                throw new XTSInstructionException("protocol.xts.parseinternalresultfailed", e);
            }
            Element detail = faultElement.element("detail");
            if (detail != null) {
                Iterator i = detail.elementIterator();
                while (i.hasNext()) {
                    Element element = (Element)i.next();
                    faultElement.addNamespace(element.getNamespacePrefix(), element.getNamespaceURI());
                }
            }
            throw new XTSSoapFaultException("request.soapfault", new StringReader(faultElement.asXML()), soapParser.getSoapHeader(), soapParser.getSoapVersion(), includeEnvelope);
        }
    }

    @Override
    public XTSSource getResult() throws XTSInstructionException {
        return new XTSSource(this.m_soapEnvReader);
    }

    @Override
    public void release() throws XTSInstructionException {
        this.m_requestEnv.cleanup();
        if (this.m_cleanUpObjList != null) {
            for (XTSOutputObject outputObj : this.m_cleanUpObjList) {
                outputObj.release();
                Object var2_3 = null;
            }
            this.m_cleanUpObjList.clear();
        }
        try {
            if (this.m_soapEnvReader != null) {
                this.m_soapEnvReader.close();
                this.m_soapEnvReader = null;
            }
            if (this.m_soapAttIn != null) {
                this.m_soapAttIn.close();
                this.m_soapAttIn = null;
            }
        }
        catch (IOException e) {
            throw new XTSInstructionException("protocol.ioexception", e);
        }
    }

    @Override
    public void writeCopyTo(OutputStream out) throws XTSInstructionException {
        try {
            ByteArrayIOStream bio = new ByteArrayIOStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)bio, "UTF-8"));
            char[] buf = new char[4096];
            int bytesRead = this.m_soapEnvReader.read(buf, 0, 4096);
            while (bytesRead != -1) {
                ((Writer)writer).write(buf, 0, bytesRead);
                bytesRead = this.m_soapEnvReader.read(buf, 0, 4096);
            }
            ((Writer)writer).flush();
            bio.writeTo(out);
            this.m_soapEnvReader = new BufferedReader(new InputStreamReader((InputStream)bio.convert(), "UTF-8"));
        }
        catch (IOException e) {
            Object[] args = new String[]{this.getClass().getName()};
            throw new XTSInstructionException("instruction.writetooutputstreamfailed", args, e);
        }
    }

    @Override
    public boolean attachmentsSupported() {
        return true;
    }

    @Override
    public int getSupportedOptionsBitMap() {
        return 31;
    }

    @Override
    public boolean statusHeaderSupported() {
        return false;
    }

    @Override
    public boolean protocolHeaderSupported() {
        return true;
    }

    @Override
    public InputStream getAttachmentInputStream() throws XTSInstructionException {
        return this.m_soapAttIn;
    }

    @Override
    public InternetHeaders getStatusHeaders() throws XTSInstructionException {
        return null;
    }

    @Override
    public InternetHeaders getProtocolHeaders() throws XTSInstructionException {
        return this.m_protocolHdrs;
    }

    @Override
    public ContentType getDefaultMimeType() throws XTSInstructionException {
        try {
            return new ContentType(XML_BASE_CONTENT_TYPE);
        }
        catch (ParseException e) {
            Object[] args = new Object[]{XML_BASE_CONTENT_TYPE};
            throw new XTSInstructionException("protocol.invalidcontenttype", args, e);
        }
    }
}

