/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.request;

import com.cognos.xts.interpreter.instructions.request.AXTSUrlRequest;
import com.cognos.xts.interpreter.instructions.request.IXTSRequestInstruction;
import com.cognos.xts.util.ReaderInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public class XTSPostRequest
extends AXTSUrlRequest
implements IXTSRequestInstruction {
    @Override
    protected String prepareUrl(String prefix, String query) {
        return prefix;
    }

    @Override
    protected HttpMethod createConnectionMethod(String uri, String path) {
        PostMethod connMethod = null;
        if (uri != null) {
            connMethod = new PostMethod(uri);
        } else {
            connMethod = new PostMethod();
            connMethod.setPath(path);
        }
        return connMethod;
    }

    @Override
    protected void prepareConnectionMethod(HttpMethod connMethod, String query, Map headerMap, Reader body) {
        PostMethod postMethod = (PostMethod)connMethod;
        String contentType = (String)headerMap.get("Content-Type");
        if (postMethod.getRequestHeader("Content-Type") == null) {
            postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        }
        String mediaType = XTSPostRequest.getMimeType(contentType);
        if (body != null && mediaType != null && (mediaType.endsWith("/xml") || mediaType.endsWith("+xml"))) {
            postMethod.setQueryString(query);
            try {
                postMethod.setRequestBody((InputStream)new ReaderInputStream(body, XTSPostRequest.getCharset(contentType)));
            }
            catch (UnsupportedEncodingException e) {
                postMethod.setRequestBody((InputStream)new ReaderInputStream(body));
            }
        } else if (query != null) {
            postMethod.setRequestBody(query);
        }
    }
}

