/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.request;

import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.request.AXTSUrlRequest;
import com.cognos.xts.interpreter.instructions.request.IXTSRequestInstruction;
import com.cognos.xts.util.ReaderInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PutMethod;

public class XTSPutRequest
extends AXTSUrlRequest
implements IXTSRequestInstruction {
    @Override
    protected String prepareUrl(String prefix, String query) {
        return prefix;
    }

    @Override
    protected HttpMethod createConnectionMethod(String uri, String path) {
        PutMethod connMethod = null;
        if (uri != null) {
            connMethod = new PutMethod(uri);
        } else {
            connMethod = new PutMethod();
            connMethod.setPath(path);
        }
        return connMethod;
    }

    @Override
    protected void prepareConnectionMethod(HttpMethod connMethod, String query, Map headerMap, Reader body) throws XTSInstructionException {
        PutMethod putMethod = (PutMethod)connMethod;
        String contentType = (String)headerMap.get("Content-Type");
        if (contentType == null) {
            throw new XTSInstructionException("protocol.urlsubmiterror");
        }
        String mediaType = XTSPutRequest.getMimeType(contentType);
        if (body != null && mediaType != null && (mediaType.endsWith("/xml") || mediaType.endsWith("+xml"))) {
            putMethod.setQueryString(query);
            try {
                putMethod.setRequestBody((InputStream)new ReaderInputStream(body, XTSPutRequest.getCharset(contentType)));
            }
            catch (UnsupportedEncodingException e) {
                putMethod.setRequestBody((InputStream)new ReaderInputStream(body));
            }
        } else if (query != null) {
            putMethod.setRequestBody(query);
        }
    }
}

