/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.request;

import com.cognos.xts.XTSException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXReaderPool;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.util.soaputil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Locale;
import org.dom4j.Branch;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public class XTSSoapFaultException
extends XTSInstructionException {
    private Reader m_faultReader;
    private Reader m_hdrReader;
    private boolean m_includeEnvelope = false;
    private int m_soapVer;

    public int getSoapVersion() {
        return this.m_soapVer;
    }

    public Reader getFaultReader() {
        return this.m_faultReader;
    }

    public Reader getFaultReaderCopy() {
        StringReader faultReader = null;
        if (this.m_faultReader != null) {
            StringBuffer buf = new StringBuffer();
            try {
                this.m_faultReader = UXTSInstructionUtils.copyReader(this.m_faultReader, buf);
                faultReader = new StringReader(buf.toString());
            }
            catch (IOException e) {
                return null;
            }
        }
        return faultReader;
    }

    public Reader getHdrReader() {
        return this.m_hdrReader;
    }

    public Reader getHdrReaderCopy() {
        StringReader hdrReader = null;
        if (this.m_hdrReader != null) {
            StringBuffer buf = new StringBuffer();
            try {
                this.m_hdrReader = UXTSInstructionUtils.copyReader(this.m_hdrReader, buf);
                hdrReader = new StringReader(buf.toString());
            }
            catch (IOException e) {
                return null;
            }
        }
        return hdrReader;
    }

    public XTSSoapFaultException(String key, Reader faultReader, Reader hdrReader, int soapVer, boolean includeEnvelope) {
        super(key);
        this.m_faultReader = faultReader;
        this.m_hdrReader = hdrReader;
        this.m_soapVer = soapVer;
        this.m_includeEnvelope = includeEnvelope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getSoapEnvElementCopy(Locale locale, int soapVer) {
        AXTSPoolObject reader = null;
        try {
            reader = XTSSAXReaderPool.getInstance().acquire();
        }
        catch (XTSException e) {
            return null;
        }
        try {
            Element envEle = DocumentHelper.createElement((QName)soaputil.getSOAPEnvelopeQName(soapVer));
            Reader hdrReaderCopy = this.getHdrReaderCopy();
            if (hdrReaderCopy != null) {
                Element hdrEle = ((SAXReader)reader.get()).read(new InputSource(this.getHdrReaderCopy())).getRootElement();
                hdrEle.detach();
                envEle.add(hdrEle);
            }
            Element bodyEle = DocumentHelper.createElement((QName)soaputil.getSOAPBodyQName(soapVer));
            Element faultEle = ((SAXReader)reader.get()).read(new InputSource(this.getFaultReaderCopy())).getRootElement();
            faultEle.detach();
            envEle.add(bodyEle);
            bodyEle.add(faultEle);
            Element element = envEle;
            return element;
        }
        catch (DocumentException e) {
            Element element = null;
            return element;
        }
        finally {
            XTSSAXReaderPool.getInstance().put(reader);
        }
    }

    public StringBuffer getSoapEnvStringBufferCopy() {
        Element envEle = this.getSoapEnvElementCopy(Locale.getDefault(), this.m_soapVer);
        if (envEle != null) {
            return new StringBuffer(envEle.asXML());
        }
        return null;
    }

    public Reader getSoapEnvReaderCopy() {
        Element envEle = this.getSoapEnvElementCopy(Locale.getDefault(), this.m_soapVer);
        if (envEle != null) {
            return new StringReader(envEle.asXML());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getFaultXML(Locale locale, boolean stackdump) {
        Element exceptionElement = DocumentHelper.createElement((QName)EXCEPTION_QNAME);
        AXTSPoolObject reader = null;
        try {
            reader = XTSSAXReaderPool.getInstance().acquire();
        }
        catch (XTSException e) {
            return exceptionElement;
        }
        try {
            String sFaultString;
            String sFaultCode;
            Element faultEle = ((SAXReader)reader.get()).read(new InputSource(this.getFaultReaderCopy())).getRootElement();
            Element excpetionCodeElement = DocumentHelper.createElement((QName)EXCEPTIONCODE_QNAME);
            Element soapFaultCodeEle = faultEle.element("faultcode");
            if (soapFaultCodeEle != null && (sFaultCode = soapFaultCodeEle.getText()) != null) {
                excpetionCodeElement.addText(sFaultCode);
            }
            exceptionElement.add(excpetionCodeElement);
            Element excpetionMsgElement = DocumentHelper.createElement((QName)EXCEPTIONMSG_QNAME);
            Element soapFaultStringEle = faultEle.element("faultstring");
            if (soapFaultStringEle != null && (sFaultString = soapFaultStringEle.getText()) != null) {
                excpetionMsgElement.addText(sFaultString);
            }
            exceptionElement.add(excpetionMsgElement);
            Element excpetionDetailElement = DocumentHelper.createElement((QName)EXCEPTIONDETAIL_QNAME);
            Element faultDetailEle = faultEle.element("detail");
            if (faultDetailEle != null) {
                excpetionDetailElement.appendContent((Branch)faultDetailEle);
            }
            if (this.m_includeEnvelope) {
                excpetionDetailElement.add(this.getSoapEnvElementCopy(Locale.getDefault(), this.m_soapVer));
            }
            exceptionElement.add(excpetionDetailElement);
        }
        catch (DocumentException documentException) {
        }
        finally {
            XTSSAXReaderPool.getInstance().put(reader);
        }
        return exceptionElement;
    }
}

