/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.request;

import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.http.httpclient.MsgBodyGenerator;
import com.cognos.pogo.transport.DispatcherConnectionManager;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.XTSProcessor;
import com.cognos.xts.application.XTSApplicationManager;
import com.cognos.xts.application.XTSInterface;
import com.cognos.xts.application.XTSInterfaceInfo;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXReaderPool;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.request.IXTSRequestInstruction;
import com.cognos.xts.interpreter.instructions.request.XTSHttpClientSoapResult;
import com.cognos.xts.interpreter.instructions.request.XTSInternalSoapResult;
import com.cognos.xts.interpreter.instructions.request.XTSSoapResult;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSPerfLoggerManager;
import com.cognos.xts.output.XTSConstants;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.util.ByteArrayIOStream;
import com.cognos.xts.util.soaputil;
import com.cognos.xts.util.xmlutil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public final class XTSSoapRequest
extends AXTSInstruction
implements IXTSRequestInstruction {
    private static final String INTERFACE_IDENTIFIER = "interface://";
    private static final String BUS_IDENTIFIER = "bus://";
    private static final String HEADER_IDENTIFIER = "header";
    private static final int ENVELOPE_BUFFER_SIZE = 4096;
    private static final int ENVELOPE_READ_SIZE = 1024;
    private String m_sIdentifier = null;
    private static final String BIBUS_DISPATCHER = "dispatcher";
    private String m_dispatcherURL = null;

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
        this.m_dispatcherURL = PropertiesManager.getInstance().getProperty("dispatcher.url");
    }

    @Override
    public void terminate() throws XTSInstructionException {
    }

    @Override
    public boolean isInitialized() {
        return this.m_sIdentifier != null;
    }

    @Override
    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        String target = (String)instAtts.get("target");
        if (target == null || target.length() == 0) {
            throw new XTSInstructionException("protocol.missingtarget");
        }
        boolean includeEnvelope = false;
        String responseEnvelope = UXTSInstructionUtils.getParameter("responseEnvelope", instParams);
        if (responseEnvelope != null && responseEnvelope.equals("true")) {
            includeEnvelope = true;
        }
        IXTSInstructionResult result = null;
        if (target.startsWith(INTERFACE_IDENTIFIER)) {
            result = this.sendInternalEnvelope(env, body, target, instParams, includeEnvelope);
        } else if (target.startsWith(BUS_IDENTIFIER)) {
            target = this.m_dispatcherURL + "/" + target.substring(BUS_IDENTIFIER.length());
            result = this.sendInternalBusEnvelope(env, body, target, instParams, includeEnvelope);
        } else {
            result = this.sendExternalEnvelope(env, body, target, instParams, includeEnvelope);
        }
        return result;
    }

    private IXTSInstructionResult sendInternalBusEnvelope(XTSEnvironment env, final Reader envelope, String target, Map instParams, boolean includeEnvelope) throws XTSInstructionException {
        try {
            String soapAction = UXTSInstructionUtils.getParameter("soapAction", instParams);
            if (soapAction == null) {
                soapAction = "";
            }
            ServerConnection conn = DispatcherConnectionManager.getLocalDispatcherConnection();
            conn.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
            conn.addRequestHeader("Connection", "Keep-Alive");
            conn.addRequestHeader("SOAPAction", soapAction);
            String cookieHeader = UXTSInstructionUtils.getParameter("Cookie", instParams);
            if (cookieHeader != null) {
                conn.addRequestHeader("Cookie", cookieHeader);
            }
            String name = null;
            String[] values = null;
            Map.Entry pair2 = null;
            String headerValue = null;
            for (Map.Entry pair2 : instParams.entrySet()) {
                name = (String)pair2.getKey();
                values = (String[])pair2.getValue();
                if (!name.equals(HEADER_IDENTIFIER) || values == null) continue;
                for (int i = 0; i < values.length; ++i) {
                    headerValue = values[i];
                    int equalpos = headerValue.indexOf("=");
                    if (equalpos == -1) {
                        Object[] args = new String[]{this.getIdentifier()};
                        throw new XTSInstructionException("protocol.url.invalidheadersyntax", args);
                    }
                    conn.addRequestHeader(headerValue.substring(0, equalpos), headerValue.substring(equalpos + 1));
                }
            }
            conn.setRequestBodySource(new MsgBodyGenerator(){

                public boolean rewind() {
                    return false;
                }

                public void writeBody(OutputStream os) throws IOException {
                    os.write(xmlutil.m_defaultXMLHeaderByte);
                    os.flush();
                    BufferedWriter bufWriter = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
                    char[] buf = new char[1024];
                    int bytesRead = envelope.read(buf, 0, 1024);
                    while (bytesRead != -1) {
                        bufWriter.write(buf, 0, bytesRead);
                        bytesRead = envelope.read(buf, 0, 1024);
                    }
                    bufWriter.flush();
                }
            });
            conn.sendRequest(target);
            return new XTSHttpClientSoapResult(env, conn, includeEnvelope);
        }
        catch (IOException e) {
            throw new XTSInstructionException("protocol.bibusrequestfailed", e);
        }
    }

    private IXTSInstructionResult sendExternalEnvelope(XTSEnvironment env, Reader envelope, String target, Map instParams, boolean includeEnvelope) throws XTSInstructionException {
        try {
            URL url = new URL(target);
            ByteArrayIOStream bio = new ByteArrayIOStream(4096);
            BufferedWriter bufWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)bio, "UTF-8"));
            char[] buf = new char[1024];
            try {
                int bytesRead = envelope.read(buf, 0, 1024);
                while (bytesRead != -1) {
                    bufWriter.write(buf, 0, bytesRead);
                    bytesRead = envelope.read(buf, 0, 1024);
                }
                bufWriter.flush();
            }
            catch (IOException e) {
                throw new XTSInstructionException("soap.ioexception", e);
            }
            byte[] msghdr = xmlutil.m_defaultXMLHeaderByte;
            byte[] msg = bio.toByteArray();
            int msgsize = msghdr.length + msg.length;
            String soapAction = UXTSInstructionUtils.getParameter("soapAction", instParams);
            if (soapAction == null) {
                soapAction = "";
            }
            String SOAPAction = "\"" + soapAction + "\"";
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setUseCaches(true);
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
            con.setRequestProperty("Content-Length", Integer.toString(msgsize));
            con.setRequestProperty("SOAPAction", SOAPAction);
            String cookieHeader = UXTSInstructionUtils.getParameter("Cookie", instParams);
            if (cookieHeader != null) {
                con.setRequestProperty("Cookie", cookieHeader);
            }
            String name = null;
            String[] values = null;
            Map.Entry pair2 = null;
            String headerValue = null;
            for (Map.Entry pair2 : instParams.entrySet()) {
                name = (String)pair2.getKey();
                values = (String[])pair2.getValue();
                if (!name.equals(HEADER_IDENTIFIER) || values == null) continue;
                for (int i = 0; i < values.length; ++i) {
                    headerValue = values[i];
                    int equalpos = headerValue.indexOf("=");
                    if (equalpos == -1) {
                        Object[] args = new String[]{this.getIdentifier()};
                        throw new XTSInstructionException("protocol.url.invalidheadersyntax", args);
                    }
                    con.setRequestProperty(headerValue.substring(0, equalpos), headerValue.substring(equalpos + 1));
                }
            }
            con.connect();
            OutputStream output = con.getOutputStream();
            output.write(msghdr);
            output.write(msg);
            output.close();
            return new XTSSoapResult(env, con, includeEnvelope);
        }
        catch (MalformedURLException e) {
            Object[] args = new String[]{target};
            throw new XTSInstructionException("protocol.invalidurl", args);
        }
        catch (IOException e) {
            throw new XTSInstructionException("protocol.bibusrequestfailed", e);
        }
    }

    private IXTSInstructionResult sendInternalEnvelope(XTSEnvironment env, Reader envelope, String target, Map instParams, boolean includeEnvelope) throws XTSInstructionException {
        IXTSLogger pLogger = null;
        if (XTSPerfLoggerManager.getInstance().isEnabled[1][0] && (pLogger = XTSPerfLoggerManager.getInstance().getLogger(1, 0)) != null) {
            pLogger.log(env, 2, this.getClass().getName(), "sendInternalEnvelope", "Start");
            pLogger.starttimer();
        }
        AXTSPoolObject reader = null;
        try {
            reader = XTSSAXReaderPool.getInstance().acquire();
        }
        catch (XTSException e) {
            throw new XTSInstructionException("protocol.xtsrequestfailed", e);
        }
        Element soapEnvElem = null;
        try {
            soapEnvElem = ((SAXReader)reader.get()).read(new InputSource(envelope)).getRootElement();
            soapEnvElem.detach();
        }
        catch (DocumentException e) {
            throw new XTSInstructionException("protocol.xtsrequestfailed", e);
        }
        finally {
            XTSSAXReaderPool.getInstance().put(reader);
        }
        int soapVersion = soaputil.getSOAPVersion(soapEnvElem.getNamespaceURI());
        if (soapVersion == -1 || !soapEnvElem.getName().equals("Envelope")) {
            throw new XTSInstructionException("soap.invalidenvelope");
        }
        Element soapBodyElem = soapEnvElem.element(soaputil.getSOAPBodyQName(soapVersion));
        if (soapBodyElem == null) {
            throw new XTSInstructionException("soap.missingsoapbody");
        }
        Element command = null;
        Iterator it = soapBodyElem.elementIterator();
        if (!it.hasNext()) {
            throw new XTSInstructionException("soap.emptysoapbody");
        }
        command = (Element)it.next();
        Element rootElem = DocumentHelper.createElement((String)"root");
        String cookieHeader = UXTSInstructionUtils.getParameter("Cookie", instParams);
        if (cookieHeader != null) {
            Element cookiesElem = DocumentHelper.createElement((String)"cookies");
            rootElem.add(cookiesElem);
            StringTokenizer cookieTokens = new StringTokenizer(cookieHeader, ";");
            while (cookieTokens.hasMoreTokens()) {
                String cookieToken = cookieTokens.nextToken();
                int equalpos = cookieToken.indexOf("=");
                if (equalpos == -1) continue;
                Element cookieElem = DocumentHelper.createElement((String)"cookie");
                cookieElem.addAttribute("name", cookieToken.substring(0, equalpos));
                cookieElem.setText(cookieToken.substring(equalpos + 1));
                cookiesElem.add(cookieElem);
            }
        }
        Element httpElem = DocumentHelper.createElement((String)"http");
        rootElem.add(httpElem);
        String name = null;
        String[] values = null;
        Map.Entry pair2 = null;
        Element paramElem = null;
        String headerValue = null;
        for (Map.Entry pair2 : instParams.entrySet()) {
            name = (String)pair2.getKey();
            values = (String[])pair2.getValue();
            if (!name.equals(HEADER_IDENTIFIER) || values == null) continue;
            for (int i = 0; i < values.length; ++i) {
                headerValue = values[i];
                int equalpos = headerValue.indexOf("=");
                if (equalpos == -1) {
                    Object[] args = new String[]{this.getIdentifier()};
                    throw new XTSInstructionException("protocol.url.invalidheadersyntax", args);
                }
                paramElem = DocumentHelper.createElement((String)"param");
                paramElem.addAttribute("name", headerValue.substring(0, equalpos));
                paramElem.setText(headerValue.substring(equalpos + 1));
                httpElem.add(paramElem);
            }
        }
        Element envelopeElem = DocumentHelper.createElement((String)"envelope");
        envelopeElem.add(soapEnvElem);
        rootElem.add(envelopeElem);
        Element protocolHeaderElement = DocumentHelper.createElement((QName)XTSConstants.ELEM_NM_PROTOCOLHEADER);
        Element outputElement = DocumentHelper.createElement((String)"output");
        outputElement.add(protocolHeaderElement);
        rootElem.add(outputElement);
        String targetMorphlet = this.addAdditionalInputXML(target, command, rootElem);
        XTSEnvironment requestEnv = new XTSEnvironment(env.getCallerID());
        requestEnv.setUserCapabilities(env.getUserCapabilities());
        requestEnv.setLocale(env.getLocale());
        requestEnv.setLookupList(env.getLookupList());
        requestEnv.setMorphletName(targetMorphlet);
        requestEnv.setMode(env.getMode() & 0xFFFFFFFB);
        Document inputDoc = DocumentHelper.createDocument((Element)rootElem);
        if (XTSPerfLoggerManager.getInstance().isEnabled[1][0]) {
            requestEnv.setRequestContext(env.getRequestContext());
            requestEnv.setSessionContext(env.getSessionContext());
        }
        try {
            XTSProcessor.getInstance(env.getCallerID()).execute(targetMorphlet, inputDoc, requestEnv);
        }
        catch (XTSException e) {
            Object[] args = new String[]{this.getIdentifier()};
            throw new XTSInstructionException("protocol.xts.requestfailed", args, e);
        }
        if (pLogger != null) {
            pLogger.stoptimer();
            pLogger.log(env, 3, this.getClass().getName(), "sendInternalEnvelope", "End");
            pLogger = null;
        }
        return new XTSInternalSoapResult(requestEnv, inputDoc, includeEnvelope);
    }

    private String addAdditionalInputXML(String targetInterface, Element command, Element rootElem) throws XTSInstructionException {
        Element processingElement;
        XTSInterface iface;
        Object[] args;
        List iInfoList;
        String targetMorphlet = null;
        String path = targetInterface.substring(INTERFACE_IDENTIFIER.length());
        if (path == null) {
            path = "/";
        } else {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
        }
        XTSInterfaceInfo iInfo = null;
        String op = command.getName();
        String ns = command.getNamespaceURI();
        if (op != null && op.length() > 0 && ns != null && ns.length() > 0 && (iInfo = XTSInterfaceInfo.searchInterfaceInfo(path, ns, op)) != null) {
            Element ifaceRootElem = rootElem.addElement("interfaces");
            ifaceRootElem.add(iInfo.toElement());
        }
        if (iInfo == null && (iInfoList = XTSInterfaceInfo.searchInterfaceInfo(path)).size() > 0) {
            iInfo = (XTSInterfaceInfo)iInfoList.get(0);
            Element ifaceRootElem = rootElem.addElement("interfaces");
            for (int i = 0; i < iInfoList.size(); ++i) {
                XTSInterfaceInfo info = (XTSInterfaceInfo)iInfoList.get(i);
                ifaceRootElem.add(info.toElement());
            }
        }
        if (iInfo == null) {
            args = new String[]{this.getIdentifier(), "", path};
            throw new XTSInstructionException("protocol.xts.invalidinterfacename", args);
        }
        targetMorphlet = iInfo.getMorphlet();
        if (targetMorphlet == null) {
            args = new String[]{this.getIdentifier(), "", path};
            throw new XTSInstructionException("protocol.xts.invalidinterfacename", args);
        }
        Element systemElement = XTSApplicationManager.getInstance().searchSystemOptions(targetMorphlet);
        if (systemElement != null) {
            rootElem.add(systemElement);
        }
        if ((iface = iInfo.getXTSInterface()) != null && (processingElement = iface.getProcessingOptions()) != null) {
            rootElem.add(processingElement);
        }
        return targetMorphlet;
    }
}

