/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.request;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.interpreter.instructions.IXTSOutputableInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.XTSSource;
import com.cognos.xts.interpreter.instructions.request.XTSHttpResponseException;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.output.XTSOutputSpecUtils;
import com.cognos.xts.util.ByteArrayIOStream;
import com.cognos.xts.util.SizeLimitedInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.ParseException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.methods.HeadMethod;

public class XTSUrlResult
implements IXTSOutputableInstructionResult {
    private static final String XML_BASE_CONTENT_TYPE = "text/xml; charset=utf-8";
    private static final String ATT_VL_PARAM_STATUSCODE = "statusCode";
    private static final String ATT_VL_PARAM_STATUSTEXT = "statusText";
    private static final String ATT_VL_PARAM_HTTPVERSION = "httpVersion";
    private HttpMethod m_connMethod = null;
    private InputStream m_stream = null;
    private ContentType m_contentType = null;
    private int m_statusCode = 0;

    public XTSUrlResult(XTSEnvironment env, HttpMethod connMethod, long sizeLimitValue) throws XTSInstructionException {
        this.m_connMethod = connMethod;
        String contentType = null;
        try {
            this.m_statusCode = connMethod.getStatusCode();
            if (this.m_statusCode >= 400) {
                if (XTSTraceLoggerManager.getInstance().isEnabled[2][0]) {
                    StringBuffer msg = new StringBuffer();
                    msg.append("URL request ... ").append(connMethod.getURI()).append("  \n");
                    msg.append("URL response status = ").append(this.m_statusCode).append(" - ").append(connMethod.getStatusText()).append("\n");
                    IXTSLogger logger = XTSTraceLoggerManager.getInstance().getLogger(2, 0);
                    if (logger != null) {
                        logger.log(env, 8, msg.toString(), null, null);
                    }
                }
                String responseMessage = connMethod.getStatusText();
                this.m_stream = this.m_connMethod.getResponseBodyAsStream();
                HashMap<String, String> responseHeaders = new HashMap<String, String>();
                Header[] headers = this.m_connMethod.getResponseHeaders();
                for (int i = 0; i < headers.length; ++i) {
                    String key = headers[i].getName();
                    String keyValue = headers[i].getValue();
                    responseHeaders.put(key, keyValue);
                }
                StringBuffer payLoad = new StringBuffer();
                if (this.m_stream != null) {
                    byte[] buf = new byte[4096];
                    int bytesRead = this.m_stream.read(buf, 0, 4096);
                    while (bytesRead != -1) {
                        payLoad.append(new String(buf, 0, bytesRead));
                        bytesRead = this.m_stream.read(buf, 0, 4096);
                    }
                }
                if ((contentType = this.getContentType(this.m_connMethod)) != null) {
                    this.m_contentType = new ContentType(contentType);
                }
                boolean parseResponseBody = this.m_contentType != null && this.m_contentType.getBaseType().equals("text/xml");
                this.release();
                throw new XTSHttpResponseException("protocol.url.httpresponseerror", this.m_statusCode, responseMessage, payLoad.toString(), parseResponseBody, responseHeaders);
            }
            if (XTSTraceLoggerManager.getInstance().isEnabled[3][0]) {
                StringBuffer msg = new StringBuffer();
                msg.append("URL request ... ").append(connMethod.getURI()).append("  \n");
                msg.append("URL response status = ").append(this.m_statusCode).append(" - ").append(connMethod.getStatusText()).append("\n");
                IXTSLogger logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0);
                if (logger != null) {
                    logger.log(env, 8, msg.toString(), null, null);
                }
            }
            if ((contentType = this.getContentType(this.m_connMethod)) != null) {
                this.m_contentType = new ContentType(contentType);
            }
            this.m_stream = this.m_connMethod.getResponseBodyAsStream();
            if (this.m_stream == null && (this.m_statusCode > 200 || this.m_statusCode == 200 && this.m_connMethod instanceof HeadMethod)) {
                byte[] buf = new byte[]{};
                this.m_stream = new ByteArrayInputStream(buf);
            }
            this.m_stream = new BufferedInputStream(this.m_stream);
            String contentLengthText = this.getHeaderValue(this.m_connMethod, "Content-Length");
            int contentLength = -1;
            if (contentLengthText != null) {
                try {
                    contentLength = Integer.parseInt(contentLengthText);
                }
                catch (NumberFormatException e) {
                    contentLength = -1;
                }
            }
            if (sizeLimitValue > 0L) {
                if ((long)contentLength > sizeLimitValue) {
                    throw new XTSInstructionException("util.streamsizelimit");
                }
                this.m_stream = new SizeLimitedInputStream(this.m_stream, sizeLimitValue);
            }
        }
        catch (ParseException e) {
            Object[] args = new Object[]{contentType};
            throw new XTSInstructionException("protocol.invalidcontenttype", args, e);
        }
        catch (IOException e) {
            throw new XTSInstructionException("protocol.ioexception", e);
        }
    }

    @Override
    public XTSSource getResult() throws XTSInstructionException {
        return new XTSSource(this.m_stream);
    }

    @Override
    public void release() throws XTSInstructionException {
        this.m_connMethod.releaseConnection();
        try {
            if (this.m_stream != null) {
                this.m_stream.close();
                this.m_stream = null;
            }
        }
        catch (IOException e) {
            throw new XTSInstructionException("protocol.ioexception", e);
        }
    }

    @Override
    public void writeCopyTo(OutputStream out) throws XTSInstructionException {
        ByteArrayIOStream bio = null;
        try {
            bio = new ByteArrayIOStream();
            byte[] buf = new byte[4096];
            int bytesRead = this.m_stream.read(buf, 0, 4096);
            while (bytesRead != -1) {
                bio.write(buf, 0, bytesRead);
                bytesRead = this.m_stream.read(buf, 0, 4096);
            }
            bio.writeTo(out);
            this.m_stream = bio.convert();
        }
        catch (Exception e) {
            if (bio != null) {
                this.m_stream = bio.convert();
            }
            Object[] args = new String[]{this.getClass().getName()};
            throw new XTSInstructionException("instruction.writetooutputstreamfailed", args, e);
        }
    }

    @Override
    public boolean attachmentsSupported() {
        return false;
    }

    @Override
    public int getSupportedOptionsBitMap() {
        return 7;
    }

    @Override
    public boolean statusHeaderSupported() {
        return true;
    }

    @Override
    public boolean protocolHeaderSupported() {
        return true;
    }

    @Override
    public InputStream getAttachmentInputStream() throws XTSInstructionException {
        return null;
    }

    @Override
    public InternetHeaders getStatusHeaders() throws XTSInstructionException {
        InternetHeaders iHdrs = new InternetHeaders();
        if (this.m_connMethod != null) {
            iHdrs.addHeader(ATT_VL_PARAM_STATUSCODE, Integer.toString(this.m_statusCode));
            iHdrs.addHeader(ATT_VL_PARAM_STATUSTEXT, this.m_connMethod.getStatusText());
            StatusLine stat = this.m_connMethod.getStatusLine();
            if (stat != null) {
                iHdrs.addHeader(ATT_VL_PARAM_HTTPVERSION, stat.getHttpVersion());
            }
        }
        return iHdrs;
    }

    @Override
    public InternetHeaders getProtocolHeaders() throws XTSInstructionException {
        InternetHeaders iHdrs = new InternetHeaders();
        Header[] headers = this.m_connMethod.getResponseHeaders();
        for (int i = 0; i < headers.length; ++i) {
            String key = headers[i].getName();
            String keyValue = headers[i].getValue();
            if (key == null || XTSOutputSpecUtils.isMimeHeader(key)) continue;
            iHdrs.addHeader(key, keyValue);
        }
        return iHdrs;
    }

    @Override
    public ContentType getDefaultMimeType() throws XTSInstructionException {
        if (this.m_contentType == null) {
            try {
                this.m_contentType = new ContentType(XML_BASE_CONTENT_TYPE);
            }
            catch (ParseException e) {
                Object[] args = new Object[]{XML_BASE_CONTENT_TYPE};
                throw new XTSInstructionException("protocol.invalidcontenttype", args, e);
            }
        }
        return this.m_contentType;
    }

    private String getHeaderValue(HttpMethod connMethod, String headerName) {
        Header header = connMethod.getResponseHeader(headerName);
        return header == null ? null : header.getValue().trim();
    }

    private String getContentType(HttpMethod connMethod) {
        String contentType = this.getHeaderValue(connMethod, "Content-Type");
        try {
            HeaderElement[] values = HeaderElement.parse((String)contentType);
            if (values != null && values.length > 1) {
                NameValuePair[] parameters = values[0].getParameters();
                StringBuffer parsedContentType = new StringBuffer();
                parsedContentType.append(values[0].getName());
                for (int i = 0; i < parameters.length; ++i) {
                    parsedContentType.append(";").append(parameters[i].getName());
                    String paramValue = parameters[i].getValue();
                    if (paramValue == null) continue;
                    parsedContentType.append("=").append(paramValue);
                }
                return parsedContentType.toString();
            }
        }
        catch (HttpException httpException) {
            // empty catch block
        }
        return contentType;
    }
}

