/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.request;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXReaderPool;
import com.cognos.xts.interpreter.instructions.IXTSOutputableInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.XTSSource;
import com.cognos.xts.output.XTSConstants;
import com.cognos.xts.output.XTSOutputObject;
import com.cognos.xts.output.XTSOutputSpecUtils;
import com.cognos.xts.util.ByteArrayIOStream;
import com.cognos.xts.util.soaputil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.ParseException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public final class XTSXtsBusResult
implements IXTSOutputableInstructionResult {
    private static final String XML_BASE_CONTENT_TYPE = "text/xml; charset=utf-8";
    private ContentType m_contentType = null;
    private Reader m_soapEnvReader = null;
    private Document m_resultDoc = null;
    private boolean m_bSeparateSoapHeader = false;
    private Reader m_soapHdrReader = null;
    private InputStream m_soapAttIn = null;
    private XTSEnvironment m_requestEnv = null;
    private InternetHeaders m_protocolHdrs = null;
    private List m_cleanUpObjList = null;

    private XTSXtsBusResult() {
    }

    public XTSXtsBusResult(XTSEnvironment requestEnv, Document resultDoc, int soapVersion, boolean includeEnvelope, boolean separateSoapHeader) throws XTSInstructionException {
        Element paramElem2;
        Element protocolHeaderElem;
        List paramElemList;
        Element setSoapHeaderParamElem;
        List setSoapHdrParamList;
        this.m_requestEnv = requestEnv;
        this.m_resultDoc = resultDoc;
        Element outputElement = resultDoc.getRootElement().element("output");
        Element partElem = null;
        List partElemList = outputElement.elements(XTSConstants.ELEM_NM_PART);
        if (partElemList.size() > 0) {
            partElem = (Element)partElemList.get(0);
        }
        Element soapHdrElem = null;
        if ((separateSoapHeader || includeEnvelope) && (setSoapHdrParamList = XTSConstants.getProtocolHeaderParamSetSoapHeaderList(outputElement)).size() > 0 && (soapHdrElem = (setSoapHeaderParamElem = (Element)setSoapHdrParamList.get(0)).element("Header")) != null) {
            soapHdrElem.detach();
        }
        if (separateSoapHeader && soapHdrElem != null) {
            this.m_soapHdrReader = new StringReader(soapHdrElem.asXML());
        }
        if (partElem == null) {
            if (!includeEnvelope) {
                this.m_soapEnvReader = new StringReader(new String(""));
            } else {
                if (soapHdrElem == null) {
                    soapHdrElem = soaputil.createSOAPHeader(soapVersion);
                }
                Element soapBodyElem = soaputil.createSOAPBody(soapVersion);
                Element soapEnvElem = soaputil.createSOAPEnvelope(soapVersion, soapBodyElem, soapHdrElem);
                this.m_soapEnvReader = new StringReader(soapEnvElem.asXML());
            }
            return;
        }
        String sContentType = null;
        Element ctEle = XTSConstants.getEntityHeaderParamContentTypeElement(partElem);
        if (ctEle != null) {
            sContentType = ctEle.getTextTrim();
        }
        if (sContentType == null || sContentType.length() == 0) {
            sContentType = XML_BASE_CONTENT_TYPE;
        }
        ContentType contentType = null;
        try {
            contentType = new ContentType(sContentType);
        }
        catch (ParseException e) {
            Object[] args = new String[]{sContentType, "part"};
            throw new XTSInstructionException("protocol.bus.invalidcontenttype", args, e);
        }
        boolean bPartInlined = false;
        Element rootele = null;
        if (contentType != null && contentType.getBaseType().equals("text/xml")) {
            if (this.m_cleanUpObjList == null) {
                this.m_cleanUpObjList = new ArrayList();
            }
            AXTSPoolObject reader = null;
            try {
                reader = XTSSAXReaderPool.getInstance().acquire();
            }
            catch (XTSException e) {
                throw new XTSInstructionException("request.parseoutputfailed", e);
            }
            try {
                Document doc = ((SAXReader)reader.get()).read(XTSOutputSpecUtils.generateInputStream(this.m_requestEnv, partElem, false, this.m_cleanUpObjList, null));
                rootele = doc.getRootElement();
                rootele.detach();
            }
            catch (Exception e) {
                throw new XTSInstructionException("request.parseoutputfailed", e);
            }
            finally {
                XTSSAXReaderPool.getInstance().put(reader);
            }
            bPartInlined = true;
        }
        if (!includeEnvelope) {
            this.m_soapEnvReader = rootele == null ? new StringReader(new String("")) : new StringReader(rootele.asXML());
        } else {
            if (soapHdrElem == null) {
                soapHdrElem = soaputil.createSOAPHeader(soapVersion);
            }
            Element soapBodyElem = soaputil.createSOAPBody(soapVersion);
            if (rootele != null) {
                soapBodyElem.add(rootele);
            }
            Element soapEnvElem = soaputil.createSOAPEnvelope(soapVersion, soapBodyElem, soapHdrElem);
            this.m_soapEnvReader = new StringReader(soapEnvElem.asXML());
        }
        List protocolHeaderElemList = outputElement.elements(XTSConstants.ELEM_NM_PROTOCOLHEADER);
        if (protocolHeaderElemList.size() > 0 && (paramElemList = (protocolHeaderElem = (Element)protocolHeaderElemList.get(0)).elements(XTSConstants.ELEM_NM_PARAM)).size() > 0) {
            this.m_protocolHdrs = new InternetHeaders();
            paramElem2 = null;
            for (Element paramElem2 : paramElemList) {
                this.m_protocolHdrs.addHeader(paramElem2.attributeValue("name"), paramElem2.getTextTrim());
            }
        }
        if (!bPartInlined) {
            if (this.m_cleanUpObjList == null) {
                this.m_cleanUpObjList = new ArrayList();
            }
            try {
                Element entityHeaderElem;
                if (partElem != null && this.m_protocolHdrs == null && (entityHeaderElem = partElem.element(XTSConstants.ELEM_NM_ENTITYHEADER)) != null && (paramElemList = entityHeaderElem.elements(XTSConstants.ELEM_NM_PARAM)).size() > 0) {
                    this.m_protocolHdrs = new InternetHeaders();
                    paramElem2 = null;
                    for (Element paramElem2 : paramElemList) {
                        this.m_protocolHdrs.addHeader(paramElem2.attributeValue("name"), paramElem2.getTextTrim());
                    }
                }
                this.m_soapAttIn = XTSOutputSpecUtils.generateInputStream(this.m_requestEnv, partElem, false, this.m_cleanUpObjList, null);
            }
            catch (XTSException e) {
                throw new XTSInstructionException("request.parseoutputfailed", e);
            }
        }
        if (partElemList.size() > 1) {
            try {
                this.m_soapAttIn = XTSOutputSpecUtils.generateInputStream(this.m_requestEnv, (Element)partElemList.get(1), true, this.m_cleanUpObjList, null);
            }
            catch (XTSException e) {
                throw new XTSInstructionException("request.parseoutputfailed", e);
            }
        }
    }

    @Override
    public XTSSource getResult() throws XTSInstructionException {
        return new XTSSource(this.m_soapEnvReader);
    }

    @Override
    public void release() throws XTSInstructionException {
        this.m_requestEnv.cleanup();
        if (this.m_cleanUpObjList != null) {
            for (XTSOutputObject outputObj : this.m_cleanUpObjList) {
                outputObj.release();
                Object var2_3 = null;
            }
            this.m_cleanUpObjList.clear();
        }
        try {
            if (this.m_soapEnvReader != null) {
                this.m_soapEnvReader.close();
                this.m_soapEnvReader = null;
            }
            if (this.m_soapAttIn != null) {
                this.m_soapAttIn.close();
                this.m_soapAttIn = null;
            }
            if (this.m_soapHdrReader != null) {
                this.m_soapHdrReader.close();
                this.m_soapHdrReader = null;
            }
        }
        catch (IOException e) {
            throw new XTSInstructionException("protocol.ioexception", e);
        }
    }

    public Reader getSOAPHeader() {
        return this.m_soapHdrReader;
    }

    @Override
    public void writeCopyTo(OutputStream out) throws XTSInstructionException {
        try {
            ByteArrayIOStream bio = new ByteArrayIOStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)bio, "UTF-8"));
            char[] buf = new char[4096];
            int bytesRead = this.m_soapEnvReader.read(buf, 0, 4096);
            while (bytesRead != -1) {
                ((Writer)writer).write(buf, 0, bytesRead);
                bytesRead = this.m_soapEnvReader.read(buf, 0, 4096);
            }
            ((Writer)writer).flush();
            bio.writeTo(out);
            this.m_soapEnvReader = new BufferedReader(new InputStreamReader((InputStream)bio.convert(), "UTF-8"));
        }
        catch (IOException e) {
            Object[] args = new String[]{this.getClass().getName()};
            throw new XTSInstructionException("instruction.writetooutputstreamfailed", args, e);
        }
    }

    @Override
    public boolean attachmentsSupported() {
        return true;
    }

    @Override
    public int getSupportedOptionsBitMap() {
        return 31;
    }

    @Override
    public boolean statusHeaderSupported() {
        return false;
    }

    @Override
    public boolean protocolHeaderSupported() {
        return true;
    }

    @Override
    public InputStream getAttachmentInputStream() throws XTSInstructionException {
        return this.m_soapAttIn;
    }

    @Override
    public InternetHeaders getStatusHeaders() throws XTSInstructionException {
        return null;
    }

    @Override
    public InternetHeaders getProtocolHeaders() throws XTSInstructionException {
        return this.m_protocolHdrs;
    }

    @Override
    public ContentType getDefaultMimeType() throws XTSInstructionException {
        if (this.m_contentType == null) {
            try {
                this.m_contentType = new ContentType(XML_BASE_CONTENT_TYPE);
            }
            catch (ParseException e) {
                Object[] args = new Object[]{XML_BASE_CONTENT_TYPE};
                throw new XTSInstructionException("protocol.invalidcontenttype", args, e);
            }
        }
        return this.m_contentType;
    }
}

