/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.request;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.XTSProcessor;
import com.cognos.xts.application.XTSApplicationManager;
import com.cognos.xts.application.XTSInterface;
import com.cognos.xts.application.XTSInterfaceInfo;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXReaderPool;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.request.IXTSRequestInstruction;
import com.cognos.xts.interpreter.instructions.request.XTSXtsResult;
import com.cognos.xts.logging.XTSPerfLoggerManager;
import com.cognos.xts.output.XTSConstants;
import com.cognos.xts.request.XTSBusRequestUtil;
import com.cognos.xts.util.SequenceReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public final class XTSXtsRequest
extends AXTSInstruction
implements IXTSRequestInstruction {
    private static final String INTERFACE_IDENTIFIER = "interface://";
    private static final String DUMMYROOT_ELEMENT_START = "<dummyroot>";
    private static final String DUMMYROOT_ELEMENT_END = "</dummyroot>";
    private String m_sIdentifier = null;

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
    }

    @Override
    public void terminate() throws XTSInstructionException {
    }

    @Override
    public boolean isInitialized() {
        return this.m_sIdentifier != null;
    }

    @Override
    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        String target = (String)instAtts.get("target");
        if (target == null || target.length() == 0) {
            throw new XTSInstructionException("protocol.missingtarget");
        }
        Element root = DocumentHelper.createElement((String)"root");
        Element outputElement = DocumentHelper.createElement((String)"output");
        Element protocolHeaderElement = DocumentHelper.createElement((QName)XTSConstants.ELEM_NM_PROTOCOLHEADER);
        outputElement.add(protocolHeaderElement);
        root.add(outputElement);
        Document inputDoc = DocumentHelper.createDocument((Element)root);
        Element dummyRootElem = null;
        if (body != null) {
            SequenceReader readerWithFragmentSupport = new SequenceReader(new StringReader(DUMMYROOT_ELEMENT_START), body);
            readerWithFragmentSupport = new SequenceReader(readerWithFragmentSupport, new StringReader(DUMMYROOT_ELEMENT_END));
            AXTSPoolObject reader = null;
            try {
                reader = XTSSAXReaderPool.getInstance().acquire();
            }
            catch (XTSException e) {
                Object[] args = new Object[]{this.m_sIdentifier};
                throw new XTSInstructionException("protocol.xts.parsefailed", args, e);
            }
            try {
                dummyRootElem = ((SAXReader)reader.get()).read(new InputSource(readerWithFragmentSupport)).getRootElement();
            }
            catch (Exception e) {
                Object[] args = new Object[]{this.m_sIdentifier};
                throw new XTSInstructionException("protocol.xts.parsefailed", args, e);
            }
            finally {
                XTSSAXReaderPool.getInstance().put(reader);
            }
            root.appendContent((Branch)dummyRootElem);
        }
        if (target.startsWith(INTERFACE_IDENTIFIER)) {
            Element processingElement;
            XTSInterface iface;
            Object[] args;
            List iInfoList;
            Iterator it;
            String path = target.substring(INTERFACE_IDENTIFIER.length());
            if (path == null) {
                path = "/";
            } else {
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
            }
            XTSInterfaceInfo iInfo = null;
            if (dummyRootElem != null && (it = dummyRootElem.elementIterator()).hasNext()) {
                Element command = (Element)it.next();
                String operationName = command.getName();
                String namespaceURI = command.getNamespaceURI();
                if (operationName != null && operationName.length() > 0 && namespaceURI != null && namespaceURI.length() > 0 && (iInfo = XTSInterfaceInfo.searchInterfaceInfo(path, namespaceURI, operationName)) != null) {
                    Element ifaceRootElem = root.addElement("interfaces");
                    ifaceRootElem.add(iInfo.toElement());
                }
            }
            if (iInfo == null && (iInfoList = XTSInterfaceInfo.searchInterfaceInfo(path)).size() > 0) {
                iInfo = (XTSInterfaceInfo)iInfoList.get(0);
                Element ifaceRootElem = root.addElement("interfaces");
                for (int i = 0; i < iInfoList.size(); ++i) {
                    XTSInterfaceInfo info = (XTSInterfaceInfo)iInfoList.get(i);
                    ifaceRootElem.add(info.toElement());
                }
            }
            if (iInfo == null) {
                args = new String[]{this.getIdentifier(), "", path};
                throw new XTSInstructionException("protocol.xts.invalidinterfacename", args);
            }
            target = iInfo.getMorphlet();
            if (target == null) {
                args = new String[]{this.getIdentifier(), "", path};
                throw new XTSInstructionException("protocol.xts.invalidinterfacename", args);
            }
            Element systemElement = XTSApplicationManager.getInstance().searchSystemOptions(target);
            if (systemElement != null) {
                root.add(systemElement);
            }
            if ((iface = iInfo.getXTSInterface()) != null && (processingElement = iface.getProcessingOptions()) != null) {
                root.add(processingElement);
            }
        } else {
            Element processingElement;
            Element systemElement = XTSApplicationManager.getInstance().searchSystemOptions(target);
            if (systemElement != null) {
                root.add(systemElement);
            }
            if ((processingElement = XTSApplicationManager.getInstance().searchProcessingOptions(target)) != null) {
                root.add(processingElement);
            }
        }
        XTSEnvironment requestEnv = new XTSEnvironment(env.getCallerID());
        requestEnv.setUserCapabilities(env.getUserCapabilities());
        String lang = XTSBusRequestUtil.getRequestLang(inputDoc);
        Locale locale = XTSBusRequestUtil.getRequestLocale(inputDoc, lang, env.getLocale());
        requestEnv.setLocale(locale);
        requestEnv.setLookupList(XTSBusRequestUtil.getRequestLocaleLookupList(locale, lang != null && lang.length() > 0));
        requestEnv.setMorphletName(target);
        requestEnv.setMode(env.getMode() & 0xFFFFFFFB);
        if (XTSPerfLoggerManager.getInstance().isEnabled[1][0]) {
            requestEnv.setRequestContext(env.getRequestContext());
            requestEnv.setSessionContext(env.getSessionContext());
        }
        try {
            XTSProcessor.getInstance(env.getCallerID()).execute(target, inputDoc, requestEnv, true);
        }
        catch (XTSException e) {
            Object[] args = new String[]{this.getIdentifier()};
            throw new XTSInstructionException("protocol.xts.requestfailed", args, e);
        }
        return new XTSXtsResult(requestEnv, inputDoc);
    }
}

