/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.request;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.interpreter.instructions.IXTSOutputableInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.XTSSource;
import com.cognos.xts.output.XTSConstants;
import com.cognos.xts.output.XTSOutputObject;
import com.cognos.xts.output.XTSOutputSpecUtils;
import com.cognos.xts.util.ByteArrayIOStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.ParseException;
import org.dom4j.Document;
import org.dom4j.Element;

public final class XTSXtsResult
implements IXTSOutputableInstructionResult {
    private static final String XML_BASE_CONTENT_TYPE = "text/xml; charset=utf-8";
    private ContentType m_contentType = null;
    private XTSEnvironment m_requestEnv = null;
    private List m_cleanUpObjList = null;
    private InternetHeaders m_protocolHdrs = null;
    private InputStream m_in = null;
    private InputStream m_attIn = null;

    private XTSXtsResult() {
    }

    public XTSXtsResult(XTSEnvironment requestEnv, Document resultDoc) throws XTSInstructionException {
        this.m_requestEnv = requestEnv;
        Element outputElement = resultDoc.getRootElement().element("output");
        List protocolHeaderElemList = outputElement.elements(XTSConstants.ELEM_NM_PROTOCOLHEADER);
        for (Element protocolHeaderElem : protocolHeaderElemList) {
            List paramElemList = protocolHeaderElem.elements(XTSConstants.ELEM_NM_PARAM);
            if (paramElemList.size() <= 0) continue;
            this.m_protocolHdrs = new InternetHeaders();
            Element paramElem2 = null;
            for (Element paramElem2 : paramElemList) {
                this.m_protocolHdrs.addHeader(paramElem2.attributeValue("name"), paramElem2.getTextTrim());
            }
        }
        Element partElem = null;
        List partElemList = outputElement.elements(XTSConstants.ELEM_NM_PART);
        if (partElemList.size() > 0) {
            partElem = (Element)partElemList.get(0);
            try {
                this.m_in = XTSOutputSpecUtils.generateInputStream(this.m_requestEnv, partElem, false, this.m_cleanUpObjList, null);
            }
            catch (XTSException e) {
                throw new XTSInstructionException("protocol.xts.parseinternalresultfailed", e);
            }
        }
        if (partElemList.size() > 1) {
            partElem = (Element)partElemList.get(1);
            try {
                this.m_attIn = XTSOutputSpecUtils.generateInputStream(this.m_requestEnv, partElem, false, this.m_cleanUpObjList, null);
            }
            catch (XTSException e) {
                throw new XTSInstructionException("protocol.xts.parseinternalresultfailed", e);
            }
        }
    }

    @Override
    public XTSSource getResult() throws XTSInstructionException {
        return new XTSSource(this.m_in);
    }

    @Override
    public void release() throws XTSInstructionException {
        this.m_requestEnv.cleanup();
        if (this.m_cleanUpObjList != null) {
            for (XTSOutputObject outputObj : this.m_cleanUpObjList) {
                outputObj.release();
                Object var2_3 = null;
            }
            this.m_cleanUpObjList.clear();
        }
        try {
            if (this.m_in != null) {
                this.m_in.close();
                this.m_in = null;
            }
            if (this.m_attIn != null) {
                this.m_attIn.close();
                this.m_attIn = null;
            }
        }
        catch (IOException e) {
            throw new XTSInstructionException("protocol.ioexception", e);
        }
    }

    @Override
    public void writeCopyTo(OutputStream out) throws XTSInstructionException {
        if (this.m_in == null) {
            return;
        }
        try {
            ByteArrayIOStream bio = new ByteArrayIOStream();
            byte[] buf = new byte[4096];
            int bytesRead = this.m_in.read(buf, 0, 4096);
            while (bytesRead != -1) {
                bio.write(buf, 0, bytesRead);
                bytesRead = this.m_in.read(buf, 0, 4096);
            }
            bio.writeTo(out);
            this.m_in = bio.convert();
        }
        catch (IOException e) {
            Object[] args = new String[]{this.getClass().getName()};
            throw new XTSInstructionException("instruction.writetooutputstreamfailed", args, e);
        }
    }

    @Override
    public boolean attachmentsSupported() {
        return true;
    }

    @Override
    public int getSupportedOptionsBitMap() {
        return 31;
    }

    @Override
    public boolean statusHeaderSupported() {
        return false;
    }

    @Override
    public boolean protocolHeaderSupported() {
        return true;
    }

    @Override
    public InputStream getAttachmentInputStream() throws XTSInstructionException {
        return this.m_attIn;
    }

    @Override
    public InternetHeaders getStatusHeaders() throws XTSInstructionException {
        return null;
    }

    @Override
    public InternetHeaders getProtocolHeaders() throws XTSInstructionException {
        return this.m_protocolHdrs;
    }

    @Override
    public ContentType getDefaultMimeType() throws XTSInstructionException {
        if (this.m_contentType == null) {
            try {
                this.m_contentType = new ContentType(XML_BASE_CONTENT_TYPE);
            }
            catch (ParseException e) {
                Object[] args = new Object[]{XML_BASE_CONTENT_TYPE};
                throw new XTSInstructionException("protocol.invalidcontenttype", args, e);
            }
        }
        return this.m_contentType;
    }
}

