/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.transform;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.transform.ChecksumTransformResult;
import com.cognos.xts.interpreter.instructions.transform.IXTSTransformInstruction;
import com.cognos.xts.util.ByteArrayIOStream;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class ChecksumTransform
extends AXTSInstruction
implements IXTSTransformInstruction {
    private static final String PARAM_APPENDTO = "appendTo";
    private static final String PARAM_ID = "id";
    private String m_sIdentifier = null;
    private Checksum m_checksum = new CRC32();

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
    }

    @Override
    public void terminate() {
        this.m_sIdentifier = null;
    }

    @Override
    public boolean isInitialized() {
        return this.m_sIdentifier != null;
    }

    @Override
    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        InputStreamReader copy = null;
        String appendTo = UXTSInstructionUtils.getParameter(PARAM_APPENDTO, instParams);
        String id = UXTSInstructionUtils.getParameter(PARAM_ID, instParams);
        String checksumValue = null;
        try {
            ByteArrayIOStream bio = new ByteArrayIOStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)bio, "UTF-8"));
            char[] buf = new char[4096];
            int charsRead = body.read(buf, 0, 4096);
            while (charsRead != -1) {
                ((Writer)writer).write(buf, 0, charsRead);
                charsRead = body.read(buf, 0, 4096);
            }
            ((Writer)writer).flush();
            CRC32 checksum = new CRC32();
            checksum.update(bio.getBuf(), 0, bio.getBufSize());
            checksumValue = Long.toString(checksum.getValue());
            copy = new InputStreamReader((InputStream)bio.convert(), "UTF-8");
        }
        catch (Exception e) {
            Object[] args = new String[]{this.getClass().getName()};
            throw new XTSInstructionException("instruction.writetooutputstreamfailed", args, e);
        }
        return new ChecksumTransformResult(this, copy, appendTo, id, checksumValue);
    }
}

