/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.transform;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.XTSSAXWriter;
import com.cognos.xts.compiler.logicsheet.XTSLogicsheetTransfomer;
import com.cognos.xts.compiler.message.XTSMessageTransformer;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.transform.IXTSTransformInstruction2;
import com.cognos.xts.interpreter.instructions.transform.XTSTransformResult;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.resource.PathUtils;
import com.cognos.xts.resource.XTSResourceManager;
import com.cognos.xts.util.ByteArrayIOStream;
import com.cognos.xts.util.CharArrayReaderWriter;
import com.cognos.xts.util.LocaleUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Document;
import org.dom4j.io.DocumentSource;
import org.xml.sax.XMLReader;

public final class JDTransform
extends AXTSInstruction
implements IXTSTransformInstruction2 {
    private static final int CHAR_BUFFER_SIZE = 4096;
    private static final int OUTPUT_BUFFER_SIZE = 8192;
    private static final String XSLT_CLASS_NAME = "jd.xml.xslt.trax.TransformerFactoryImpl";
    private String m_sIdentifier = null;
    private Templates m_cachedTemplate = null;
    private URIResolver m_uriResolver = null;
    private String m_systemId = null;

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
        this.m_systemId = UXTSInstructionUtils.getParameter("systemId", instParams);
        if (this.m_systemId == null) {
            Object[] args = new String[]{this.m_sIdentifier, "systemId"};
            throw new XTSInstructionException("transformer.missingparam", args);
        }
        this.m_uriResolver = (URIResolver)instParams.get("uriResolver");
        Source stylesheetSource = null;
        String src = UXTSInstructionUtils.getParameter("src", instParams);
        if (src != null) {
            stylesheetSource = new StreamSource(new StringReader(src), this.m_systemId);
        }
        try {
            String[] messageBases;
            String[] logicSheets;
            if (stylesheetSource == null) {
                if (this.m_systemId.indexOf(58) == -1) {
                    String sTemplateRoot = PropertiesManager.getInstance().getProperty("template.root");
                    try {
                        String name = PathUtils.buildPath(this.m_systemId);
                        InputStream is = null;
                        try {
                            is = XTSResourceManager.getInstance().getResource(name);
                        }
                        catch (XTSException e) {
                            Object[] args = new String[]{this.m_sIdentifier, sTemplateRoot, this.m_systemId};
                            throw new XTSInstructionException("instruction.buildfullpathfailed", args, e);
                        }
                        if (is == null) {
                            Object[] args = new String[]{this.m_sIdentifier, sTemplateRoot, this.m_systemId};
                            throw new XTSInstructionException("instruction.buildfullpathfailed", args);
                        }
                        stylesheetSource = new StreamSource(is);
                        ((StreamSource)stylesheetSource).setSystemId(name);
                    }
                    catch (IOException e) {
                        Object[] args = new String[]{this.m_sIdentifier, sTemplateRoot, this.m_systemId};
                        throw new XTSInstructionException("instruction.buildfullpathfailed", args, e);
                    }
                }
                stylesheetSource = new StreamSource(this.m_systemId);
            }
            if ((logicSheets = (String[])instParams.get("logicsheet")) != null) {
                ArrayList<String> lsList = new ArrayList<String>();
                for (int i = 0; i < logicSheets.length; ++i) {
                    lsList.add(logicSheets[i]);
                }
                stylesheetSource = XTSLogicsheetTransfomer.applyLogicsheets(env, stylesheetSource, lsList, this.m_uriResolver);
            }
            String[] messageBaseLocalesStr = (String[])instParams.get("messageBaseLocale");
            ArrayList<Locale> messageBaseLocales = null;
            if (messageBaseLocalesStr != null) {
                messageBaseLocales = new ArrayList<Locale>();
                Locale messageBaseLocale = null;
                for (int i = 0; i < messageBaseLocalesStr.length; ++i) {
                    messageBaseLocale = LocaleUtils.toLocale(LocaleUtils.toNormalizedString(messageBaseLocalesStr[i]));
                    if (messageBaseLocale == null) continue;
                    messageBaseLocales.add(messageBaseLocale);
                }
            }
            if ((messageBases = (String[])instParams.get("messageBase")) != null) {
                ArrayList<String> msgFiles = new ArrayList<String>();
                for (int i = 0; i < messageBases.length; ++i) {
                    msgFiles.add(messageBases[i].trim());
                }
                stylesheetSource = XTSMessageTransformer.applyMessage(env, stylesheetSource, msgFiles, messageBaseLocales);
            }
            TransformerFactory factory = (TransformerFactory)Class.forName(XSLT_CLASS_NAME).newInstance();
            factory.setURIResolver(this.m_uriResolver);
            this.m_cachedTemplate = factory.newTemplates(stylesheetSource);
        }
        catch (TransformerException e) {
            Object[] args = new String[]{this.m_sIdentifier, this.m_systemId};
            throw new XTSInstructionException("transformer.compileerror", args, e);
        }
        catch (XTSException e) {
            Object[] args = new String[]{this.m_sIdentifier, this.m_systemId};
            throw new XTSInstructionException("transformer.compileerror", args, e);
        }
        catch (Exception e) {
            Object[] args = new String[]{XSLT_CLASS_NAME};
            throw new XTSInstructionException("transformer.instantiationerror", args, e);
        }
    }

    @Override
    public void terminate() {
        this.m_sIdentifier = null;
        this.m_cachedTemplate = null;
        this.m_uriResolver = null;
    }

    @Override
    public boolean isInitialized() {
        return this.m_cachedTemplate != null;
    }

    @Override
    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        StreamSource source = new StreamSource(body);
        return this.executeBody(instAtts, instParams, source);
    }

    @Override
    public IXTSInstructionResult execute(XTSEnvironment env, Document doc, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        IXTSInstructionResult result = null;
        String sAttValue = (String)instAtts.get("nodelist");
        if (sAttValue != null) {
            HashMap<String, Object> nodemap = new HashMap<String, Object>();
            StringTokenizer st = new StringTokenizer(sAttValue, ",");
            while (st.hasMoreTokens()) {
                nodemap.put(st.nextToken().trim(), null);
            }
            DocumentSource docsrc = new DocumentSource(doc);
            XTSSAXWriter writer = new XTSSAXWriter(nodemap);
            docsrc.setXMLReader((XMLReader)((Object)writer));
            result = this.executeBody(instAtts, instParams, (Source)docsrc);
        } else {
            StreamSource source = new StreamSource(body);
            result = this.executeBody(instAtts, instParams, source);
        }
        return result;
    }

    private IXTSInstructionResult executeBody(Map instAtts, Map instParams, Source source) throws XTSInstructionException {
        XTSTransformResult result = null;
        try {
            String option;
            String[] parameters;
            String mediaType;
            Transformer transformer = this.m_cachedTemplate.newTransformer();
            transformer.setURIResolver(this.m_uriResolver);
            String encoding = UXTSInstructionUtils.getParameter("encoding", instParams);
            if (encoding != null) {
                transformer.setOutputProperty("encoding", encoding);
            }
            if ((mediaType = UXTSInstructionUtils.getParameter("mediaType", instParams)) != null) {
                transformer.setOutputProperty("media-type", mediaType);
            }
            if ((parameters = (String[])instParams.get("parameter")) != null) {
                for (int i = 0; i < parameters.length; ++i) {
                    int pos = parameters[i].indexOf("=");
                    if (pos == -1) continue;
                    transformer.setParameter(parameters[i].substring(0, pos), parameters[i].substring(pos + 1));
                }
            }
            String string = option = instAtts == null ? null : (String)instAtts.get("option");
            if (option != null && (option.equals("part") || option.equals("content"))) {
                ByteArrayIOStream bio = new ByteArrayIOStream(8192);
                transformer.transform(source, new StreamResult(bio));
                StringBuffer defaultContentType = new StringBuffer(transformer.getOutputProperty("media-type"));
                defaultContentType.append("; ");
                defaultContentType.append("charset");
                defaultContentType.append("=");
                defaultContentType.append(transformer.getOutputProperty("encoding"));
                result = new XTSTransformResult(this, bio.convert(), defaultContentType.toString());
            } else {
                CharArrayReaderWriter rw = new CharArrayReaderWriter(4096);
                transformer.transform(source, new StreamResult(rw));
                result = new XTSTransformResult(this, rw.convert());
            }
        }
        catch (TransformerConfigurationException e) {
            Object[] args = new String[]{this.m_sIdentifier, this.m_systemId};
            throw new XTSInstructionException("transformer.processerror", args, e);
        }
        catch (TransformerException e) {
            Object[] args = new String[]{this.m_sIdentifier, this.m_systemId};
            throw new XTSInstructionException("transformer.processerror", args, e);
        }
        return result;
    }
}

