/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.transform;

import com.cognos.xts.resource.XTSResourceManager;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaEntityResolver
implements EntityResolver {
    public static final String FILE_PROTOCOL = "file://";
    public static final String HTTP_PROTOCOL = "http://";
    public static final String XTS_SCHEMAS_LOC = "/interpreter/instructions/transform/schemas/";
    public static final String XML_SCHEMA_DTD = "/interpreter/instructions/transform/schemas/XMLSchema.dtd";
    public static final String DATATYPES_DTD = "/interpreter/instructions/transform/schemas/datatypes.dtd";
    public static final String XML_XSD = "/interpreter/instructions/transform/schemas/xml.xsd";
    private String m_sPathIdentifier = null;

    public SchemaEntityResolver(String pathIdentifier) {
        this.m_sPathIdentifier = pathIdentifier;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource retSource = null;
        InputStream in = null;
        if (systemId == null) {
            return null;
        }
        try {
            int pathPos;
            if (systemId.startsWith(HTTP_PROTOCOL)) {
                if (systemId.equals("http://www.w3.org/2001/xml.xsd")) {
                    in = XTSResourceManager.getInstance().getResource(XML_XSD);
                } else if (systemId.equals("http://www.w3.org/2001/datatypes.dtd")) {
                    in = XTSResourceManager.getInstance().getResource(DATATYPES_DTD);
                }
            } else if (systemId.startsWith(FILE_PROTOCOL) && (pathPos = systemId.indexOf(this.m_sPathIdentifier)) != -1) {
                String filename = systemId.substring(pathPos + this.m_sPathIdentifier.length());
                in = XTSResourceManager.getInstance().getResource(filename);
                if (in == null) {
                    in = publicId != null && publicId.equals("-//W3C//DTD XMLSCHEMA 200102//EN") ? XTSResourceManager.getInstance().getResource(XML_SCHEMA_DTD) : (publicId != null && publicId.equals("datatypes") ? XTSResourceManager.getInstance().getResource(DATATYPES_DTD) : XTSResourceManager.getInstance().getResource(XTS_SCHEMAS_LOC + filename));
                }
            }
        }
        catch (Exception e) {
            in = null;
        }
        if (in != null) {
            retSource = new InputSource(in);
            retSource.setSystemId(this.m_sPathIdentifier);
        }
        return retSource;
    }
}

