/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xts.interpreter.instructions.transform;

import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXReaderPool;
import com.cognos.xts.configuration.IXTSConfiguration;
import com.cognos.xts.configuration.XTSConfigManager;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.transform.IXTSTransformInstruction;
import com.cognos.xts.interpreter.instructions.transform.SchemaEntityResolver;
import com.cognos.xts.interpreter.instructions.transform.XTSFilterTransformResult;
import com.cognos.xts.interpreter.instructions.transform.XTSTransformResult;
import com.cognos.xts.logging.IXTSLogger;
import com.cognos.xts.logging.XTSTraceLoggerManager;
import com.cognos.xts.properties.PropertiesManager;
import com.cognos.xts.resource.PathUtils;
import com.cognos.xts.resource.XTSResourceManager;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class SchemaValidationTransform
extends AXTSInstruction
implements IXTSTransformInstruction,
ErrorHandler {
    private static final String ATT_NM_EXTERNAL_SCHEMA_LOCATION = "schemaLocation";
    private static final String ATT_NM_NO_NS_EXTERNAL_SCHEMA_LOCATION = "noNamespaceSchemaLocation";
    private static final String ATT_NM_ENABLED = "enabled";
    private static final String ATT_VL_FALSE = "false";
    private static final String PROPERTY_EXTERNAL_SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    private static final String PROPERTY_EXTERNAL_NO_NS_SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    private static final String FEATURE_VALIDATION_SCHEMA = "http://apache.org/xml/features/validation/schema";
    private static final String NAMESPACE_FEATURE = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    public static final String HTTP_PROTOCOL = "http://";
    public static final String FILE_PROTOCOL = "file://";
    private String m_sTemplateRoot = null;
    private String m_sEffectiveTemplateRoot = null;
    private String m_sIdentifier = null;

    @Override
    public String getIdentifier() {
        return this.m_sIdentifier;
    }

    @Override
    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_sIdentifier = identifier;
        this.m_sTemplateRoot = PropertiesManager.getInstance().getProperty("template.root");
        try {
            IXTSConfiguration config = XTSConfigManager.getInstance().getConfiguration();
            if (config != null) {
                this.m_sEffectiveTemplateRoot = config.getPhysicalPath(this.m_sTemplateRoot) + "/";
            }
        }
        catch (Exception e) {
            this.m_sEffectiveTemplateRoot = this.m_sTemplateRoot + "/";
        }
    }

    @Override
    public void terminate() {
        this.m_sIdentifier = null;
    }

    @Override
    public boolean isInitialized() {
        return this.m_sIdentifier != null;
    }

    @Override
    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        Object[] args;
        XMLReader reader;
        Document doc;
        block19: {
            SAXParserFactory factory;
            block18: {
                String paramValue = UXTSInstructionUtils.getParameter(ATT_NM_ENABLED, instParams);
                if (paramValue != null && paramValue.trim().equals(ATT_VL_FALSE)) {
                    return new XTSFilterTransformResult(this, body);
                }
                String sExternalLocation = this.getExternalSchemaLocation(env, instParams);
                String sExternalNoNSLocation = this.getExternalNoNamespaceSchemaLocation(env, instParams);
                AXTSPoolObject saxReader = null;
                try {
                    saxReader = XTSSAXReaderPool.getInstance().acquire();
                }
                catch (XTSException e) {
                    Object[] args2 = new Object[]{this.m_sIdentifier};
                    throw new XTSInstructionException("transformer.aquirereaderfailed", args2, e);
                }
                doc = null;
                try {
                    doc = ((SAXReader)saxReader.get()).read(new InputSource(body));
                }
                catch (Exception e) {
                    Object[] args3 = new Object[]{this.m_sIdentifier};
                    throw new XTSInstructionException("transformer.parsefailed", args3, e);
                }
                finally {
                    XTSSAXReaderPool.getInstance().put(saxReader);
                }
                Element rootElem = doc.getRootElement();
                Namespace xsiNamespace = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                rootElem.add(xsiNamespace);
                if (sExternalLocation != null) {
                    rootElem.addAttribute(new QName(ATT_NM_EXTERNAL_SCHEMA_LOCATION, xsiNamespace, "xsi:schemaLocation"), sExternalLocation);
                }
                if (sExternalNoNSLocation != null) {
                    rootElem.addAttribute(new QName(ATT_NM_NO_NS_EXTERNAL_SCHEMA_LOCATION, xsiNamespace, "xsi:noNamespaceSchemaLocation"), sExternalNoNSLocation);
                }
                factory = SAXParserFactory.newInstance();
                factory.setValidating(true);
                factory.setNamespaceAware(true);
                try {
                    factory.setFeature(NAMESPACE_FEATURE, true);
                    factory.setFeature(NAMESPACE_PREFIXES_FEATURE, false);
                    factory.setFeature(VALIDATION_FEATURE, true);
                }
                catch (Exception e) {
                    if (!XTSTraceLoggerManager.getInstance().isEnabled[3][0]) break block18;
                    StringBuffer msg = new StringBuffer();
                    msg.append("SAX factory set feature failed...\n");
                    msg.append("  message: ").append(e.getMessage()).append("\n");
                    IXTSLogger logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0);
                    if (logger == null) break block18;
                    logger.log(env, 8, msg.toString(), null, null);
                }
            }
            reader = null;
            SAXParser parser = null;
            try {
                parser = factory.newSAXParser();
                reader = parser.getXMLReader();
                reader.setFeature(FEATURE_VALIDATION_SCHEMA, true);
                reader.setEntityResolver(new SchemaEntityResolver(this.m_sEffectiveTemplateRoot));
                reader.setErrorHandler(this);
            }
            catch (Exception e) {
                if (!XTSTraceLoggerManager.getInstance().isEnabled[3][0]) break block19;
                StringBuffer msg = new StringBuffer();
                msg.append("SAX reader set feature failed...\n");
                msg.append("  message: ").append(e.getMessage()).append("\n");
                IXTSLogger logger = XTSTraceLoggerManager.getInstance().getLogger(3, 0);
                if (logger == null) break block19;
                logger.log(env, 8, msg.toString(), null, null);
            }
        }
        String xml = doc.asXML();
        try {
            InputSource in = new InputSource(new StringReader(xml));
            in.setSystemId(this.m_sEffectiveTemplateRoot);
            reader.parse(in);
        }
        catch (SAXException e) {
            args = new Object[]{this.m_sIdentifier};
            throw new XTSInstructionException("transformer.schemavalidate.validatefailed", args, e);
        }
        catch (IOException e) {
            args = new Object[]{this.m_sIdentifier};
            throw new XTSInstructionException("transformer.schemavalidate.failedtoreadcontents", args, e);
        }
        return new XTSTransformResult(this, new StringReader(xml));
    }

    private String getExternalNoNamespaceSchemaLocation(XTSEnvironment env, Map instParams) throws XTSInstructionException {
        String sExternalNoNSLocation = UXTSInstructionUtils.getParameter(ATT_NM_NO_NS_EXTERNAL_SCHEMA_LOCATION, instParams);
        if (sExternalNoNSLocation != null && !sExternalNoNSLocation.startsWith(HTTP_PROTOCOL) && !sExternalNoNSLocation.startsWith(FILE_PROTOCOL)) {
            String sFileName = null;
            try {
                sFileName = PathUtils.buildPath(sExternalNoNSLocation);
                if (!XTSResourceManager.getInstance().exists(sFileName)) {
                    Object[] args = new String[]{this.m_sIdentifier, sFileName};
                    throw new XTSInstructionException("transformer.schemavalidate.fileopenfailed", args);
                }
                sExternalNoNSLocation = sFileName;
            }
            catch (IOException e) {
                Object[] args = new String[]{this.m_sIdentifier, sExternalNoNSLocation};
                throw new XTSInstructionException("transformer.schemavalidate.fileopenfailed", args, e);
            }
            catch (XTSException e) {
                Object[] args = new String[]{this.m_sIdentifier, sExternalNoNSLocation};
                throw new XTSInstructionException("transformer.schemavalidate.fileopenfailed", args, e);
            }
        }
        return sExternalNoNSLocation;
    }

    private String getExternalSchemaLocation(XTSEnvironment env, Map instParams) throws XTSInstructionException {
        String sExternalLocation = null;
        String[] paramValues = (String[])instParams.get(ATT_NM_EXTERNAL_SCHEMA_LOCATION);
        if (paramValues != null && paramValues.length > 0) {
            StringBuffer sExternalLocationBuf = new StringBuffer();
            sExternalLocation = "";
            for (int i = 0; i < paramValues.length; ++i) {
                sExternalLocationBuf.append(paramValues[i]);
                sExternalLocationBuf.append(" ");
            }
            sExternalLocation = sExternalLocationBuf.toString();
        }
        if (sExternalLocation != null) {
            String sTouchedUpExternalLocation = null;
            StringTokenizer st = new StringTokenizer(sExternalLocation, " ");
            while (st.hasMoreTokens()) {
                String ns = st.nextToken();
                if (!st.hasMoreTokens()) {
                    Object[] args = new Object[]{ATT_NM_EXTERNAL_SCHEMA_LOCATION};
                    throw new XTSInstructionException("schemavalidate.invalidschemalocationsyntax", args);
                }
                sTouchedUpExternalLocation = sTouchedUpExternalLocation == null ? ns : sTouchedUpExternalLocation + " " + ns;
                String loc = st.nextToken();
                if (!loc.startsWith(HTTP_PROTOCOL) && !loc.startsWith(FILE_PROTOCOL)) {
                    String sFileName = null;
                    try {
                        sFileName = PathUtils.buildPath(loc);
                        if (!XTSResourceManager.getInstance().exists(sFileName)) {
                            Object[] args = new String[]{this.m_sIdentifier, sFileName};
                            throw new XTSInstructionException("transformer.schemavalidate.fileopenfailed", args);
                        }
                        sTouchedUpExternalLocation = sTouchedUpExternalLocation + " ";
                        sTouchedUpExternalLocation = sTouchedUpExternalLocation + sFileName;
                        continue;
                    }
                    catch (IOException e) {
                        Object[] args = new String[]{this.m_sIdentifier, loc};
                        throw new XTSInstructionException("transformer.schemavalidate.fileopenfailed", args, e);
                    }
                    catch (XTSException e) {
                        Object[] args = new String[]{this.m_sIdentifier, loc};
                        throw new XTSInstructionException("transformer.schemavalidate.fileopenfailed", args, e);
                    }
                }
                sTouchedUpExternalLocation = sTouchedUpExternalLocation + " " + loc;
            }
            sExternalLocation = sTouchedUpExternalLocation;
        }
        return sExternalLocation;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        throw e;
    }
}

